﻿FUI.ns('FCS.PcApp');
FCS.PcApp.CommentMe = {
	comments:[],
	feeds:[],
	getcommentsurl:FCE.common.clientdomain()+ '/feedoperation/fetchcommented',
	timeSpan: 60000,
	duration: 0,
	offset:-1,
	startTime:null,
	loadTimes:0,
	islock:false,
	init:function(){
		var t = this;
		this.ct = $('#loadcontent');
		this.lo = $('#load');
		this.mo = $('#more');
		this.nodata = $('#nodata');
		this.error = $('#error');
		this.fload = $('#firstloadfeed');
		
		this.loadDataBase();
		this.bind();
		this.timeThread = 0;
		t.timeThread = window.setTimeout(function() { t.resetTime(); }, t.timeSpan);
	},
	resetTime: function() {
		try{
			var t = this;
			window.clearTimeout(t.timeThread);
			t.duration++;
			t.startTime.setMinutes(t.startTime.getMinutes() + 1);
		
			$("a[et='timer']").each(function() {
				var obj = $(this);
				var time = FCE.common.formatTime(obj.attr('ev'),t.startTime);
				obj.html(time);
			});

			t.timeThread = window.setTimeout(function() { t.resetTime(); }, t.timeSpan);
		}
		catch(e){
			//alert(e.name + ": " + e.message);
		}
	},
	bind:function(){
		var t = this;
		$('#more').bind('click',function(){t.loadDataBase()});
	},
	loadDataBase:function(){
		var t = this;
		if(!t.islock)
		{
			t.islock = true;
			try{
			
				if(t.comments.length >0){
					t.ct.show();
					t.lo.show();
				}
				else{
					t.fload.show();
				}
				
				t.mo.hide();
				
				var data = {};
				if(t.offset >0){
					data['offset'] = t.offset;
				}
				
				$.ajax({
					url: this.getcommentsurl,
					type: "GET",
					data: data,
					dataType: "json",
					cache: false,
					success:function(data){
						t.fload.hide();
						t.loadCallBack(data);

					},
					error:function(){
						t.islock = false;
					}
				});
			}
			catch(e)
			{
				t.error.show();
				//alert(e.name + ": " + e.message);
				t.islock = false;
			}
		}
		
	},
	loadCallBack:function(data){
		var t = this;
		
		// 无评论
		if(t.comments.length < 1 && data.comments.length < 1){
			
			t.nodata.show();
			t.islock = false;
			t.ct.hide();
			t.lo.hide();
			return;
		}
		
		var html = [];
		var currcomments = [];
		
		//t.comments 
		currcomments = data.comments;
		
		if(!t.startTime){
			t.startTime = FCE.common.parseDate(data.time);
		}
		
		if(currcomments.length > 0){
			t.offset = currcomments[currcomments.length-1].commentId;
		}
		
		$.each(data.feeds,function(i,v){
			t.feeds[v.feedId] = v;
		});
		
		$.each(currcomments,function(i,v){
			t.comments[v.commentId] = v;
		});
		
		$.each(currcomments,function(i,v){
			html.push(t.formatItem(v));
		});
		
		t.ct.hide();
		t.lo.hide();
		
		if(t.offset > 0){
			$('#commentlist').append(html.join(''));
		}
		else{
			$('#commentlist').html(html.join(''));
		}
		
		t.loadTimes++;
		t.islock = false;
		
		if(t.loadTimes >= 4){
			t.mo.show();
			t.ct.show();
		}
		FCE.common.fixSummaryLink();
		// 替换所有A链接事件
		//FCE.common.fixHref();
	},
	// 调用回复窗口 用户回复对应评论
	addReplay: function(id)
	{
	    var obj = this.comments[id];
	    var params = getRevertParams(obj);
	    params = toJson(params);
	    var queryString = makePageParam(params);
	    FCE.common.openLocal({ url: "comment.htm?fc=" + queryString,
	        title: "回复",
	        width: 376,
	        height: 182
	    });
	},
	formatItem:function(c){
	return '<li class="gride48m0" regid="401492"><div class="main ufeed"><div class="mainw">{0}{1}\
				<div class="b"><div class="feedinf"><div class="inf"><span><a href="javascript:void(0);" onclick="FCS.PcApp.CommentMe.addReplay({3});" regid="401642">回复</a></span>\
				</div></div></div></div></div>{2}</li>'.format(this.formatCommentContent(c),this.formatCommentFeedItem(c.feedId),this.formatAuther(c),c.commentId);
	},
	formatAuther:function(c){
		return '<div class="extra upic"><a href="{0}"><img src="{1}" alt=""></a></div>'.format(this.getUserHomePage(c.userId),FCE.common.portraitdomain+c.userPortrait);
	},
	formatCommentContent:function(c){
		return '<div class="t"><a href="{0}" class="">{1}</a>\
				<span class="time"><a href="{2}" class="" et="timer" ev="{5}">{3}</a>\
				</span><p><span class="userz">{4}</span></p></div>'.format(
				this.getUserHomePage(c.userId),
				c.userName,
				this.getFeedDetailLink(c.feedId),
				FCE.common.formatTime(c.publishTime,this.startTime),
				c.content,
				c.publishTime);
	},
	formatCommentFeedItem:function(id){
		var f = this.feeds[id];
		if(f){
			var content = '<div class="c"><div class="quote"><div class="c"><p><span class="sys">评论了{0}:</span><span class="userz"><a href="{1}" class="">{2}</a></span></p></div></div></div>';
			return content.format(f.title,this.getFeedDetailLink(f.feedId),f.content);
		}
	},
	getFeedDetailLink:function(id){
		return '{0}/feed/{1}'.format(FCE.common.domain,id);
	},
	getUserHomePage:function(id){
		return '{0}/{1}'.format(FCE.common.domain,id);
	}
};


$(document).ready(function() {
	FCS.PcApp.NavBar.init(FCS.PcApp.NavBar.commentPage);
	FCS.PcApp.CommentMe.init();
	$('body').bind('click',function(e){FCE.common.alinkEventHandler(e)});
	
	$("#scrollclient").scroll(function() {
	
		var scrollHeight = this.scrollHeight;
		
		if (this.scrollTop + this.clientHeight >= scrollHeight) {
			if(FCS.PcApp.CommentMe.loadTimes < 4){
				FCS.PcApp.CommentMe.loadDataBase();
			}
		}

	});
	FCS.PcApp.watracer.PV('http://juxiang.com/pctab/comment', 'pctab/comment');
	$('body').bind('click', function(e) { FCS.PcApp.watracer.reg(e) });
});