/***** BEGIN LICENSE BLOCK *****

    FlashGot - a Firefox extension for external download managers integration
    Copyright (C) 2004-2010 Giorgio Maone - g.maone@informaction.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
                             
***** END LICENSE BLOCK *****/

const CI = Components.interfaces;
const CC = Components.classes;

const g_rxOpt=/^(inv|)opt-(.*)/;
var g_downloadManagers = null;
var g_opts = null;
var g_extList = null;
var g_extText = null;
var g_extDirty = false;
var g_referrerRadio = null;
var g_referrerText = null;
var g_tmpDir = null;
var g_wellGetPath = null;

var g_cust = gFlashGotService && {
  dummy: gFlashGotService.createCustomDM(""),
  map: {},
  createEntry: function(obj, isNew) {
    if(!obj.custom) return null;
    const name=obj.name;
    const map=this.map;
    return map[name] ? map[name]
      : map[name]={
          _dirty: false,
          _deleted: false, 
          _new: isNew,
          supported: true,
          name: name,
          argsTemplate: obj.argsTemplate,
          exeFile: isNew?obj.locateExeFile(name):obj.exeFile
        };
  },
  get current() {
    if(!g_downloadManagers.selectedItem) return null;
    const dmName=g_downloadManagers.selectedItem.getAttribute("label");
    
    if( (!dmName) || dmName=="---") return null;
    var dm = gFlashGotService.DMS[dmName];
    if(dm) {
      return this.createEntry(dm,false);
    }
    this.dummy.name=dmName;
    return this.createEntry(this.dummy,true);
  },
  add: function() {
    const ps = CC["@mozilla.org/embedcomp/prompt-service;1"
      ].getService(CI.nsIPromptService);
    const ret={ value: "" };
    const title=gFlashGotService.getString("custom.new.title");
    var name;
    if(ps.prompt(window,
          title,
          gFlashGotService.getString("custom.new.text"),
          ret, null, {}) && 
       (name = ret.value) ) {
      if(/,|^(?:\d+|\s+|---)$/.test(name) ||
          gFlashGotService.DMS[name] || this.map[name]) {
        ps.alert(window,title,gFlashGotService.getString("custom.new.error"));
        return;
      }
      const dummy = this.dummy;
      dummy.name = name;
      this.createEntry(dummy, true);
      fgo_populateDMS(name);
    }
  },
  remove: function() {
    var dm=this.current;
    if(dm) {
      dm._deleted=true;
      fgo_populateDMS();
    }
  },
  locateExe: function() {
    const cur=this.current;
    if(cur) {
      var f=this.dummy.locateExeFile(this.current.name);
      if(f) {
        cur.exeFile=f;
        cur._dirty=true;
      }
      this.syncUI();
    }
  }
,
  argsChanged: function(txtArgs) {
    const cur=this.current;
    var val=txtArgs.value.replace(/['"`]/g,'');
    if(val!=txtArgs.value) {
      document.getElementById("quoteWarn").showPopup(txtArgs,-1, -1, "tooltip", "topleft", "bottomleft");
      selEnd=txtArgs.selectionEnd;
      txtArgs.value=val;
      try {
        txtArgs.selectionEnd=selEnd-1;
      } catch(ex) {}
    }
    if(cur && cur.argsTemplate!=val) {
      cur.argsTemplate=val;
      cur._dirty=true;
    }
  }
,
  syncUI: function() {
    var dm = this.current;
    document.getElementById("dmsdeck").setAttribute(
      "selectedIndex", dm ? "0" : "1");
    if(dm) {
      document.getElementById("customDM-exeFile").value = 
        dm.exeFile ? dm.exeFile.path : "";
      document.getElementById("customDM-args").value = dm.argsTemplate;
      var ph=document.getElementById("ph-");
      var popup=ph.parentNode;
      while(ph.nextSibling) {
        popup.removeChild(ph.nextSibling);
      }
      const PHS=this.dummy.PLACEHOLDERS;
      if(PHS) {
        var phName;
        for(var j=0, len=PHS.length; j<len; j++) {
          phName=PHS[j];
          ph=ph.cloneNode(true);
          ph.removeAttribute("hidden");
          ph.setAttribute("id","ph-"+phName);
          ph.setAttribute("label",gFlashGotService.getString("ph."+phName));
          popup.appendChild(ph);
        }
      }
    }
  }
,
 insertPH: function(id) {
   const phName="["+id.substring(3)+"]";
   const txtArgs=document.getElementById("customDM-args")
   var selStart=txtArgs.selectionStart;
   var selEnd=txtArgs.selectionEnd;
   txtArgs.value=txtArgs.value.substring(0,selStart)+phName+txtArgs.value.substring(selEnd);
   txtArgs.selectionStart=txtArgs.selectionEnd=selStart+phName.length;
 }
,
 save: function() {
   const map=this.map;
   var dm,target;
   for(var name in map) {
     dm=map[name];
     target=null;
     if(dm._deleted) {
       gFlashGotService.removeCustomDM(name);
     } else if(dm._new) {
       target = gFlashGotService.createCustomDM(name);
     } else if(dm._dirty) {
       target = gFlashGotService.DMS[name];
     }
     if(target) {
       target.argsTemplate=dm.argsTemplate;
       target.exeFile=dm.exeFile;
     }
   }
 }
};
function fgo_onload() {
  if(!gFlashGotService) {
    document.getElementById("mainTabbox").setAttribute("hidden","true");
    document.getElementById("badInstall").removeAttribute("hidden");
    document.getAnonymousElementByAttribute(document
            .getElementById("flashgotOptions"),"dlgtype","cancel")
            .setAttribute("hidden","true");
    return;
  }
  
  if (!gFlashGotService.smUninstaller) {
    document.documentElement.getButton("extra2").hidden = true;
  }
  
  try {
      g_wellGetPath = gFlashGotService.prefs.getComplexValue("WellGet.path", CI.nsILocalFile);
      document.getElementById("wellget-text").value = g_wellGetPath.path;
  } catch(ex) {}
   
  
  if(gFlashGotService.mailer) { 
    // Thunderbird will handle "simple" clicks through Firefox
    document.getElementById("tab-downloads").setAttribute("collapsed","true");
  }
  
  g_downloadManagers = document.getElementById("downloadManagers");
  g_opts = document.getElementsByTagName("checkbox");
  
  fgo_populateDMS();
  
  var j,len;
  
  g_extList = document.getElementById("ext-list");
  g_extText = document.getElementById("ext-text");
  g_extList.removeItemAt(0);

  for each(var e in gFlashGotService.extensions) {
    if (e) g_extList.appendItem(e, e);
  }
  g_extDirty = false;
  
  fgo_visitCheckboxes(
    function(prefName,inverse,checkbox) {
      var val=gFlashGotService.getPref(prefName);
      checkbox.checked=inverse?!val:val;
    }
  );
  
  g_referrerRadio=document.getElementById("referrer-radio");
  g_referrerText=document.getElementById("referrer-text");
  g_referrerRadio.selectedIndex=gFlashGotService.getPref("autoReferrer") ? 0 : 1;
  g_referrerText.value=gFlashGotService.getPref("fakeReferrer","");
  fgo_syncReferrer();
  g_referrerRadio.addEventListener("select", fgo_syncReferrer, true);
  
  
  g_downloadManagers.addEventListener("popuphidden", fgo_syncDMOptions, true);
  try {
    g_tmpDir = gFlashGotService.prefs.getComplexValue("tmpDir", CI.nsILocalFile);
  } catch(ex) {
     g_tmpDir = gFlashGotService.tmpDir.parent;
  }
  if(g_tmpDir) {
    document.getElementById("tmpdir-text").value =g_tmpDir.path;
  }
  
  document.getElementById("interception-rg").selectedItem=
    document.getElementById("intercept"+
      (gFlashGotService.getPref("interceptAll")?"All":"Ext")+"-radio");
}

function fgo_populateDMS(name) {
  const defaultDM = gFlashGotService.defaultDM;
  const dms = gFlashGotService.DMS;
  const dmList = [].concat(gFlashGotService.DMS);

  const map = g_cust.map;
  var dm;
  for(p in map) {
    dm=map[p];
    if( ! (dm._deleted || p in dms) ) {
      dmList.push(map[p]);
    }
  }
  
  if(!name) name = defaultDM;
  
  var j, len, menuItem;
  
  g_downloadManagers.removeAllItems();
  g_downloadManagers.selectedItem=null;
  
  var custom;
  var found=false;
  for(j = 0, len=dmList.length; j<len; j++) {
    dm=dmList[j];
    if((custom=g_cust.createEntry(dm,false)) && custom._deleted) {
      continue;
    }
    
    menuItem = g_downloadManagers.appendItem(dm.name,dm.codeName);
    
    if(dm.supported) {
      if(!found) {
        found = (name == dm.name);
        if(found || !g_downloadManagers.selectedItem) {
          g_downloadManagers.selectedItem=menuItem;
        }
      }
    } else {
      if(!dm.shouldList()) menuItem.setAttribute("disabled", "true");
    }
  }
  
  
  if(g_downloadManagers.selectedItem) {
    document.getElementById("nodms").setAttribute("collapsed","true");
  } else {
    g_downloadManagers.selectedItem=g_downloadManagers.appendItem("---",null);
    document.getElementById("nodms").removeAttribute("collapsed");
  }
  
  fgo_syncDMOptions();
}

function fgo_interceptionSelected(rg) {
  document.getElementById('extensions-box').style.visibility=
    rg.selectedItem && rg.selectedItem.id=='interceptAll-radio' ? "hidden":"visible";
}

function fgo_syncDMOptions() {
  const dmrx = g_downloadManagers.value ?
    new RegExp("\\b" + g_downloadManagers.value + "\\b")
    :null;
  const dmopts = document.getElementsByAttribute("class", "dm-opt");
  var dmid, dmopt;
  for(var j = dmopts.length; j-->0;) {
    dmopt = dmopts[j];
    if(dmrx) {
      dmid = dmopt.id;
      if(dmid) {
        dmopt.setAttribute("hidden", dmid.match(dmrx) ? "false" : "true" );
      }
    } else {
      dmopt.setAttribute("hidden", "true" );
    }
  }
  var dmName = fgo_currentDmName();
  document.getElementById("shownInContextMenu").checked = dmName && ((dmName in shownInContextMenu) 
    ? shownInContextMenu[dmName] : gFlashGotService.DMS[dmName].shownInContextMenu);

  g_cust.syncUI();
}

function fgo_syncReferrer() {
  if(g_referrerRadio.selectedIndex == 1) {
    g_referrerText.removeAttribute("disabled");
  } else {
    g_referrerText.setAttribute("disabled","true");
  }
}
function fgo_enable(id,enabled) {
  var b=document.getElementById(id);
  if(enabled) {
    b.removeAttribute("disabled");
  } else {
     b.setAttribute("disabled","true");
  }
}

function fgo_extText_changed() {
  var enable;
  var value = g_extText.value;
  try {
    if((!g_extText.disabled) &&
      /^[\w\-]+$/.test(value)) {
        enable = true;
        for(var j = g_extList.getRowCount();
            j-- >0 && (enable = g_extList.getItemAtIndex(j).value != value)
            ;);
    } else {
      enable = false;
    }
  } catch(e) {
    dump(e + "\n" + j + "\n");
  }
  fgo_enable("ext-add-button", enable);
}

function fgo_extList_changed() {
  fgo_enable("ext-remove-button", g_extList.selectedCount > 0);
  fgo_extText_changed();
}

function fgo_ext_add() {
  if (g_extList.getRowCount()) {
    g_extList.insertItemAt(0, g_extText.value, g_extText.value);
  } else {
    g_extList.appendItem(g_extText.value, g_extText.value);
  }
  fgo_extText_changed();
  g_extDirty = true;
}

function fgo_ext_remove() {
  const selectedItems = g_extList.selectedItems;
  for(var j = selectedItems.length; j--> 0;) {
    g_extList.removeItemAt(g_extList.getIndexOfItem(selectedItems[j]));
  }
  g_extDirty = true;
}

function fgo_currentDmName() {
  var dmName;
  return g_downloadManagers.selectedItem && (dmName = g_downloadManagers.selectedItem.getAttribute("label"))
    && gFlashGotService.DMS[dmName] && gFlashGotService.DMS[dmName].supported && dmName || null;
 }

function fgo_save() {
  if(!gFlashGotService) return true;
  
  fgo_visitCheckboxes(
    function(prefName,inverse,checkbox) {
      gFlashGotService.setPref(prefName,inverse ?! checkbox.checked : checkbox.checked);
    }
  );
  
  g_cust.save();
  
  
  var dmName;
  for(dmName in shownInContextMenu) {
    gFlashGotService.DMS[dmName].shownInContextMenu = shownInContextMenu[dmName];
  }
  
  dmName = fgo_currentDmName();
  if(dmName) {
    gFlashGotService.defaultDM = dmName;
  }
  
  if (g_extDirty) {
    const extensions = [];
    for(var j = g_extList.getRowCount(); j-- > 0;) {
      try {
        extensions.push(g_extList.getItemAtIndex(j).value);
      } catch(e) {
        dump(e + "\n" + j + "\n");  
      }
    }
    gFlashGotService.extensions = extensions;
  }
  
  gFlashGotService.setPref("autoReferrer",g_referrerRadio.value=="true");
  gFlashGotService.setPref("fakeReferrer",g_referrerText.value);
  if(g_tmpDir) {
    try {
      if (g_tmpDir.equals(gFlashGotService.directoryService.get("TmpD", CI.nsILocalFile))) {
        gFlashGotService.prefs.clearUserPref("tmpDir");
      } else {
        gFlashGotService.prefs.setComplexValue("tmpDir", CI.nsILocalFile, g_tmpDir);
      }
    } catch(e) {
      
    }
  }
  gFlashGotService.setPref("interceptAll",document.getElementById("interceptAll-radio").selected);
  try {
    if(g_wellGetPath) {
      gFlashGotService.prefs.setComplexValue("WellGet.path", CI.nsILocalFile, g_wellGetPath); 
    } else {
      if(gFlashGotService.prefs.prefHasUserValue("WellGet.path")) gFlashGotService.prefs.clearUserPref("WellGet.path");
    }
  } catch(ex) {
    dump(ex);
  }
  gFlashGotService.savePrefs();
  return true;
  
}

function fgo_visitCheckboxes(callback) {
  var j,checkbox,match;
  for(j=g_opts.length; j-->0;) {
    checkbox=g_opts[j];
    if((match = checkbox.id.match(g_rxOpt))) {
      callback(match[2],match[1]=="inv",checkbox);
    }
  }
}


function fgo_showLog() {
  try {
    if (gFlashGotService.logStream) gFlashGotService.logFlush();
    flashgotUtil.browse(CC['@mozilla.org/network/io-service;1'
      ].getService(CI.nsIIOService
      ).newFileURI(gFlashGotService.logFile).spec);
  } catch(ex) { dump(ex.message); }
}


function fgo_clearLog() {
  gFlashGotService.clearLog();
}

function fgo_browseTmpDir() {
  const fp = CC["@mozilla.org/filepicker;1"].createInstance(CI.nsIFilePicker);
  const title="FlashGot - "+document.getElementById("tmpdir-label").value;
  fp.init(window, title, CI.nsIFilePicker.modeGetFolder);
  try {
    fp.displayDirectory = g_tmpDir == null ? gFlashGotService.tmpDir.parent : g_tmpDir;
  } catch (ex) { gFlashGotService.log(ex); }
  fp.appendFilters(CI.nsIFilePicker.filterAll);
  if (fp.show()==CI.nsIFilePicker.returnOK) {
    g_tmpDir = fp.file.QueryInterface(CI.nsILocalFile);
    document.getElementById("tmpdir-text").value = g_tmpDir.path;
    document.getElementById("tmpdir-warning").style.visibility="visible";
  }
}

function fgo_browseWellGet(reset) {
  if(reset) {
    g_wellGetPath = null;
    document.getElementById("wellget-text").value = "";
    return;
  }
  const CC=CC;
  const CI=CI;
  const fp = CC["@mozilla.org/filepicker;1"].createInstance(CI.nsIFilePicker);
  const title="FlashGot - "+document.getElementById("wellget-label").value;
  fp.init(window, title, CI.nsIFilePicker.modeOpen);
  fp.appendFilters(CI.nsIFilePicker.filterApps);
  if(!g_wellGetPath) {
    g_wellGetPath = gFlashGotService.profDir.clone();
    g_wellGetPath.QueryInterface(CI.nsILocalFile)
                .initWithPath(g_wellGetPath.path.substring(0,3));
    g_wellGetPath.append("WellGet.exe");
  }
  try {
    fp.displayDirectory = g_wellGetPath.parent;
    fp.defaultString = g_wellGetPath.leafName;
  } catch (ex) { gFlashGotService.log(ex); }
 
  if (fp.show() == CI.nsIFilePicker.returnOK) {
    var f = fp.file.QueryInterface(CI.nsILocalFile);
    if(!(f.exists() && f.isExecutable() &&
        f.path.substring(0,1).toUpperCase() == 
        gFlashGotService.profDir.path.substring(0,1).toUpperCase())) {
      CC["@mozilla.org/embedcomp/prompt-service;1"]
                .getService(CI.nsIPromptService)
                .alert(window, "FlashGot / WellGet", 
                  gFlashGotService.getString("wellget.mustBeSameDrive", 
                            [gFlashGotService.profDir.path.substring(0,1)]));
      return;
    }
    g_wellGetPath = f;
    document.getElementById("wellget-text").value = f.path;
    gFlashGotService.DMS["WellGet"]._supported = null;
  }
}

var shownInContextMenu = {};
function fgo_shownInContextMenuClicked(cbx) {
  var dmName = fgo_currentDmName();
  if(dmName) shownInContextMenu[dmName] = cbx.checked;
}

function fgo_detectNow() {
  gFlashGotService.DMS = gFlashGotService.checkDownloadManagers(true, true);
  fgo_populateDMS();
}


