﻿// JSON implementation
var JSON = JSON || {};
JSON.stringify = JSON.stringify || function (obj) {
	var t = typeof (obj);
	if (t != "object" || obj === null) {
		if (t == "string") obj = '"'+obj+'"';
		return String(obj);
	} else {
		var n, v, json = [], arr = (obj && obj.constructor == Array);
		for (n in obj) {
			v = obj[n]; t = typeof(v);
			if (t == "string") v = '"'+v+'"';
			else if (t == "object" && v !== null) v = JSON.stringify(v);
			json.push((arr ? "" : '"' + n + '":') + String(v));
		}
		return (arr ? "[" : "{") + String(json) + (arr ? "]" : "}");
	}
};
JSON.parse = JSON.parse || function (str) {
	if (str === "") str = '""';
	return eval("(" + str + ")");
};

// Helpers
function newElement(type, text) {
	var o = document.createElement(type);
	if (text != null) {
		var t = document.createTextNode(text);
		o.appendChild(t);
	}
	return o;
}

function newText(p, text) {
	var t = document.createTextNode(text);
	p.appendChild(t);
	return p;
}

function setContact(o, c, s) {
	o.title = c.mail;
	$(o).prop(kCustomPropName, c.name);
	var o1 = newElement("span", s);
	o1.className = "adsep";
	o.appendChild(o1);
	var o2 = newElement("span", kAddrSpace);
	o2.className = "addrop";
	o.appendChild(o2);
	$(o).addClass("ad");
	return o;
}

function addContactList(p, l) {
	for (var i in l) {
		var it = l[i];
		var o = newElement("span", it.name);
		setContact(o, it, i < l.length - 1 ? kAddrSeperator : kAddrSpace);
		p.appendChild(o);
	}
	return p;
}

function appendHdLastBar(p) {
	if (p == null)
		return;
	$(p).addClass("g_bline");
	if (!gMail.toolbar || gMail.toolbar.length<1)
		return;
	var o = newElement("div", null);
	$(o).addClass("hd_last");
	p.appendChild(o);
}

function appendHdLastBarById(id) {
	var p = document.getElementById(id);
	appendHdLastBar(p);
}

function isIndexBefore(a,b) {
	var child = b;
	do {
		child = child.previousSibling;
		if (child == a)
			return true;
	} while (child != null);
	return false;
}

function ContactList() {
	var contacts = [];
	this.Add = function(name,mail) {
		var o = {};
		o["name"] = name;
		o["mail"] = mail;
		contacts.push(o);
	}
	this.Serialize = function() {
		return JSON.stringify(contacts);
	}
}