﻿// Scroll view
function ScrollView(id,opt) {
	this.$box = $(document.getElementById(id));
	this.$scrollbar = this.$box.find(".scrollbar");
	this.$viewport = this.$box.find(".viewport");
	
	var plugin = null;
	var self = this;

	this.create = function() {
		if (plugin != null)
			return;
		self.$box.tinyscrollbar(opt);
		plugin = self.$box.data("plugin_tinyscrollbar");
	}

	this.isCreated = function() {
		return plugin != null;
	}

	this.update = function(scrollTo) {
		if (plugin == null)
			return;
		plugin.update(scrollTo);
	}

	this.isDragging = function() {
		if (plugin == null)
			return false;
		return plugin.dragging;
	}
}


// Multi-selection view
function MultiSelectView(cssType,cssSelected) {
	var selectedQueue = [];
	var self = this;

	function addClass(e,c) {
		$(e).addClass(c);
	}

	function removeClass(e,c) {
		var $e = $(e);
		$e.removeClass(c);
		$e.children().removeClass(c);	
	}

	this.type = function() {
		return cssType;
	}

	this.isTypeOf = function(e) {
		var $e = $(e);
		return $e.hasClass(cssType);
	}

	this.hasSelected = function() {
		return selectedQueue.length > 0;
	}

	this.isSelected = function(e) {
		return $(e).hasClass(cssSelected);
	}

	this.select = function(e) {
		if (self.isSelected(e))
			return;
		addClass(e, cssSelected);
		selectedQueue.push(e);
	}

	this.rangeSelect = function(to) {
		var last = selectedQueue.slice(-1)[0];
		if (last != null) {
			self.unselectAll();
			self.select(to);
			if (isIndexBefore(to, last)) {
				while ((to = to.nextSibling) != last)
					if (self.isTypeOf(to))
						self.select(to);
			} else if (to != last) {
				while ((to = to.previousSibling) != last)
					if (self.isTypeOf(to))
						self.select(to);
			}
			self.select(last);
		} else {
			self.select(to);
		}	
	}

	this.unselect = function(e) {
		if (!self.isSelected(e))
			return;
		for (var i in selectedQueue) {
			if (selectedQueue[i] == e) {
				removeClass(e, cssSelected);
				selectedQueue.splice(i,1);
				break;
			}
		}	
	}

	this.unselectAll = function() {
		if (selectedQueue.length < 1)
			return;
		for (var i in selectedQueue) {
			var e = selectedQueue[i];
			removeClass(e, cssSelected);
		}
		// Clean the queue
		selectedQueue.length = 0;
	}

	this.getSelectedItemsIds = function() {
		var r = "";
		for (var i = selectedQueue.length-1; i >= 0; i--) {
			var e = selectedQueue[i];
			if (r == "")
				r = e.id;
			else
				r = r + "," + e.id;
		}
		return r;
	}

	this.getSelectedItemsAsContacts = function() {
		var r = new ContactList;
		for (var i in selectedQueue) {
			var $e = $(selectedQueue[i]);
			r.Add($e.prop(kCustomPropName), $e.prop("title"));
		}
		return r.Serialize();
	}
}

function MultiSelectViewManager() {
	var views = {};
	var self = this;

	this.getAttachmentView = function(id) {
		var v = views[id];
		if (v == null) {
			v = new MultiSelectView("at","atsel");
			views[id] = v;
		}
		return v;
	}

	this.getContactView = function(id) {
		var v = views[id];
		if (v == null) {
			v = new MultiSelectView("ad","adsel");
			views[id] = v;
		}
		return v;
	}

	this.unselectOthers = function(v) {
		for (var id in views) {
			var other = views[id];
			if (v != other)
				other.unselectAll();
		}
	}

	this.unselectAll = function() {
		for (var id in views) {
			views[id].unselectAll();
		}
	}

	this.getSelectedContacts = function() {
		for (var id in views) {
			var v = views[id];
			if (v.type() == "ad" && v.hasSelected()) {
				return v.getSelectedItemsAsContacts();
			}
		}
		return "";
	}

	this.onViewItemMouseDown = function(v,i,e) {
		self.unselectOthers(v);
		if (e.ctrlKey || e.shiftKey) {
			// Do nothing
		} else {
			if (!v.isSelected(i)) {
				v.unselectAll();
				v.select(i);
			}
		}	
	}

	this.onViewItemClick = function(v,i,e) {
		self.unselectOthers(v);
		if (e.ctrlKey) {
			if (v.isSelected(i)) {
				v.unselect(i);
			} else {
				v.select(i);
			}
		} else if (e.shiftKey) {
			v.rangeSelect(i);
		} else {
			v.unselectAll();
			v.select(i);
		}	
	}

	this.onViewItemDblClick = function(v,i) {
		self.unselectOthers(v);
		v.select(i);
	}

	this.onViewItemContextMenu = function(v,i,e) {
		self.unselectOthers(v);
		if (!e.ctrlKey || !v.hasSelected()) {
			if (!v.isSelected(i)) {
				v.unselectAll();
				v.select(i);
			}
		}
	}
}
