﻿var kTextTable = {
	"you" : "您",
	"forword" : "(由%代发)",
	"none" : "（无）",
	"attachinfo" : "文件：%\n大小：%",
	"attachcount" : "共%个附件",
	"tb_reply" : "回复",
	"tb_replyall" : "回复全部",
	"tb_forward" : "转发",
	"tb_rewrite" : "再次编辑",
	"tb_modify" : "修改会议",
	"tb_cancel" : "取消会议",
	"mb_accept" : "接受",
	"mb_tentative" : "暂定",
	"mb_decline" : "谢绝",
	"ms_accepted" : "已接受本次会议邀请",
	"ms_declined" : "已谢绝本次会议邀请",
	"ms_tentative" : "已暂时接受本次会议邀请",
	"ms_updated" : "本次会议已更新",
	"ms_expired" : "本次会议已过期",
	"ms_canceled" : "本次会议已取消",
	"ms_noreply" : "还没有与会者回应",
	"ms_statitics" : "%人接受，%人暂定，%人谢绝"
};
var kAddrSeperator = "；";
var kAddrSpace = "　";
var kDots = "...";
var kCustomPropName = "fm-prop";
var kMaxAttListHeight = 80;
var kMinAttListHeight = 40;
var gAnimationOn = 1;
var gShowAllAttach = false;
var gViewMode = 0;
var gPresentMode = -1;
var gRecieptions = [];
var gDragging = false;
var gDragStart = false;
var gDragSrcX = 0;
var gDragSrcY = 0;
var gCaptured = false;
var gAttachmentList;
var gSummaryViewChangeTimeout;
var gDelayedUpdatePresentersLayoutTimeout;
var gDelayedListenIframeEventsTimeout;

// Initializing
gAttachmentList = document.getElementById("at-list");

var gPresenters = new Array(4);
var gPresenterState = new Array(0,0,0,0);
for (var i = 1; i < 5; i++)
	gPresenters[i-1] = document.getElementById("ps"+i);

var gVBox = new ScrollView("fmvbox");
var gHBox = new Array(2);
for (var i = 1; i < 3; i++) {
	gHBox[i-1] = new ScrollView("fmhbox"+i, {axis:"x"});
}

if (gMail.viewmode != null && gMail.viewmode == 1)
	gViewMode = 1;

var gSelectViewManager = new MultiSelectViewManager();
var gAttachmentSelectView = gSelectViewManager.getAttachmentView("at-list");

// Used by event listener
function cancelAllSelection() {
	gSelectViewManager.unselectAll();
}

// From
if (gMail.from) {
	var bf = document.getElementById("bf-from");
	var dt = document.getElementById("dt-from");
	newText(bf, gMail.from.name);
	setContact(bf, gMail.from, kAddrSpace);
	newText(dt, gMail.from.name);
	setContact(dt, gMail.from, kAddrSpace);
}
if (gMail.sender != null) {
	var f = $("#dt-fw");
	var t = kTextTable["forword"];
	f.text(t.replace(/%/, gMail.sender.mail));
	f.show();
}

// To
if (gMail.to != null) {
	var e = document.getElementById("to");
	addContactList(e, gMail.to);
	$("#to-wp").show();
	gRecieptions = gRecieptions.concat(gMail.to);
}

// Cc
if (gMail.cc != null && gMail.cc.length > 0) {
	var cc = document.getElementById("cc");
	addContactList(cc, gMail.cc);
	$("#cc-wp").show();
	gRecieptions = gRecieptions.concat(gMail.cc);
}

// Bcc
if (gMail.bcc != null && gMail.bcc.length > 0) {
	var bcc = document.getElementById("bcc");
	addContactList(bcc, gMail.bcc);
	$("#bcc-wp").show();
	gRecieptions = gRecieptions.concat(gMail.bcc);
}

// Date
if (gMail.date != null) {
	var dt = document.getElementById("date");
	var dt_i = document.getElementById("date_i");
	newText(dt_i, gMail.date).title = gMail.date;
	$(dt).show();
	if (gViewMode == 1) {
		var bf = document.getElementById("bf-date");
		newText(bf, gMail.date).title = gMail.date;
		$(bf).show();
	}
}

// Receiptions
{
	var lb_wp = document.getElementById("bf-lb-wp");
	var rb = document.getElementById("bf-rb");
	if (gViewMode == 0 || gMail.date == null) {
		$(lb_wp).addClass("g_lc2");
		$(rb).addClass("g_rc1_b");
	} else {
		$(lb_wp).addClass("g_lc1");
		$(rb).addClass("g_rc1");
	}
	var lb = document.getElementById("bf-lb");
	if (gRecieptions.length > 0) {
		addContactList(lb, gRecieptions);
	} else {
		var o = newElement("span", kTextTable["none"]);
		lb.appendChild(o);
	}
}

if (gMail.showdetail == 1) {
	$("#dt").show();
} else {
	$("#bf").show();
}

// Subject
$("#tt").each(function() {
	newText(this, gMail.subject);
});

// Attachment
if (gMail.attachment != null && gMail.attachment.length > 0) {
	var attList = document.getElementById("at-list");
	for (var i in gMail.attachment) {
		var att = gMail.attachment[i];
		var o = newElement("span", att.name);
		o.id = att.id;
		o.className = "at";
		o.style.backgroundImage = "url('" + att.icon + "')";
		var t = kTextTable["attachinfo"].replace(/%/, att.name);
		t = t.replace(/%/, att.size);
		o.title = t;
		var size = newElement("span", "["+att.size+"]");
		$(size).addClass("atsz");
		o.appendChild(size);
		attList.appendChild(o);
	}
	if (!gMail.meeting && !gMail.encrypt)
		appendHdLastBarById("at-wp");
	$("#bf").addClass("g_bline");
	$("#dt").addClass("g_bline");
	var t = kTextTable["attachcount"].replace(/%/, gMail.attachment.length);
	$("#at-all").text(t+kDots);
	$("#at-some").text(t);
	resizeAttachList();
	$("#at-wp").show();
} else {
	if (!gMail.meeting && !gMail.encrypt) {
		appendHdLastBarById("bf");
		appendHdLastBarById("dt");
	}
}

// Meeting
function addMeetingButton(p,o) {
	var text = kTextTable[o];
	var e = newElement("div", text);
	e.id = o;
	e.title = text;
	e.className = "g_btn " + o;
	p.appendChild(e);
}
function adjustMeetingColumns(view) {
	if (view != null) {
		var lb = document.getElementById("mt-lb");
		var rb = document.getElementById("mt-rb");
		var rb_w = view[0].scrollWidth;
		lb.style.marginRight = rb_w+5+"px";
	}
}
function onNativeUpdateMeetingStatus(s) {
	$("#mt-rv").hide();
	var view = $("#mt-av");
	view.text(kTextTable["you"]+kTextTable["ms_" + s]);
	var lb = $("#mt-lb");
	view.addClass("ms_" + s);
	view.show();
	adjustMeetingColumns(view);
}
if (gMail.meeting != null) {
	var date = document.getElementById("mt-date");
	date.title = gMail.meeting.date;
	newText(date, date.title);
	var place = document.getElementById("mt-place");
	place.title = gMail.meeting.place;
	newText(place, place.title);
	var meeting = $("#mt");
	var view;
	// 'status' exists
	var mstatus = gMail.meeting.status;
	var attendee = gMail.meeting.attendee;
	if (mstatus != null) {
		// Attendee
		switch (mstatus) {
		case "new":
			view = $("#mt-rv");
			addMeetingButton(view[0], "mb_accept");
			addMeetingButton(view[0], "mb_tentative");
			addMeetingButton(view[0], "mb_decline");
			break;
		case "canceled":
		case "expired":
		case "updated":
			view = $("#mt-av");
			view.addClass("ms_" + mstatus);
			view.text(kTextTable["ms_" + mstatus]);
			meeting.removeClass("mt_alive");
			meeting.addClass("mt_expired");
			break;
		case "accepted":
		case "declined":
		case "tentative":
			view = $("#mt-av");
			view.addClass("ms_" + mstatus);
			if (attendee != null && attendee.length > 0)
				view.text(attendee[0].name+kTextTable["ms_" + mstatus]); // Organizer
			else	
				view.text(kTextTable["you"]+kTextTable["ms_" + mstatus]);
			view.prop("title", view.text());
			break;
		}
	} else if (attendee != null) {
		// Organizer
		var accepted = 0;
		var tentative = 0;
		var declined = 0;
		for (var i in attendee) {
			switch (attendee[i].status) {
			case "accepted":
				accepted++;
				break;
			case "declined":
				declined++;
				break;
			case "tentative":
				tentative++;
				break;
			}
		}
		view = $("#mt-ov");
		if (accepted + declined + tentative == 0) {
			view.text(kTextTable["ms_noreply"]);
		} else {
			var text = kTextTable["ms_statitics"];
			text = text.replace(/%/, accepted);
			text = text.replace(/%/, tentative);
			text = text.replace(/%/, declined);
			view.text(text);
		}
	}
	if (view != null)
		view.show();
	if (gMail.encrypt == null)
		appendHdLastBar(meeting[0]);
	meeting.show();
	// Reposition the two columns
	adjustMeetingColumns(view);
}

// Encryped
if (gMail.encrypt != null) {
	if (gMail.encrypt == "") {
		$("#ec_h").show();
	} else {
		$("#ec_pwd").text(gMail.encrypt);
		$("#ec_s").show();
	}
	var ec = $("#ec");
	appendHdLastBar(ec[0]);
	ec.show();
}

// Toolbar buttons
$("#tb").each(function() {
	for (var i in gMail.toolbar) {
		var id = "tb_" + gMail.toolbar[i];
		var text = kTextTable[id];
		var o = newElement("li", text);
		o.id = id;
		o.title = text;
		o.className = "g_btn " + id;
		this.appendChild(o);
	}
});

// Event Handling

function deferredNotifyDocumentReady(id) {
	setTimeout(function() {
		try {
			external.onDocumentReady(id);
		} catch (e) {
			// Do nothing
		}
	}, 1);
}

$(document).ready(function() {
	resizeAttachList();
	resizeViewPort();
	gVBox.create();
	for (var i = 0; i < 2; i++)
		gHBox[i].create();
	deferredNotifyDocumentReady("");
	if (window.addEventListener) {
		document.addEventListener("keydown", forwardKeyEvent, false);
	} else {
		document.attachEvent('onkeydown', forwardKeyEvent);
	}
});

$(window).resize(function() {
	resizeAttachList();
	resizePresenters();
	resizeViewPort();
})

$(gPresenters[0])
	.ready(function() {
		delayedUpdatePresentersLayout();
		delayedListenIframeEvents();
		deferredNotifyDocumentReady(gPresenters[0].getAttribute("name"));
	})
	.load(function() {
		delayedUpdatePresentersLayout();
	});

$(gPresenters[1])
	.ready(function() {
		delayedUpdatePresentersLayout();
		delayedListenIframeEvents();
		deferredNotifyDocumentReady(gPresenters[1].getAttribute("name"));
	})
	.load(function() {
		delayedUpdatePresentersLayout();
		delayedListenIframeEvents();
	});

// Viewport
function resizeViewPort() {
	gVBox.$box.css("height", $(window).height()+"px");
	resetViewPortScrollbar();
}

function resetViewPortScrollbar() {
	for (var i = 0; i < 2; i++) {
		// For only iframes
		var newWidth = gHBox[i].$box.width()+"px";
		if (newWidth != gHBox[i].$scrollbar.css("width"))
			gHBox[i].$scrollbar.css("width", newWidth);
		gHBox[i].update("relative");
	}
	gVBox.update("relative");
}

function delayedListenIframeEvents() {
	clearTimeout(gDelayedListenIframeEventsTimeout);
	gDelayedListenIframeEventsTimeout =
		setTimeout(function() {
			gDelayedListenIframeEventsTimeout = null;
			listenIframeEvent(gPresenters[0]);
			listenIframeEvent(gPresenters[1]);
		}, 2);
}

function listenIframeEvent(f) {
	var doc = f.contentWindow.document;
	if (window.addEventListener) {
		doc.addEventListener("mousedown", cancelAllSelection, false);
		doc.addEventListener("wheel", forwardWheelEvent, false);
		doc.addEventListener("scroll", forwardScrollEvent, false);
		doc.addEventListener("keydown", forwardKeyEvent, false);
	} else {
		doc.attachEvent('onmousedown', cancelAllSelection);
		doc.attachEvent('onmousewheel', forwardWheelEvent);
		doc.attachEvent('onkeydown', forwardKeyEvent);
		f.contentWindow.attachEvent('onscroll', forwardScrollEvent);
	}
}

function forwardWheelEvent(e) {
	var box = gVBox.$box[0];
	if (box == null)
		return;
	if (document.dispatchEvent) {
		var ev = document.createEvent("WheelEvent");
		ev.initWheelEvent("wheel", true, true, window, e.detail, e.screenX, e.screenY,
			e.clientX, e.clientY, e.button, e.relatedTarget, "",
			e.deltaX, e.deltaY, e.deltaZ, e.deltaMode);
		box.dispatchEvent(ev);
	} else if (document.createEventObject) {
		box.fireEvent('onmousewheel', e);
	}
}

function forwardScrollEvent(e) {
	for (var i = 0; i < 2; i++) {
		if (gHBox[i].isDragging())
			return;
		var $vp = gHBox[i].$viewport;
		var to = $($vp[0].contentWindow.document.body).scrollLeft();
		gHBox[i].update(to);
	}
}

function forwardKeyEvent(e) {
	switch (e.keyCode) {
	case 38: // Line up
		gVBox.update("lineup");
		break;
	case 40: // Line down
		gVBox.update("linedown");
		break;
	case 33: // Page Up
		gVBox.update("pageup");
		break;
	case 34:
		gVBox.update("pagedown");
		break;
	case 36: // Home
		gVBox.update("top");
		break;
	case 35: // End
		gVBox.update("bottom");
		break;
	}
	if (e.preventDefault)
		e.preventDefault();
}

gVBox.$viewport.scroll(function() {
	if (gVBox.isDragging())
		return false;
	gVBox.update($(this).scrollTop());
	return false;
});

// Presenters
function makeFullSizeIframe(p) {
	try {
		p.style.height =
			p.contentWindow.document.body.scrollHeight+'px';
	} catch (err) {
		// Do nothing
	}
}

function makeFullSize(p) {
	p.style.height = p.scrollHeight+'px';
}

function resizePresenters() {
	if (gPresentMode == 0) {
		if (gPresenterState[0] == 1) {
			makeFullSizeIframe(gPresenters[0]);
		}
		if (gPresenterState[1] == 1) {
			makeFullSizeIframe(gPresenters[1]);
		}
	} else if (gPresentMode == 1) {
		if (gPresenterState[2] == 1)
			makeFullSize(gPresenters[2]);
		if (gPresenterState[3] == 1)
			makeFullSize(gPresenters[3]);
	}
}

function delayedUpdatePresentersLayout(delay) {
	if (delay == null)
		delay = 1;
	clearTimeout(gDelayedUpdatePresentersLayoutTimeout);
	gDelayedUpdatePresentersLayoutTimeout =
		setTimeout(function() {
			gDelayedUpdatePresentersLayoutTimeout = null;
			resizePresenters();
			resizeViewPort();
		}, delay);
}

function changePresentMode(mode) {
	var ht = document.getElementById("ct-ht");
	var tx = document.getElementById("ct-tx");
	if (mode == 0) {
		gPresentMode = 0;
		$(tx).hide();
		changeTranslateView(1);
		$(ht).show();
	} else {
		gPresentMode = 1;
		$(ht).hide();
		changeTranslateView(1);
		$(tx).show();
	}
}

function onNativeChangePresentMode(mode) {
	showTranslationBar(0);
	changePresentMode(mode);
}

function onNativeSetTextContent(c) {
	gPresenters[2].value = c;
	delayedUpdatePresentersLayout();
}

function onNativeSetHtmlContent(url) {
	gPresenters[0].src = url;
	delayedUpdatePresentersLayout();
	delayedListenIframeEvents();
}

if (gMail.html != null) {
	gPresentMode = 0;
	gPresenters[0].src = gMail.html;
}

if (gMail.plain != null) {
	if (gPresentMode == -1) {
		gPresentMode = 1;
	}
	gPresenters[2].value = gMail.plain;
}

changePresentMode(gPresentMode);
delayedUpdatePresentersLayout();

// Contacts
function onNativeGetSelectedContact() {
	return gSelectViewManager.getSelectedContacts();
}
$(".ad")
	.mouseenter(function() {
		$(this).addClass("adhover");
		$(this).children(".adsep").hide();
		$(this).children(".addrop").show();
		return false;
	})
	.mouseleave(function() {
		$(this).removeClass("adhover");
		$(this).children(".addrop").hide();
		$(this).children(".adsep").show();
		return false;
	})
	.mousedown(function(e) {
		var v = gSelectViewManager.getContactView(this.parentNode.id);
		gSelectViewManager.onViewItemMouseDown(v,this,e);
		return false; // Stop bubbling
	})
	.click(function(e) {
		var v = gSelectViewManager.getContactView(this.parentNode.id);
		var offset = $(this).offset();
		if (offset.left + $(this).width() - e.pageX < 9) {
			gSelectViewManager.unselectOthers(v);
			v.unselectAll();
			v.select(this);
			var r = new ContactList;
			r.Add($(this).prop(kCustomPropName), this.title);
			external.onContactMenu(r.Serialize());
		} else {
			gSelectViewManager.onViewItemClick(v,this,e);
		}
		return false;
	})
	.dblclick(function() {
		var v = gSelectViewManager.getContactView(this.parentNode.id);
		gSelectViewManager.onViewItemDblClick(v,this);
		var name = $(this).prop(kCustomPropName);
		var mail = this.title;
		external.onContactDblClicked(name, mail);
		return false;
	})
	.bind("contextmenu", function(e) {
		var v = gSelectViewManager.getContactView(this.parentNode.id);
		gSelectViewManager.onViewItemContextMenu(v,this,e);
		var out = gSelectViewManager.getSelectedContacts();
		external.onContactMenu(out);
		return false;
	});

// Attachment
function resizeAttachList() {
	var l = document.getElementById("at-list");
	if (l == null)
		return;
	if (l.scrollHeight > kMaxAttListHeight) {
		if (gShowAllAttach)
			$("#at-some").show();
		else {
			if (l.style.height != kMinAttListHeight+"px")
				l.style.height = kMinAttListHeight+"px";
			$("#at-all").show();
		}
	} else {
		if (l.style.height != "auto")
			l.style.height = "auto";
		$("#at-some").hide();
		$("#at-all").hide();
	}
}

function onNativeSelectAllAttachments() {
	var al = document.getElementById("at-list");
	var at = al.firstChild;
	while (at != null) {
		if (at.nodeType == 1 && $(at).hasClass("at")) {
			gAttachmentSelectView.isSelected(at);
		}
		at = at.nextSibling;
	}
	if ($("#at-all").is(":visible")) {
		$("#at-all").trigger("click");
	}
}

function onNativeGetSelectedAttachmentList() {
	return gAttachmentSelectView.getSelectedItemsIds();
}

function onLostAttachmentCapture() {
	if (gCaptured) {
	    if (!window.releaseEvents)
	        gAttachmentList.releaseCapture();
	    else
	        releaseEvents();
	    gCaptured = false;
	}
}

$(".at")
	.mouseenter(function() {
		var $e = $(this);
		$e.addClass("athover");
		$e.children().addClass("athover");
	})
	.mouseleave(function() {
		var $e = $(this);
		$e.removeClass("athover");
		$e.children().removeClass("athover");
	})
	.mousedown(function(e) {
		gSelectViewManager.onViewItemMouseDown(gAttachmentSelectView,this,e);
	})
	.click(function(e) {
		gSelectViewManager.onViewItemClick(gAttachmentSelectView,this,e);
		return false;
	})
	.dblclick(function() {
		gSelectViewManager.onViewItemDblClick(gAttachmentSelectView,this);
		external.onAttachmentDblClicked(parseInt(this.id));
		return false;
	})
	.bind("contextmenu", function(e) {
		gSelectViewManager.onViewItemContextMenu(gAttachmentSelectView,this,e);
		var out = gAttachmentSelectView.getSelectedItemsIds();
		external.onAttachmentMenu(out);
		return false;
	});

$("#at-list")
	.mousedown(function(e) {
		onLostAttachmentCapture();
		gDragging = false;
		gDragStart = false;
		if (e.target == this) {
			gSelectViewManager.unselectOthers(gAttachmentSelectView);
			return false;
		}
		if (!gAttachmentSelectView.hasSelected())
			return false;
		gDragStart = true;
		gDragSrcX = e.pageX;
		gDragSrcY = e.pageY;
		return false;
	})
	.mousemove(function(e) {
		if (gDragStart) {
			if (!gCaptured) {
				if (!window.captureEvents)
					this.setCapture();
				else
					captureEvents();
				gCaptured = true;
			}
			if (!gDragging) {
				if ((e.pageX <= gDragSrcX - 9 || e.pageX > gDragSrcX + 9) ||
					(e.pageY <= gDragSrcY - 9 || e.pageY > gDragSrcY + 9)) {
					onLostAttachmentCapture();
					gDragging = true;
					var out = gAttachmentSelectView.getSelectedItemsIds();
					external.onAttachmentDragStart(out);
				}
			}
		}
		return false;
	})
	.mouseup(function(e) {
		onLostAttachmentCapture();
		gDragStart = false;
		setTimeout(function() {gDragging = false},1);
		return false;
	});

// Translation
function changeTranslateView(v) {
	if (gPresentMode == -1)
		return;
	var li = gPresentMode * 2;
	var ri = li + 1;
	if (gPresentMode == 0) {
		var $psl = gHBox[0].$box;
		var $psr = gHBox[1].$box;
	} else {
		var $psl = $(gPresenters[2]);
		var $psr = $(gPresenters[3]);
	}
	if (v == 0) {
		$psl.removeClass("ps disable");
		$psl.addClass("ps_l");
		$psr.removeClass("ps disable");
		$psr.addClass("ps_r");
		gPresenterState[li] = 1;
		gPresenterState[ri] = 1;
	} else if (v == 1) {
		$psr.addClass("disable");
		$psl.removeClass("ps_l disable");
		$psl.addClass("ps");
		gPresenterState[li] = 1;
		gPresenterState[ri] = 0;
	} else {
		$psl.addClass("disable");
		$psr.removeClass("ps_r disable");
		$psr.addClass("ps");
		gPresenterState[li] = 0;
		gPresenterState[ri] = 1;
	}
}

function showTranslationBar(v) {
	if (v == 0) {
		$("#ts").hide();
	} else if (v == 1) {
		$("#ts-1").hide();
		$("#ts-2").show();
		$("#ts").show();
	} else {
		$("#ts-2").hide();
		$("#ts-1").show();
		$("#ts").show();
	}
}

function onNativeShowTranslating() {
	showTranslationBar(1);
}

function onNativeShowTranslated(p) {
	if (gPresentMode == 0)
		gPresenters[1].src = p; // |p| is url
	else
		gPresenters[3].value = p; // |p| is text

	showTranslationBar(2);
	changeTranslateView(0);

	delayedUpdatePresentersLayout();
	delayedListenIframeEvents();
}

function updateTranslateButtonClass(id, c) {
	var id = document.getElementById(id);
	if (c == "ts_e") {
		$(id).removeClass("ts_d");
		$(id).addClass("ts_e");
	} else {
		$(id).removeClass("ts_e");
		$(id).addClass("ts_d");
	}
}

$("#ts-b").click(function() {
	updateTranslateButtonClass("ts-o", "ts_e");
	updateTranslateButtonClass("ts-t", "ts_e");
	updateTranslateButtonClass(this.id, "ts_d");
	changeTranslateView(0);
	delayedUpdatePresentersLayout();
	return false;
});

$("#ts-o").click(function() {
	updateTranslateButtonClass("ts-t", "ts_e");
	updateTranslateButtonClass("ts-b", "ts_e");
	updateTranslateButtonClass(this.id, "ts_d");
	changeTranslateView(1);
	delayedUpdatePresentersLayout();
	return false;
});

$("#ts-t").click(function() {
	updateTranslateButtonClass("ts-o", "ts_e");
	updateTranslateButtonClass("ts-b", "ts_e");
	updateTranslateButtonClass(this.id, "ts_d");
	changeTranslateView(2);
	delayedUpdatePresentersLayout();
	return false;
});

// Button style objects
$(".g_btn")
	.mouseenter(function() {
		$(this).removeClass("press");
		$(this).addClass("hover");
		return false;
	})
	.mousedown(function(e) {
		if (e.which != 1)
			return false;
		$(this).removeClass("hover");
		$(this).addClass("press");
		return false;
	})
	.mouseup(function(e) {
		if (e.which != 1)
			return false;
		if ($(this).hasClass("press")) {
			$(this).removeClass("press");
			$(this).addClass("hover");
		}
		return false;
	})
	.mouseleave(function() {
		$(this).removeClass("hover");
		$(this).removeClass("press");
		return false;
	})
	.click(function() {
		var id = this.id;
		if (/tb_[a-zA-Z0-9]/i.test(id)) {
			external.onToolbarCommand(id.substring(3));
			return;
		} else if (/mb_[a-zA-Z0-9]/i.test(id)) {
			external.onMeetingCommand(id.substring(3));
			return;
		}
		return false;
	})

// Drop buttons
$(".switch")
.mouseenter(function() {
	$(this).addClass("switchhover");
})
.mouseleave(function() {
	$(this).removeClass("switchhover");
})
.click(function() {
	var kSpeed = 200;
	switch (this.id) {
	case "bf-hide":
		if (gAnimationOn) {
			$("#bf").slideUp(kSpeed);
			$("#dt").slideDown(kSpeed);
		} else {
			$("#bf").hide();
			$("#dt").show();
		}
		clearTimeout(gSummaryViewChangeTimeout);
		gSummaryViewChangeTimeout = setTimeout(function() {
			gSummaryViewChangeTimeout = null;
			external.onSummaryViewChange(1);
		}, 1000);
		break;
	case "dt-hide":
		if (gAnimationOn) {
			$("#dt").slideUp(kSpeed);
			$("#bf").slideDown(kSpeed);
		} else {
			$("#dt").hide();
			$("#bf").show();
		}
		clearTimeout(gSummaryViewChangeTimeout);
		gSummaryViewChangeTimeout = setTimeout(function() {
			gSummaryViewChangeTimeout = null;
			external.onSummaryViewChange(0)
		}, 1000);
		break;
	case "at-all":
		gShowAllAttach = true;
		$("#at-all").hide();
		$("#at-list").css("height", "auto");
		$("#at-some").show();
		break;
	case "at-some":
		gShowAllAttach = false;
		$("#at-some").hide();
		$("#at-list").css("height", kMinAttListHeight+"px");
		$("#at-all").show();
		break;
	}
	delayedUpdatePresentersLayout(kSpeed+1);
	return false;
});

// No menu
$("[class=nomenu]")
	.bind("selectstart", function() {
		return false;
	})
	.bind("contextmenu", function() {
		cancelAllSelection();
		return false;
	});

// Body
$(document.body)
	.mousedown(function() {
		if (gDragging) {
			gDragging = false;
			gDragStart = false;
			return;
		}
		cancelAllSelection();
	})
	.bind("contextmenu", function() {
		cancelAllSelection();
		return true;
	});
