import { Chart } from '../../src';
import { createDiv, removeDom } from '../util/dom';
import DataSet from '@antv/data-set';
import Filter from '../../src/interaction/action/data/filter';
import Context from '../../src/interaction/context';

describe('no field no filter', () => {
  const data = {
    type: 'FeatureCollection',
    offset: { x: 170, y: 90 },
    features: [
      {
        type: 'Feature',
        id: 'AFG',
        properties: { name: 'Afghanistan' },
        geometry: {
          type: 'Polygon',
          coordinates: [
            [
              [61.210817, 35.650072],
              [62.230651, 35.270664],
              [62.984662, 35.404041],
              [63.193538, 35.857166],
              [63.982896, 36.007957],
              [64.546479, 36.312073],
              [64.746105, 37.111818],
              [65.588948, 37.305217],
              [65.745631, 37.661164],
              [66.217385, 37.39379],
              [66.518607, 37.362784],
              [67.075782, 37.356144],
              [67.83, 37.144994],
              [68.135562, 37.023115],
              [68.859446, 37.344336],
              [69.196273, 37.151144],
              [69.518785, 37.608997],
              [70.116578, 37.588223],
              [70.270574, 37.735165],
              [70.376304, 38.138396],
              [70.806821, 38.486282],
              [71.348131, 38.258905],
              [71.239404, 37.953265],
              [71.541918, 37.905774],
              [71.448693, 37.065645],
              [71.844638, 36.738171],
              [72.193041, 36.948288],
              [72.63689, 37.047558],
              [73.260056, 37.495257],
              [73.948696, 37.421566],
              [74.980002, 37.41999],
              [75.158028, 37.133031],
              [74.575893, 37.020841],
              [74.067552, 36.836176],
              [72.920025, 36.720007],
              [71.846292, 36.509942],
              [71.262348, 36.074388],
              [71.498768, 35.650563],
              [71.613076, 35.153203],
              [71.115019, 34.733126],
              [71.156773, 34.348911],
              [70.881803, 33.988856],
              [69.930543, 34.02012],
              [70.323594, 33.358533],
              [69.687147, 33.105499],
              [69.262522, 32.501944],
              [69.317764, 31.901412],
              [68.926677, 31.620189],
              [68.556932, 31.71331],
              [67.792689, 31.58293],
              [67.683394, 31.303154],
              [66.938891, 31.304911],
              [66.381458, 30.738899],
              [66.346473, 29.887943],
              [65.046862, 29.472181],
              [64.350419, 29.560031],
              [64.148002, 29.340819],
              [63.550261, 29.468331],
              [62.549857, 29.318572],
              [60.874248, 29.829239],
              [61.781222, 30.73585],
              [61.699314, 31.379506],
              [60.941945, 31.548075],
              [60.863655, 32.18292],
              [60.536078, 32.981269],
              [60.9637, 33.528832],
              [60.52843, 33.676446],
              [60.803193, 34.404102],
              [61.210817, 35.650072],
            ],
          ],
        },
      },
      {
        type: 'Feature',
        id: 'AGO',
        properties: { name: 'Angola' },
        geometry: {
          type: 'MultiPolygon',
          coordinates: [
            [
              [
                [16.326528, -5.87747],
                [16.57318, -6.622645],
                [16.860191, -7.222298],
                [17.089996, -7.545689],
                [17.47297, -8.068551],
                [18.134222, -7.987678],
                [18.464176, -7.847014],
                [19.016752, -7.988246],
                [19.166613, -7.738184],
                [19.417502, -7.155429],
                [20.037723, -7.116361],
                [20.091622, -6.94309],
                [20.601823, -6.939318],
                [20.514748, -7.299606],
                [21.728111, -7.290872],
                [21.746456, -7.920085],
                [21.949131, -8.305901],
                [21.801801, -8.908707],
                [21.875182, -9.523708],
                [22.208753, -9.894796],
                [22.155268, -11.084801],
                [22.402798, -10.993075],
                [22.837345, -11.017622],
                [23.456791, -10.867863],
                [23.912215, -10.926826],
                [24.017894, -11.237298],
                [23.904154, -11.722282],
                [24.079905, -12.191297],
                [23.930922, -12.565848],
                [24.016137, -12.911046],
                [21.933886, -12.898437],
                [21.887843, -16.08031],
                [22.562478, -16.898451],
                [23.215048, -17.523116],
                [21.377176, -17.930636],
                [18.956187, -17.789095],
                [18.263309, -17.309951],
                [14.209707, -17.353101],
                [14.058501, -17.423381],
                [13.462362, -16.971212],
                [12.814081, -16.941343],
                [12.215461, -17.111668],
                [11.734199, -17.301889],
                [11.640096, -16.673142],
                [11.778537, -15.793816],
                [12.123581, -14.878316],
                [12.175619, -14.449144],
                [12.500095, -13.5477],
                [12.738479, -13.137906],
                [13.312914, -12.48363],
                [13.633721, -12.038645],
                [13.738728, -11.297863],
                [13.686379, -10.731076],
                [13.387328, -10.373578],
                [13.120988, -9.766897],
                [12.87537, -9.166934],
                [12.929061, -8.959091],
                [13.236433, -8.562629],
                [12.93304, -7.596539],
                [12.728298, -6.927122],
                [12.227347, -6.294448],
                [12.322432, -6.100092],
                [12.735171, -5.965682],
                [13.024869, -5.984389],
                [13.375597, -5.864241],
                [16.326528, -5.87747],
              ],
            ],
            [
              [
                [12.436688, -5.684304],
                [12.182337, -5.789931],
                [11.914963, -5.037987],
                [12.318608, -4.60623],
                [12.62076, -4.438023],
                [12.995517, -4.781103],
                [12.631612, -4.991271],
                [12.468004, -5.248362],
                [12.436688, -5.684304],
              ],
            ],
          ],
        },
      },
      {
        type: 'Feature',
        id: 'ALB',
        properties: { name: 'Albania' },
        geometry: {
          type: 'Polygon',
          coordinates: [
            [
              [20.590247, 41.855404],
              [20.463175, 41.515089],
              [20.605182, 41.086226],
              [21.02004, 40.842727],
              [20.99999, 40.580004],
              [20.674997, 40.435],
              [20.615, 40.110007],
              [20.150016, 39.624998],
              [19.98, 39.694993],
              [19.960002, 39.915006],
              [19.406082, 40.250773],
              [19.319059, 40.72723],
              [19.40355, 41.409566],
              [19.540027, 41.719986],
              [19.371769, 41.877548],
              [19.304486, 42.195745],
              [19.738051, 42.688247],
              [19.801613, 42.500093],
              [20.0707, 42.58863],
              [20.283755, 42.32026],
              [20.52295, 42.21787],
              [20.590247, 41.855404],
            ],
          ],
        },
      },
      {
        type: 'Feature',
        id: 'ARE',
        properties: { name: 'United Arab Emirates' },
        geometry: {
          type: 'Polygon',
          coordinates: [
            [
              [51.579519, 24.245497],
              [51.757441, 24.294073],
              [51.794389, 24.019826],
              [52.577081, 24.177439],
              [53.404007, 24.151317],
              [54.008001, 24.121758],
              [54.693024, 24.797892],
              [55.439025, 25.439145],
              [56.070821, 26.055464],
              [56.261042, 25.714606],
              [56.396847, 24.924732],
              [55.886233, 24.920831],
              [55.804119, 24.269604],
              [55.981214, 24.130543],
              [55.528632, 23.933604],
              [55.525841, 23.524869],
              [55.234489, 23.110993],
              [55.208341, 22.70833],
              [55.006803, 22.496948],
              [52.000733, 23.001154],
              [51.617708, 24.014219],
              [51.579519, 24.245497],
            ],
          ],
        },
      },
      {
        type: 'Feature',
        id: 'ARG',
        properties: { name: 'Argentina' },
        geometry: {
          type: 'MultiPolygon',
          coordinates: [
            [
              [
                [-65.5, -55.2],
                [-66.45, -55.25],
                [-66.95992, -54.89681],
                [-67.56244, -54.87001],
                [-68.63335, -54.8695],
                [-68.63401, -52.63637],
                [-68.25, -53.1],
                [-67.75, -53.85],
                [-66.45, -54.45],
                [-65.05, -54.7],
                [-65.5, -55.2],
              ],
            ],
            [
              [
                [-64.964892, -22.075862],
                [-64.377021, -22.798091],
                [-63.986838, -21.993644],
                [-62.846468, -22.034985],
                [-62.685057, -22.249029],
                [-60.846565, -23.880713],
                [-60.028966, -24.032796],
                [-58.807128, -24.771459],
                [-57.777217, -25.16234],
                [-57.63366, -25.603657],
                [-58.618174, -27.123719],
                [-57.60976, -27.395899],
                [-56.486702, -27.548499],
                [-55.695846, -27.387837],
                [-54.788795, -26.621786],
                [-54.625291, -25.739255],
                [-54.13005, -25.547639],
                [-53.628349, -26.124865],
                [-53.648735, -26.923473],
                [-54.490725, -27.474757],
                [-55.162286, -27.881915],
                [-56.2909, -28.852761],
                [-57.625133, -30.216295],
                [-57.874937, -31.016556],
                [-58.14244, -32.044504],
                [-58.132648, -33.040567],
                [-58.349611, -33.263189],
                [-58.427074, -33.909454],
                [-58.495442, -34.43149],
                [-57.22583, -35.288027],
                [-57.362359, -35.97739],
                [-56.737487, -36.413126],
                [-56.788285, -36.901572],
                [-57.749157, -38.183871],
                [-59.231857, -38.72022],
                [-61.237445, -38.928425],
                [-62.335957, -38.827707],
                [-62.125763, -39.424105],
                [-62.330531, -40.172586],
                [-62.145994, -40.676897],
                [-62.745803, -41.028761],
                [-63.770495, -41.166789],
                [-64.73209, -40.802677],
                [-65.118035, -41.064315],
                [-64.978561, -42.058001],
                [-64.303408, -42.359016],
                [-63.755948, -42.043687],
                [-63.458059, -42.563138],
                [-64.378804, -42.873558],
                [-65.181804, -43.495381],
                [-65.328823, -44.501366],
                [-65.565269, -45.036786],
                [-66.509966, -45.039628],
                [-67.293794, -45.551896],
                [-67.580546, -46.301773],
                [-66.597066, -47.033925],
                [-65.641027, -47.236135],
                [-65.985088, -48.133289],
                [-67.166179, -48.697337],
                [-67.816088, -49.869669],
                [-68.728745, -50.264218],
                [-69.138539, -50.73251],
                [-68.815561, -51.771104],
                [-68.149995, -52.349983],
                [-68.571545, -52.299444],
                [-69.498362, -52.142761],
                [-71.914804, -52.009022],
                [-72.329404, -51.425956],
                [-72.309974, -50.67701],
                [-72.975747, -50.74145],
                [-73.328051, -50.378785],
                [-73.415436, -49.318436],
                [-72.648247, -48.878618],
                [-72.331161, -48.244238],
                [-72.447355, -47.738533],
                [-71.917258, -46.884838],
                [-71.552009, -45.560733],
                [-71.659316, -44.973689],
                [-71.222779, -44.784243],
                [-71.329801, -44.407522],
                [-71.793623, -44.207172],
                [-71.464056, -43.787611],
                [-71.915424, -43.408565],
                [-72.148898, -42.254888],
                [-71.746804, -42.051386],
                [-71.915734, -40.832339],
                [-71.680761, -39.808164],
                [-71.413517, -38.916022],
                [-70.814664, -38.552995],
                [-71.118625, -37.576827],
                [-71.121881, -36.658124],
                [-70.364769, -36.005089],
                [-70.388049, -35.169688],
                [-69.817309, -34.193571],
                [-69.814777, -33.273886],
                [-70.074399, -33.09121],
                [-70.535069, -31.36501],
                [-69.919008, -30.336339],
                [-70.01355, -29.367923],
                [-69.65613, -28.459141],
                [-69.001235, -27.521214],
                [-68.295542, -26.89934],
                [-68.5948, -26.506909],
                [-68.386001, -26.185016],
                [-68.417653, -24.518555],
                [-67.328443, -24.025303],
                [-66.985234, -22.986349],
                [-67.106674, -22.735925],
                [-66.273339, -21.83231],
                [-64.964892, -22.075862],
              ],
            ],
          ],
        },
      },
      {
        type: 'Feature',
        id: 'ARM',
        properties: { name: 'Armenia' },
        geometry: {
          type: 'Polygon',
          coordinates: [
            [
              [43.582746, 41.092143],
              [44.97248, 41.248129],
              [45.179496, 40.985354],
              [45.560351, 40.81229],
              [45.359175, 40.561504],
              [45.891907, 40.218476],
              [45.610012, 39.899994],
              [46.034534, 39.628021],
              [46.483499, 39.464155],
              [46.50572, 38.770605],
              [46.143623, 38.741201],
              [45.735379, 39.319719],
              [45.739978, 39.473999],
              [45.298145, 39.471751],
              [45.001987, 39.740004],
              [44.79399, 39.713003],
              [44.400009, 40.005],
              [43.656436, 40.253564],
              [43.752658, 40.740201],
              [43.582746, 41.092143],
            ],
          ],
        },
      },
      {
        type: 'Feature',
        id: 'ATF',
        properties: { name: 'French Southern and Antarctic Lands' },
        geometry: {
          type: 'Polygon',
          coordinates: [
            [
              [68.935, -48.625],
              [69.58, -48.94],
              [70.525, -49.065],
              [70.56, -49.255],
              [70.28, -49.71],
              [68.745, -49.775],
              [68.72, -49.2425],
              [68.8675, -48.83],
              [68.935, -48.625],
            ],
          ],
        },
      },
      {
        type: 'Feature',
        id: 'AUS',
        properties: { name: 'Australia' },
        geometry: {
          type: 'MultiPolygon',
          coordinates: [
            [
              [
                [145.397978, -40.792549],
                [146.364121, -41.137695],
                [146.908584, -41.000546],
                [147.689259, -40.808258],
                [148.289068, -40.875438],
                [148.359865, -42.062445],
                [148.017301, -42.407024],
                [147.914052, -43.211522],
                [147.564564, -42.937689],
                [146.870343, -43.634597],
                [146.663327, -43.580854],
                [146.048378, -43.549745],
                [145.43193, -42.693776],
                [145.29509, -42.03361],
                [144.718071, -41.162552],
                [144.743755, -40.703975],
                [145.397978, -40.792549],
              ],
            ],
            [
              [
                [143.561811, -13.763656],
                [143.922099, -14.548311],
                [144.563714, -14.171176],
                [144.894908, -14.594458],
                [145.374724, -14.984976],
                [145.271991, -15.428205],
                [145.48526, -16.285672],
                [145.637033, -16.784918],
                [145.888904, -16.906926],
                [146.160309, -17.761655],
                [146.063674, -18.280073],
                [146.387478, -18.958274],
                [147.471082, -19.480723],
                [148.177602, -19.955939],
                [148.848414, -20.39121],
                [148.717465, -20.633469],
                [149.28942, -21.260511],
                [149.678337, -22.342512],
                [150.077382, -22.122784],
                [150.482939, -22.556142],
                [150.727265, -22.402405],
                [150.899554, -23.462237],
                [151.609175, -24.076256],
                [152.07354, -24.457887],
                [152.855197, -25.267501],
                [153.136162, -26.071173],
                [153.161949, -26.641319],
                [153.092909, -27.2603],
                [153.569469, -28.110067],
                [153.512108, -28.995077],
                [153.339095, -29.458202],
                [153.069241, -30.35024],
                [153.089602, -30.923642],
                [152.891578, -31.640446],
                [152.450002, -32.550003],
                [151.709117, -33.041342],
                [151.343972, -33.816023],
                [151.010555, -34.31036],
                [150.714139, -35.17346],
                [150.32822, -35.671879],
                [150.075212, -36.420206],
                [149.946124, -37.109052],
                [149.997284, -37.425261],
                [149.423882, -37.772681],
                [148.304622, -37.809061],
                [147.381733, -38.219217],
                [146.922123, -38.606532],
                [146.317922, -39.035757],
                [145.489652, -38.593768],
                [144.876976, -38.417448],
                [145.032212, -37.896188],
                [144.485682, -38.085324],
                [143.609974, -38.809465],
                [142.745427, -38.538268],
                [142.17833, -38.380034],
                [141.606582, -38.308514],
                [140.638579, -38.019333],
                [139.992158, -37.402936],
                [139.806588, -36.643603],
                [139.574148, -36.138362],
                [139.082808, -35.732754],
                [138.120748, -35.612296],
                [138.449462, -35.127261],
                [138.207564, -34.384723],
                [137.71917, -35.076825],
                [136.829406, -35.260535],
                [137.352371, -34.707339],
                [137.503886, -34.130268],
                [137.890116, -33.640479],
                [137.810328, -32.900007],
                [136.996837, -33.752771],
                [136.372069, -34.094766],
                [135.989043, -34.890118],
                [135.208213, -34.47867],
                [135.239218, -33.947953],
                [134.613417, -33.222778],
                [134.085904, -32.848072],
                [134.273903, -32.617234],
                [132.990777, -32.011224],
                [132.288081, -31.982647],
                [131.326331, -31.495803],
                [129.535794, -31.590423],
                [128.240938, -31.948489],
                [127.102867, -32.282267],
                [126.148714, -32.215966],
                [125.088623, -32.728751],
                [124.221648, -32.959487],
                [124.028947, -33.483847],
                [123.659667, -33.890179],
                [122.811036, -33.914467],
                [122.183064, -34.003402],
                [121.299191, -33.821036],
                [120.580268, -33.930177],
                [119.893695, -33.976065],
                [119.298899, -34.509366],
                [119.007341, -34.464149],
                [118.505718, -34.746819],
                [118.024972, -35.064733],
                [117.295507, -35.025459],
                [116.625109, -35.025097],
                [115.564347, -34.386428],
                [115.026809, -34.196517],
                [115.048616, -33.623425],
                [115.545123, -33.487258],
                [115.714674, -33.259572],
                [115.679379, -32.900369],
                [115.801645, -32.205062],
                [115.689611, -31.612437],
                [115.160909, -30.601594],
                [114.997043, -30.030725],
                [115.040038, -29.461095],
                [114.641974, -28.810231],
                [114.616498, -28.516399],
                [114.173579, -28.118077],
                [114.048884, -27.334765],
                [113.477498, -26.543134],
                [113.338953, -26.116545],
                [113.778358, -26.549025],
                [113.440962, -25.621278],
                [113.936901, -25.911235],
                [114.232852, -26.298446],
                [114.216161, -25.786281],
                [113.721255, -24.998939],
                [113.625344, -24.683971],
                [113.393523, -24.384764],
                [113.502044, -23.80635],
                [113.706993, -23.560215],
                [113.843418, -23.059987],
                [113.736552, -22.475475],
                [114.149756, -21.755881],
                [114.225307, -22.517488],
                [114.647762, -21.82952],
                [115.460167, -21.495173],
                [115.947373, -21.068688],
                [116.711615, -20.701682],
                [117.166316, -20.623599],
                [117.441545, -20.746899],
                [118.229559, -20.374208],
                [118.836085, -20.263311],
                [118.987807, -20.044203],
                [119.252494, -19.952942],
                [119.805225, -19.976506],
                [120.85622, -19.683708],
                [121.399856, -19.239756],
                [121.655138, -18.705318],
                [122.241665, -18.197649],
                [122.286624, -17.798603],
                [122.312772, -17.254967],
                [123.012574, -16.4052],
                [123.433789, -17.268558],
                [123.859345, -17.069035],
                [123.503242, -16.596506],
                [123.817073, -16.111316],
                [124.258287, -16.327944],
                [124.379726, -15.56706],
                [124.926153, -15.0751],
                [125.167275, -14.680396],
                [125.670087, -14.51007],
                [125.685796, -14.230656],
                [126.125149, -14.347341],
                [126.142823, -14.095987],
                [126.582589, -13.952791],
                [127.065867, -13.817968],
                [127.804633, -14.276906],
                [128.35969, -14.86917],
                [128.985543, -14.875991],
                [129.621473, -14.969784],
                [129.4096, -14.42067],
                [129.888641, -13.618703],
                [130.339466, -13.357376],
                [130.183506, -13.10752],
                [130.617795, -12.536392],
                [131.223495, -12.183649],
                [131.735091, -12.302453],
                [132.575298, -12.114041],
                [132.557212, -11.603012],
                [131.824698, -11.273782],
                [132.357224, -11.128519],
                [133.019561, -11.376411],
                [133.550846, -11.786515],
                [134.393068, -12.042365],
                [134.678632, -11.941183],
                [135.298491, -12.248606],
                [135.882693, -11.962267],
                [136.258381, -12.049342],
                [136.492475, -11.857209],
                [136.95162, -12.351959],
                [136.685125, -12.887223],
                [136.305407, -13.29123],
                [135.961758, -13.324509],
                [136.077617, -13.724278],
                [135.783836, -14.223989],
                [135.428664, -14.715432],
                [135.500184, -14.997741],
                [136.295175, -15.550265],
                [137.06536, -15.870762],
                [137.580471, -16.215082],
                [138.303217, -16.807604],
                [138.585164, -16.806622],
                [139.108543, -17.062679],
                [139.260575, -17.371601],
                [140.215245, -17.710805],
                [140.875463, -17.369069],
                [141.07111, -16.832047],
                [141.274095, -16.38887],
                [141.398222, -15.840532],
                [141.702183, -15.044921],
                [141.56338, -14.561333],
                [141.63552, -14.270395],
                [141.519869, -13.698078],
                [141.65092, -12.944688],
                [141.842691, -12.741548],
                [141.68699, -12.407614],
                [141.928629, -11.877466],
                [142.118488, -11.328042],
                [142.143706, -11.042737],
                [142.51526, -10.668186],
                [142.79731, -11.157355],
                [142.866763, -11.784707],
                [143.115947, -11.90563],
                [143.158632, -12.325656],
                [143.522124, -12.834358],
                [143.597158, -13.400422],
                [143.561811, -13.763656],
              ],
            ],
          ],
        },
      },
    ],
  };

  const ds = new DataSet();
  const dv = ds.createView('back').source(data, {
    type: 'GeoJSON',
  });
  const userData = [
    { name: 'Russia', value: 86.8 },
    { name: 'China', value: 106.3 },
    { name: 'Japan', value: 94.7 },
    { name: 'Mongolia', value: 98 },
    { name: 'Canada', value: 98.4 },
    { name: 'United Kingdom', value: 97.2 },
    { name: 'United States of America', value: 98.3 },
    { name: 'Brazil', value: 96.7 },
    { name: 'Argentina', value: 95.8 },
    { name: 'Algeria', value: 101.3 },
    { name: 'France', value: 94.8 },
    { name: 'Germany', value: 96.6 },
    { name: 'Ukraine', value: 86.3 },
    { name: 'Egypt', value: 102.1 },
    { name: 'South Africa', value: 101.3 },
    { name: 'India', value: 107.6 },
    { name: 'Australia', value: 99.9 },
    { name: 'Saudi Arabia', value: 130.1 },
    { name: 'Afghanistan', value: 106.5 },
    { name: 'Kazakhstan', value: 93.4 },
    { name: 'Indonesia', value: 101.4 },
  ];
  const userDv = ds
    .createView()
    .source(userData)
    .transform({
      geoDataView: dv,
      field: 'name',
      type: 'geo.centroid',
      as: ['longitude', 'latitude'],
    });
  const chart = new Chart({
    container: createDiv(),
    width: 500,
    height: 500,
    padding: [0, 50, 0, 0],
  });
  chart.scale({
    longitude: {
      sync: true,
    },
    latitude: {
      sync: true,
    },
  });
  chart.axis(false);
  chart.removeInteraction('continuous-filter');
  chart.legend({ position: 'right' });
  chart.tooltip({
    showTitle: false,
  });
  const bgView = chart.createView();
  bgView.data(dv.rows);
  bgView.tooltip(false);
  const plygons = bgView.polygon().position('longitude*latitude').color('#ebedf0').style({
    lineWidth: 1,
    stroke: '#fafbfc',
  });

  const userView = chart.createView();
  userView.data(userDv.rows);
  const point = userView
    .point()
    .position('longitude*latitude')
    .color('#1890ff')
    .shape('circle')
    .size('value', [5, 15])
    .style({
      lineWidth: 1,
      stroke: '#1890ff',
    });
  chart.render();
  const context = new Context(chart);
  const filter = new Filter(context);
  const legend = chart.getComponents()[0].component;
  it('test filter', () => {
    const count = point.elements.length;
    // @ts-ignore
    legend.setValue([20, 50]);
    context.event = {
      target: legend.get('group'),
    };
    filter.filter();
    expect(plygons.elements.length).not.toBe(0);
    expect(point.elements.length).not.toBe(count);
    // @ts-ignore
    legend.setValue(null);
    filter.filter();
    expect(point.elements.length).toBe(count);
  });
  afterAll(() => {
    context.destroy();
    chart.destroy();
  });
});
