NAMESPACE_ENTER(GFX)
NAMESPACE_ENTER(GFX_MB)

#include GFX_SETTINGS_DEF

#if MOTION_BLUR

/**
 * Copyright (C) 2015 Lucifer Hawk (mediehawk@gmail.com)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software with restriction, including without limitation the rights to
 * use and/or sell copies of the Software, and to permit persons to whom the Software 
 * is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and the permission notices (this and below) shall 
 * be included in all copies or substantial portions of the Software.
 *
 * Permission needs to be specifically granted by the author of the software to any
 * person obtaining a copy of this software and associated documentation files 
 * (the "Software"), to deal in the Software without restriction, including without 
 * limitation the rights to copy, modify, merge, publish, distribute, and/or 
 * sublicense the Software, and subject to the following conditions:
 *
 * The above copyright notice and the permission notices (this and above) shall 
 * be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

texture2D currTex { Width = BUFFER_WIDTH; Height = BUFFER_HEIGHT; Format = RGBA8; };
texture2D prevSingleTex { Width = BUFFER_WIDTH; Height = BUFFER_HEIGHT; Format = RGBA8; };
texture2D prevTex { Width = BUFFER_WIDTH; Height = BUFFER_HEIGHT; Format = RGBA8; };

sampler2D currColor { Texture = currTex; };
sampler2D prevSingleColor { Texture = prevSingleTex; };
sampler2D prevColor { Texture = prevTex; };

float4 PS_Combine(float4 vpos : SV_Position, float2 texcoord : TEXCOORD) : SV_Target
{
	float4 curr = tex2D(currColor, texcoord);
	float4 prevSingle = tex2D(prevSingleColor, texcoord);
	float4 prev = tex2D(prevColor, texcoord);

	float3 diff3 = abs(prevSingle.rgb - curr.rgb) * 2.0f;
	float diff = min(diff3.r + diff3.g + diff3.b, mbRecall);

	const float weight[11] = { 0.082607, 0.040484, 0.038138, 0.034521, 0.030025, 0.025094, 0.020253, 0.015553, 0.011533, 0.008218, 0.005627 };
	prev *= weight[0];

	float pixelBlur = (mbSoftness * 13 * (diff)) * (BUFFER_RCP_WIDTH);
	float pixelBlur2 = (mbSoftness * 11 * (diff)) * (BUFFER_RCP_HEIGHT);

	[unroll]
	for (int z = 1; z < 11; z++)
	{
		prev += tex2D(prevColor, texcoord + float2(z * pixelBlur, 0.0f)) * weight[z];
		prev += tex2D(prevColor, texcoord - float2(z * pixelBlur, 0.0f)) * weight[z];
		prev += tex2D(prevColor, texcoord + float2(0.0f, z * pixelBlur2)) * weight[z];
		prev += tex2D(prevColor, texcoord - float2(0.0f, z * pixelBlur2)) * weight[z];
	}

	return lerp(curr, prev, diff+0.1);
}

float4 PS_CopyFrame(float4 vpos : SV_Position, float2 texcoord : TEXCOORD) : SV_Target
{
	return tex2D(RFX_backbufferColor, texcoord);
}

void PS_CopyPreviousFrame(float4 vpos : SV_Position, float2 texcoord : TEXCOORD, out float4 prevSingle : SV_Target0, out float4 prev : SV_Target1)
{
	prevSingle = tex2D(currColor, texcoord);
	prev = tex2D(RFX_backbufferColor, texcoord);
}

technique MotionBlur_Tech <bool enabled = RFX_Start_Enabled; int toggle = MotionBlur_ToggleKey; >
{
	pass CopyFrame
	{
		VertexShader = RFX_VS_PostProcess;
		PixelShader = PS_CopyFrame;
		RenderTarget = currTex;
	}

	pass Combine
	{
		VertexShader = RFX_VS_PostProcess;
		PixelShader = PS_Combine;
	}

	pass PrevColor
	{
		VertexShader = RFX_VS_PostProcess;
		PixelShader = PS_CopyPreviousFrame;
		RenderTarget0 = prevSingleTex;
		RenderTarget1 = prevTex;
	}
}

#endif

#include GFX_SETTINGS_UNDEF

NAMESPACE_LEAVE()
NAMESPACE_LEAVE()