/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.openapi.wrappers.foundation.favorites;

import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import org.gradle.gradleplugin.foundation.favorites.FavoriteTask;
import org.gradle.gradleplugin.foundation.favorites.FavoritesEditor;
import org.gradle.gradleplugin.userinterface.swing.generic.SwingEditFavoriteInteraction;
import org.gradle.openapi.external.foundation.TaskVersion1;
import org.gradle.openapi.external.foundation.favorites.FavoriteTaskVersion1;
import org.gradle.openapi.external.foundation.favorites.FavoritesEditorVersion1;
import org.gradle.openapi.wrappers.foundation.favorites.FavoriteTaskWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FavoritesEditorWrapper
implements FavoritesEditorVersion1 {
    private FavoritesEditor favoritesEditor;

    public FavoritesEditorWrapper(FavoritesEditor favoritesEditor) {
        this.favoritesEditor = favoritesEditor;
    }

    public FavoriteTaskVersion1 addFavorite(String fullCommandLine, String displayName, boolean alwaysShowOutput) {
        return this.convertFavoriteTask(this.favoritesEditor.addFavorite(fullCommandLine, displayName, alwaysShowOutput));
    }

    public String editFavorite(FavoriteTaskVersion1 favoriteTaskVersion1, final String newFullCommandLine, final String newDisplayName, final boolean newAlwaysShowOutput) {
        final StringHolder stringHolder = new StringHolder();
        FavoriteTask favoriteTask = this.getFavoriteTask(favoriteTaskVersion1);
        this.favoritesEditor.editFavorite(favoriteTask, new FavoritesEditor.EditFavoriteInteraction(){

            public boolean editFavorite(FavoritesEditor.EditibleFavoriteTask favoriteTask) {
                favoriteTask.fullCommandLine = newFullCommandLine;
                favoriteTask.displayName = newDisplayName;
                favoriteTask.alwaysShowOutput = newAlwaysShowOutput;
                return true;
            }

            public void reportError(String error) {
                stringHolder.string = error;
            }
        });
        return stringHolder.string;
    }

    private FavoriteTaskVersion1 convertFavoriteTask(FavoriteTask favoriteTask) {
        if (favoriteTask == null) {
            return null;
        }
        return new FavoriteTaskWrapper(favoriteTask);
    }

    public List<FavoriteTaskVersion1> getFavoriteTasks() {
        ArrayList<FavoriteTaskVersion1> returnedTasks = new ArrayList<FavoriteTaskVersion1>();
        for (FavoriteTask favoriteTask : this.favoritesEditor.getFavoriteTasks()) {
            returnedTasks.add(new FavoriteTaskWrapper(favoriteTask));
        }
        return returnedTasks;
    }

    public FavoriteTaskVersion1 getFavorite(String fullCommandLine) {
        return this.convertFavoriteTask(this.favoritesEditor.getFavorite(fullCommandLine));
    }

    public FavoriteTaskVersion1 getFavoriteByDisplayName(String displayName) {
        return this.convertFavoriteTask(this.favoritesEditor.getFavoriteByDisplayName(displayName));
    }

    public FavoriteTaskVersion1 getFavorite(TaskVersion1 task) {
        return this.convertFavoriteTask(this.favoritesEditor.getFavorite(task.getFullTaskName()));
    }

    public FavoriteTaskVersion1 promptUserToAddFavorite(Window parent) {
        FavoriteTask favoriteTask = this.favoritesEditor.addFavorite(new SwingEditFavoriteInteraction(parent, "Add Favorite", SwingEditFavoriteInteraction.SynchronizeType.OnlyIfAlreadySynchronized));
        return this.convertFavoriteTask(favoriteTask);
    }

    public boolean promptUserToEditFavorite(Window parent, FavoriteTaskVersion1 favorite) {
        FavoriteTask favoriteTask = this.getFavoriteTask(favorite);
        return this.favoritesEditor.editFavorite(favoriteTask, new SwingEditFavoriteInteraction(parent, "Edit Favorite", SwingEditFavoriteInteraction.SynchronizeType.OnlyIfAlreadySynchronized));
    }

    public void removeFavorites(List<FavoriteTaskVersion1> favoritesToRemove) {
        ArrayList<FavoriteTask> favoriteTasksToRemove = new ArrayList<FavoriteTask>();
        for (FavoriteTaskVersion1 favoriteTaskVersion1 : favoritesToRemove) {
            favoriteTasksToRemove.add(this.getFavoriteTask(favoriteTaskVersion1));
        }
        this.favoritesEditor.removeFavorites(favoriteTasksToRemove);
    }

    private FavoriteTask getFavoriteTask(FavoriteTaskVersion1 favoriteTaskVersion1) {
        return ((FavoriteTaskWrapper)favoriteTaskVersion1).getFavoriteTask();
    }

    private class StringHolder {
        private String string;

        private StringHolder() {
        }
    }
}

