/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.tasks.cache.TarTaskOutputPacker;
import org.gradle.api.internal.tasks.cache.TaskOutputPacker;

public class GZipTaskOutputPacker
implements TaskOutputPacker {
    private final TarTaskOutputPacker delegate;

    public GZipTaskOutputPacker(TarTaskOutputPacker delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pack(TaskOutputsInternal taskOutputs, OutputStream output) throws IOException {
        GZIPOutputStream gzipOutput = new GZIPOutputStream(output);
        try {
            this.delegate.pack(taskOutputs, gzipOutput);
        }
        finally {
            gzipOutput.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpack(TaskOutputsInternal taskOutputs, InputStream input) throws IOException {
        GZIPInputStream gzipInput = new GZIPInputStream(input);
        try {
            this.delegate.unpack(taskOutputs, gzipInput);
        }
        finally {
            gzipInput.close();
        }
    }
}

