/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.projectresult;

import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.projectresult.ResolvedLocalComponentsResultBuilder;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;

public class ResolvedLocalComponentsResultGraphVisitor
implements DependencyGraphVisitor {
    private final ResolvedLocalComponentsResultBuilder builder;
    private ComponentIdentifier rootId;

    public ResolvedLocalComponentsResultGraphVisitor(ResolvedLocalComponentsResultBuilder builder) {
        this.builder = builder;
    }

    @Override
    public void start(DependencyGraphNode root) {
        this.rootId = root.getOwner().getComponentId();
    }

    @Override
    public void visitNode(DependencyGraphNode resolvedConfiguration) {
        ConfigurationMetadata configurationMetadata;
        ComponentIdentifier componentId = resolvedConfiguration.getOwner().getComponentId();
        if (this.rootId.equals(componentId)) {
            return;
        }
        if (componentId instanceof ProjectComponentIdentifier) {
            this.builder.projectConfigurationResolved((ProjectComponentIdentifier)componentId, resolvedConfiguration.getNodeId().getConfiguration());
        }
        if ((configurationMetadata = resolvedConfiguration.getMetadata()) instanceof LocalConfigurationMetadata) {
            this.builder.localComponentResolved(componentId, ((LocalConfigurationMetadata)configurationMetadata).getDirectBuildDependencies());
        }
    }

    @Override
    public void visitEdge(DependencyGraphNode resolvedConfiguration) {
    }

    @Override
    public void finish(DependencyGraphNode root) {
    }
}

