/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.ScheduledExecutorService;
import org.gradle.internal.util.NumberUtil;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionInfo;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionMonitor;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionStats;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectorMonitoringStrategy;
import org.gradle.launcher.daemon.server.health.memory.MemoryInfo;
import org.gradle.launcher.daemon.server.stats.DaemonRunningStats;

public class DaemonHealthStats {
    private final DaemonRunningStats runningStats;
    private final MemoryInfo memoryInfo;
    private final GarbageCollectionInfo gcInfo;
    private final GarbageCollectionMonitor gcMonitor;

    public DaemonHealthStats(DaemonRunningStats runningStats, ScheduledExecutorService scheduledExecutorService) {
        this(runningStats, new MemoryInfo(), new GarbageCollectionInfo(), new GarbageCollectionMonitor(scheduledExecutorService));
    }

    @VisibleForTesting
    DaemonHealthStats(DaemonRunningStats runningStats, MemoryInfo memoryInfo, GarbageCollectionInfo gcInfo, GarbageCollectionMonitor gcMonitor) {
        this.runningStats = runningStats;
        this.memoryInfo = memoryInfo;
        this.gcInfo = gcInfo;
        this.gcMonitor = gcMonitor;
    }

    int getCurrentPerformance() {
        long collectionTime = this.gcInfo.getCollectionTime();
        long allBuildsTime = this.runningStats.getAllBuildsTime();
        if (collectionTime > 0L && collectionTime < allBuildsTime) {
            return 100 - NumberUtil.percentOf(collectionTime, allBuildsTime);
        }
        return 100;
    }

    String getHealthInfo() {
        int nextBuildNum = this.runningStats.getBuildCount() + 1;
        if (nextBuildNum == 1) {
            return String.format("Starting build in new daemon [memory: %s]", NumberUtil.formatBytes(this.memoryInfo.getMaxMemory()));
        }
        if (this.gcMonitor.getGcStrategy() != GarbageCollectorMonitoringStrategy.UNKNOWN) {
            GarbageCollectionStats tenuredStats = this.gcMonitor.getTenuredStats();
            GarbageCollectionStats permgenStats = this.gcMonitor.getPermGenStats();
            String message = String.format("Starting %s build in daemon [uptime: %s, performance: %s%%", NumberUtil.ordinal(nextBuildNum), this.runningStats.getPrettyUpTime(), this.getCurrentPerformance());
            if (tenuredStats.getUsage() > 0) {
                message = message + String.format(", GC rate: %.2f/s, tenured heap usage: %s%% of %s", tenuredStats.getRate(), tenuredStats.getUsage(), NumberUtil.formatBytes(tenuredStats.getMax()));
                if (permgenStats.getUsage() > 0) {
                    message = message + String.format(", perm gen usage: %s%% of %s", permgenStats.getUsage(), NumberUtil.formatBytes(permgenStats.getMax()));
                }
            } else {
                message = message + ", no major garbage collections";
            }
            message = message + "]";
            return message;
        }
        return String.format("Starting %s build in daemon [uptime: %s, performance: %s%%]", NumberUtil.ordinal(nextBuildNum), this.runningStats.getPrettyUpTime(), this.getCurrentPerformance());
    }

    GarbageCollectionMonitor getGcMonitor() {
        return this.gcMonitor;
    }
}

