/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.fixStack.DecompiledTryDescriptor;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001aD\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\nH\u0002\u001a\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a$\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u000eH\u0002\u001a\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"collectDecompiledTryDescriptors", "", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/DecompiledTryDescriptor;", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "insertSaveRestoreStackMarkers", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "decompiledTryDescriptorForStart", "newTryStartLabels", "", "insertTryCatchBlocksMarkers", "transformTryCatchBlocks", "", "Ljava/util/HashMap;", "debugString", "", "tcb", "Lorg/jetbrains/org/objectweb/asm/tree/TryCatchBlockNode;", "isDefaultHandlerNode", "", "kotlin-compiler"})
public final class AnalyzeTryCatchBlocksKt {
    private static final boolean isDefaultHandlerNode(@NotNull TryCatchBlockNode $receiver) {
        return Intrinsics.areEqual($receiver.start, $receiver.handler);
    }

    private static final String debugString(@NotNull MethodNode $receiver, TryCatchBlockNode tcb) {
        return "TCB<" + $receiver.instructions.indexOf(tcb.start) + ", " + $receiver.instructions.indexOf(tcb.end) + ", " + $receiver.instructions.indexOf(tcb.handler) + ">";
    }

    @NotNull
    public static final Map<AbstractInsnNode, AbstractInsnNode> insertTryCatchBlocksMarkers(@NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        if (methodNode.tryCatchBlocks.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Map<LabelNode, DecompiledTryDescriptor> decompiledTryDescriptorForStart = AnalyzeTryCatchBlocksKt.collectDecompiledTryDescriptors(methodNode);
        HashMap<LabelNode, LabelNode> newTryStartLabels = MapsKt.hashMapOf(new Pair[0]);
        Map<AbstractInsnNode, AbstractInsnNode> restoreStackToSaveStackMarker = AnalyzeTryCatchBlocksKt.insertSaveRestoreStackMarkers(decompiledTryDescriptorForStart, methodNode, (Map<LabelNode, LabelNode>)newTryStartLabels);
        AnalyzeTryCatchBlocksKt.transformTryCatchBlocks(methodNode, newTryStartLabels);
        return restoreStackToSaveStackMarker;
    }

    /*
     * WARNING - void declaration
     */
    private static final void transformTryCatchBlocks(MethodNode methodNode, HashMap<LabelNode, LabelNode> newTryStartLabels) {
        List list2;
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = methodNode.tryCatchBlocks;
        MethodNode methodNode2 = methodNode;
        void var4_4 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void tcb;
            TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)item$iv$iv;
            list2 = destination$iv$iv;
            LabelNode newTryStartLabel = newTryStartLabels.get(tcb.start);
            TryCatchBlockNode tryCatchBlockNode2 = newTryStartLabel == null ? tcb : new TryCatchBlockNode(newTryStartLabel, tcb.end, tcb.handler, tcb.type);
            list2.add(tryCatchBlockNode2);
        }
        methodNode2.tryCatchBlocks = list2 = (List)destination$iv$iv;
    }

    private static final Map<AbstractInsnNode, AbstractInsnNode> insertSaveRestoreStackMarkers(Map<LabelNode, DecompiledTryDescriptor> decompiledTryDescriptorForStart, MethodNode methodNode, Map<LabelNode, LabelNode> newTryStartLabels) {
        HashMap restoreStackToSaveMarker = MapsKt.hashMapOf(new Pair[0]);
        HashMap saveStackMarkerByTryLabel = MapsKt.hashMapOf(new Pair[0]);
        HashSet<LabelNode> doneHandlerLabels = SetsKt.hashSetOf(new LabelNode[0]);
        for (DecompiledTryDescriptor decompiledTryDescriptor : decompiledTryDescriptorForStart.values()) {
            AbstractInsnNode saveStackMarker;
            Object it;
            DecompiledTryDescriptor $receiver = decompiledTryDescriptor;
            Map map2 = saveStackMarkerByTryLabel;
            Object object = $receiver.getTryStartLabel();
            Map map3 = map2;
            Map map4 = map3;
            if (map4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
            }
            if (map4.containsKey(object) ^ true) {
                AbstractInsnNode nopNode;
                AbstractInsnNode finger$iv;
                object = $receiver.getTryStartLabel();
                for (finger$iv = $receiver$iv.getNext(); finger$iv != null && !UtilKt.hasOpcode((AbstractInsnNode)(it = finger$iv)); finger$iv = finger$iv.getNext()) {
                }
                if (finger$iv == null) {
                    Intrinsics.throwNpe();
                }
                boolean $receiver$iv = nopNode.getOpcode() == 0;
                if (_Assertions.ENABLED && !$receiver$iv) {
                    it = methodNode.instructions.indexOf(nopNode) + ": try block should start with NOP";
                    throw (Throwable)((Object)new AssertionError(it));
                }
                LabelNode newTryStartLabel = new LabelNode(new Label());
                Map<LabelNode, LabelNode> $i$a$1$assert = newTryStartLabels;
                it = $receiver.getTryStartLabel();
                AbstractInsnNode $i$a$1$findNextOrNull = newTryStartLabel;
                $i$a$1$assert.put((LabelNode)it, (LabelNode)$i$a$1$findNextOrNull);
                saveStackMarker = PseudoInsn.SAVE_STACK_BEFORE_TRY.createInsnNode();
                MethodInsnNode restoreStackMarker = PseudoInsn.RESTORE_STACK_IN_TRY_CATCH.createInsnNode();
                it = saveStackMarkerByTryLabel;
                $i$a$1$findNextOrNull = $receiver.getTryStartLabel();
                AbstractInsnNode $i$f$findNextOrNull = saveStackMarker;
                it.put($i$a$1$findNextOrNull, $i$f$findNextOrNull);
                it = restoreStackToSaveMarker;
                $i$a$1$findNextOrNull = saveStackMarker;
                it.put(restoreStackMarker, $i$a$1$findNextOrNull);
                methodNode.instructions.insertBefore(nopNode, saveStackMarker);
                methodNode.instructions.insertBefore(nopNode, newTryStartLabel);
                methodNode.instructions.insert(nopNode, restoreStackMarker);
            } else {
                Object v = saveStackMarkerByTryLabel.get($receiver.getTryStartLabel());
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                saveStackMarker = (AbstractInsnNode)v;
            }
            for (LabelNode handlerStartLabel : $receiver.getHandlerStartLabels()) {
                Object object2;
                AbstractInsnNode storeNode;
                AbstractInsnNode it2;
                AbstractInsnNode finger$iv;
                if (doneHandlerLabels.contains(handlerStartLabel)) continue;
                doneHandlerLabels.add(handlerStartLabel);
                it = handlerStartLabel;
                for (finger$iv = $receiver$iv.getNext(); finger$iv != null && !UtilKt.hasOpcode(it2 = finger$iv); finger$iv = finger$iv.getNext()) {
                }
                if (finger$iv == null) {
                    Intrinsics.throwNpe();
                }
                boolean $receiver$iv = storeNode.getOpcode() == 58;
                if (_Assertions.ENABLED && !$receiver$iv) {
                    object2 = methodNode.instructions.indexOf(storeNode) + ": handler should start with ASTORE";
                    throw (Throwable)((Object)new AssertionError(object2));
                }
                MethodInsnNode restoreStackMarker = PseudoInsn.RESTORE_STACK_IN_TRY_CATCH.createInsnNode();
                Map map5 = restoreStackToSaveMarker;
                object2 = saveStackMarker;
                map5.put(restoreStackMarker, object2);
                methodNode.instructions.insert(storeNode, restoreStackMarker);
            }
        }
        return restoreStackToSaveMarker;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<LabelNode, DecompiledTryDescriptor> collectDecompiledTryDescriptors(MethodNode methodNode) {
        Map decompiledTryDescriptorForStart = MapsKt.hashMapOf(new Pair[0]);
        Map decompiledTryDescriptorForHandler = MapsKt.hashMapOf(new Pair[0]);
        for (TryCatchBlockNode tcb : methodNode.tryCatchBlocks) {
            Object object;
            void key$iv;
            void $receiver$iv;
            if (AnalyzeTryCatchBlocksKt.isDefaultHandlerNode(tcb)) {
                boolean bl = decompiledTryDescriptorForHandler.containsKey(tcb.start);
                if (_Assertions.ENABLED && !bl) {
                    StringBuilder stringBuilder = new StringBuilder();
                    TryCatchBlockNode tryCatchBlockNode = tcb;
                    Intrinsics.checkExpressionValueIsNotNull(tryCatchBlockNode, "tcb");
                    String string = stringBuilder.append(AnalyzeTryCatchBlocksKt.debugString(methodNode, tryCatchBlockNode)).append(": default handler should occur after some regular handler").toString();
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
            }
            Map $i$a$1$assert = decompiledTryDescriptorForHandler;
            Intrinsics.checkExpressionValueIsNotNull(tcb.handler, "tcb.handler");
            Object value$iv = $receiver$iv.get(key$iv);
            if (value$iv == null) {
                Object object2;
                void key$iv2;
                void $receiver$iv2;
                Map map2 = decompiledTryDescriptorForStart;
                Intrinsics.checkExpressionValueIsNotNull(tcb.start, "tcb.start");
                Object value$iv2 = $receiver$iv2.get(key$iv2);
                if (value$iv2 == null) {
                    LabelNode labelNode = tcb.start;
                    Intrinsics.checkExpressionValueIsNotNull(labelNode, "tcb.start");
                    DecompiledTryDescriptor answer$iv = new DecompiledTryDescriptor(labelNode);
                    $receiver$iv2.put(key$iv2, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv2;
                }
                DecompiledTryDescriptor answer$iv = (DecompiledTryDescriptor)object2;
                $receiver$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            DecompiledTryDescriptor decompiledTryDescriptor = (DecompiledTryDescriptor)object;
            DecompiledTryDescriptor $receiver = decompiledTryDescriptor;
            $receiver.getHandlerStartLabels().add(tcb.handler);
            if (!AnalyzeTryCatchBlocksKt.isDefaultHandlerNode(tcb)) continue;
            boolean bl = $receiver.getDefaultHandlerTcb() == null;
            if (_Assertions.ENABLED && !bl) {
                StringBuilder stringBuilder = new StringBuilder();
                TryCatchBlockNode tryCatchBlockNode = tcb;
                Intrinsics.checkExpressionValueIsNotNull(tryCatchBlockNode, "tcb");
                StringBuilder stringBuilder2 = stringBuilder.append(AnalyzeTryCatchBlocksKt.debugString(methodNode, tryCatchBlockNode)).append(": default handler is already found: ");
                TryCatchBlockNode tryCatchBlockNode2 = $receiver.getDefaultHandlerTcb();
                if (tryCatchBlockNode2 == null) {
                    Intrinsics.throwNpe();
                }
                String string = stringBuilder2.append(AnalyzeTryCatchBlocksKt.debugString(methodNode, tryCatchBlockNode2)).toString();
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            $receiver.setDefaultHandlerTcb(tcb);
        }
        return decompiledTryDescriptorForStart;
    }
}

