/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiDiamondType;
import org.jetbrains.kotlin.com.intellij.psi.PsiDisjunctionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpressionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceType;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;

public class PsiTypeVisitor<A> {
    @Nullable
    public A visitType(PsiType type2) {
        return null;
    }

    @Nullable
    public A visitPrimitiveType(PsiPrimitiveType primitiveType) {
        return this.visitType(primitiveType);
    }

    @Nullable
    public A visitArrayType(PsiArrayType arrayType) {
        return this.visitType(arrayType);
    }

    @Nullable
    public A visitClassType(PsiClassType classType) {
        return this.visitType(classType);
    }

    @Nullable
    public A visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
        return this.visitWildcardType(capturedWildcardType.getWildcard());
    }

    @Nullable
    public A visitWildcardType(PsiWildcardType wildcardType) {
        return this.visitType(wildcardType);
    }

    @Nullable
    public A visitEllipsisType(PsiEllipsisType ellipsisType) {
        return this.visitArrayType(ellipsisType);
    }

    @Nullable
    public A visitDisjunctionType(PsiDisjunctionType disjunctionType) {
        return this.visitType(disjunctionType);
    }

    @Nullable
    public A visitIntersectionType(PsiIntersectionType intersectionType) {
        PsiType type2 = intersectionType.getConjuncts()[0];
        return type2.accept(this);
    }

    @Nullable
    public A visitDiamondType(PsiDiamondType diamondType) {
        return this.visitType(diamondType);
    }

    @Nullable
    public A visitLambdaExpressionType(PsiLambdaExpressionType lambdaExpressionType) {
        PsiLambdaExpression lambdaExpression = lambdaExpressionType.getExpression();
        PsiType interfaceType = lambdaExpression.getFunctionalInterfaceType();
        if (interfaceType != null && LambdaUtil.isFunctionalType(interfaceType)) {
            return interfaceType.accept(this);
        }
        return this.visitType(lambdaExpressionType);
    }

    public A visitMethodReferenceType(PsiMethodReferenceType methodReferenceType) {
        PsiMethodReferenceExpression expression = methodReferenceType.getExpression();
        PsiType interfaceType = expression.getFunctionalInterfaceType();
        if (interfaceType != null && LambdaUtil.isFunctionalType(interfaceType)) {
            return interfaceType.accept(this);
        }
        return this.visitType(methodReferenceType);
    }
}

