/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers;

import java.lang.ref.Reference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.SmartTypePointer;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;

public abstract class TypePointerBase<T extends PsiType>
implements SmartTypePointer {
    private Reference<T> myTypeRef;

    public TypePointerBase(@NotNull T type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/TypePointerBase", "<init>"));
        }
        this.myTypeRef = new SoftReference<T>(type2);
    }

    public T getType() {
        PsiType myType = (PsiType)SoftReference.dereference(this.myTypeRef);
        if (myType != null && myType.isValid()) {
            return (T)myType;
        }
        myType = this.calcType();
        this.myTypeRef = myType == null ? null : new SoftReference<PsiType>(myType);
        return (T)myType;
    }

    @Nullable
    protected abstract T calcType();
}

