/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.CommonClassNames;
import org.jetbrains.kotlin.com.intellij.util.CharTable;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.text.StringFactory;
import org.jetbrains.kotlin.gnu.trove.TIntObjectHashMap;

public class CharTableImpl
implements CharTable {
    private static final StringHashToCharSequencesMap STATIC_ENTRIES = CharTableImpl.newStaticSet();
    private final StringHashToCharSequencesMap entries = new StringHashToCharSequencesMap(10, 0.9f);

    @Override
    @NotNull
    public CharSequence intern(@NotNull CharSequence text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/source/CharTableImpl", "intern"));
        }
        CharSequence charSequence = text2.length() > 40 ? CharTableImpl.createSequence(text2) : this.doIntern(text2);
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/CharTableImpl", "intern"));
        }
        return charSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private CharSequence doIntern(@NotNull CharSequence text2, int startOffset, int endOffset) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/source/CharTableImpl", "doIntern"));
        }
        int hashCode = CharTableImpl.subSequenceHashCode(text2, startOffset, endOffset);
        CharSequence interned = CharTableImpl.STATIC_ENTRIES.getSubSequenceWithHashCode(hashCode, text2, startOffset, endOffset);
        if (interned != null) {
            CharSequence charSequence = interned;
            if (charSequence != null) return charSequence;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/CharTableImpl", "doIntern"));
        }
        StringHashToCharSequencesMap stringHashToCharSequencesMap = this.entries;
        // MONITORENTER : stringHashToCharSequencesMap
        CharSequence charSequence = this.entries.getOrAddSubSequenceWithHashCode(hashCode, text2, startOffset, endOffset);
        // MONITOREXIT : stringHashToCharSequencesMap
        if (charSequence != null) return charSequence;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/CharTableImpl", "doIntern"));
    }

    @NotNull
    public CharSequence doIntern(@NotNull CharSequence text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/source/CharTableImpl", "doIntern"));
        }
        CharSequence charSequence = this.doIntern(text2, 0, text2.length());
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/CharTableImpl", "doIntern"));
        }
        return charSequence;
    }

    @Override
    @NotNull
    public CharSequence intern(@NotNull CharSequence baseText, int startOffset, int endOffset) {
        if (baseText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseText", "org/jetbrains/kotlin/com/intellij/psi/impl/source/CharTableImpl", "intern"));
        }
        CharSequence result2 = endOffset - startOffset == baseText.length() ? this.intern(baseText) : (endOffset - startOffset > 40 ? CharTableImpl.createSequence(baseText, startOffset, endOffset) : this.doIntern(baseText, startOffset, endOffset));
        CharSequence charSequence = result2;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/CharTableImpl", "intern"));
        }
        return charSequence;
    }

    @NotNull
    private static String createSequence(@NotNull CharSequence text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/source/CharTableImpl", "createSequence"));
        }
        String string = CharTableImpl.createSequence(text2, 0, text2.length());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/CharTableImpl", "createSequence"));
        }
        return string;
    }

    @NotNull
    private static String createSequence(@NotNull CharSequence text2, int startOffset, int endOffset) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/source/CharTableImpl", "createSequence"));
        }
        if (text2 instanceof String) {
            String string = ((String)text2).substring(startOffset, endOffset);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/CharTableImpl", "createSequence"));
            }
            return string;
        }
        char[] buf = new char[endOffset - startOffset];
        CharArrayUtil.getChars(text2, buf, startOffset, 0, buf.length);
        String string = StringFactory.createShared(buf);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/CharTableImpl", "createSequence"));
        }
        return string;
    }

    @Nullable
    public static CharSequence getStaticInterned(@NotNull CharSequence text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/source/CharTableImpl", "getStaticInterned"));
        }
        return CharTableImpl.STATIC_ENTRIES.get(text2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void staticIntern(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/source/CharTableImpl", "staticIntern"));
        }
        StringHashToCharSequencesMap stringHashToCharSequencesMap = STATIC_ENTRIES;
        synchronized (stringHashToCharSequencesMap) {
            CharTableImpl.STATIC_ENTRIES.add(text2);
        }
    }

    private static StringHashToCharSequencesMap newStaticSet() {
        StringHashToCharSequencesMap r = new StringHashToCharSequencesMap(10, 0.9f);
        r.add("==");
        r.add("!=");
        r.add("||");
        r.add("++");
        r.add("--");
        r.add("<");
        r.add("<=");
        r.add("<<=");
        r.add("<<");
        r.add(">");
        r.add("&");
        r.add("&&");
        r.add("+=");
        r.add("-=");
        r.add("*=");
        r.add("/=");
        r.add("&=");
        r.add("|=");
        r.add("^=");
        r.add("%=");
        r.add("(");
        r.add(")");
        r.add("{");
        r.add("}");
        r.add("[");
        r.add("]");
        r.add(";");
        r.add(",");
        r.add("...");
        r.add(".");
        r.add("=");
        r.add("!");
        r.add("~");
        r.add("?");
        r.add(":");
        r.add("+");
        r.add("-");
        r.add("*");
        r.add("/");
        r.add("|");
        r.add("^");
        r.add("%");
        r.add("@");
        r.add(" ");
        r.add("  ");
        r.add("   ");
        r.add("    ");
        r.add("     ");
        r.add("      ");
        r.add("       ");
        r.add("        ");
        r.add("         ");
        r.add("          ");
        r.add("           ");
        r.add("            ");
        r.add("             ");
        r.add("              ");
        r.add("               ");
        r.add("\n");
        r.add("\n  ");
        r.add("\n    ");
        r.add("\n      ");
        r.add("\n        ");
        r.add("\n          ");
        r.add("\n            ");
        r.add("\n              ");
        r.add("\n                ");
        r.add("<");
        r.add(">");
        r.add("</");
        r.add("/>");
        r.add("\"");
        r.add("'");
        r.add("<![CDATA[");
        r.add("]]>");
        r.add("<!--");
        r.add("-->");
        r.add("<!DOCTYPE");
        r.add("SYSTEM");
        r.add("PUBLIC");
        r.add("<?");
        r.add("?>");
        r.add("<%");
        r.add("%>");
        r.add("<%=");
        r.add("<%@");
        r.add("${");
        r.add("");
        return r;
    }

    public static void addStringsFromClassToStatics(@NotNull Class aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/source/CharTableImpl", "addStringsFromClassToStatics"));
        }
        for (Field field : aClass2.getDeclaredFields()) {
            String typeName;
            if ((field.getModifiers() & 8) == 0 || (field.getModifiers() & 1) == 0 || (typeName = ReflectionUtil.getStaticFieldValue(aClass2, String.class, field.getName())) == null) continue;
            CharTableImpl.staticIntern(typeName);
        }
    }

    private static int subSequenceHashCode(CharSequence sequence2, int startOffset, int endOffset) {
        if (startOffset == 0 && endOffset == sequence2.length()) {
            return StringUtil.stringHashCode(sequence2);
        }
        return StringUtil.stringHashCode(sequence2, startOffset, endOffset);
    }

    static {
        CharTableImpl.addStringsFromClassToStatics(CommonClassNames.class);
    }

    private static class StringHashToCharSequencesMap
    extends TIntObjectHashMap<Object> {
        private StringHashToCharSequencesMap(int capacity, float loadFactor) {
            super(capacity, loadFactor);
        }

        private CharSequence get(CharSequence sequence2, int startOffset, int endOffset) {
            return this.getSubSequenceWithHashCode(CharTableImpl.subSequenceHashCode(sequence2, startOffset, endOffset), sequence2, startOffset, endOffset);
        }

        private CharSequence getSubSequenceWithHashCode(int hashCode, CharSequence sequence2, int startOffset, int endOffset) {
            Object o = this.get(hashCode);
            if (o == null) {
                return null;
            }
            if (o instanceof CharSequence) {
                if (StringHashToCharSequencesMap.charSequenceSubSequenceEquals((CharSequence)o, sequence2, startOffset, endOffset)) {
                    return (CharSequence)o;
                }
                return null;
            }
            if (o instanceof CharSequence[]) {
                for (CharSequence cs : (CharSequence[])o) {
                    if (!StringHashToCharSequencesMap.charSequenceSubSequenceEquals(cs, sequence2, startOffset, endOffset)) continue;
                    return cs;
                }
                return null;
            }
            assert (false) : o.getClass();
            return null;
        }

        private static boolean charSequenceSubSequenceEquals(CharSequence cs, CharSequence baseSequence, int startOffset, int endOffset) {
            if (cs.length() != endOffset - startOffset) {
                return false;
            }
            if (cs == baseSequence && startOffset == 0) {
                return true;
            }
            int len = cs.length();
            for (int i = 0; i < len; ++i) {
                if (cs.charAt(i) == baseSequence.charAt(startOffset + i)) continue;
                return false;
            }
            return true;
        }

        private CharSequence get(CharSequence sequence2) {
            return this.get(sequence2, 0, sequence2.length());
        }

        private CharSequence add(CharSequence sequence2) {
            return this.add(sequence2, 0, sequence2.length());
        }

        private CharSequence add(CharSequence sequence2, int startOffset, int endOffset) {
            int hashCode = CharTableImpl.subSequenceHashCode(sequence2, startOffset, endOffset);
            return this.getOrAddSubSequenceWithHashCode(hashCode, sequence2, startOffset, endOffset);
        }

        private CharSequence getOrAddSubSequenceWithHashCode(int hashCode, CharSequence sequence2, int startOffset, int endOffset) {
            int index2 = this.index(hashCode);
            String addedSequence = null;
            if (index2 < 0) {
                addedSequence = CharTableImpl.createSequence(sequence2, startOffset, endOffset);
                this.put(hashCode, addedSequence);
            } else {
                Object value = this._values[index2];
                if (value instanceof CharSequence) {
                    CharSequence existingSequence = (CharSequence)value;
                    if (StringHashToCharSequencesMap.charSequenceSubSequenceEquals(existingSequence, sequence2, startOffset, endOffset)) {
                        return existingSequence;
                    }
                    CharSequence[] charSequenceArray = new CharSequence[2];
                    charSequenceArray[0] = existingSequence;
                    addedSequence = CharTableImpl.createSequence(sequence2, startOffset, endOffset);
                    charSequenceArray[1] = addedSequence;
                    this.put(hashCode, charSequenceArray);
                } else if (value instanceof CharSequence[]) {
                    CharSequence[] existingSequenceArray;
                    for (CharSequence cs : existingSequenceArray = (CharSequence[])value) {
                        if (!StringHashToCharSequencesMap.charSequenceSubSequenceEquals(cs, sequence2, startOffset, endOffset)) continue;
                        return cs;
                    }
                    CharSequence[] newSequenceArray = new CharSequence[existingSequenceArray.length + 1];
                    System.arraycopy(existingSequenceArray, 0, newSequenceArray, 0, existingSequenceArray.length);
                    addedSequence = CharTableImpl.createSequence(sequence2, startOffset, endOffset);
                    newSequenceArray[existingSequenceArray.length] = addedSequence;
                    this.put(hashCode, newSequenceArray);
                } else assert (false) : value.getClass();
            }
            return addedSequence;
        }
    }
}

