/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyKey;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiDiamondType;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.impl.AnyPsiChangeListener;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiClassReferenceType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiImmediateClassType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBus;

public class JavaResolveCache {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.resolve.JavaResolveCache");
    private static final NotNullLazyKey<JavaResolveCache, Project> INSTANCE_KEY = ServiceManager.createLazyKey(JavaResolveCache.class);
    private final ConcurrentMap<PsiExpression, PsiType> myCalculatedTypes = ContainerUtil.createConcurrentWeakKeySoftValueMap();
    private final Map<PsiVariable, Object> myVarToConstValueMapPhysical = ContainerUtil.createConcurrentWeakMap();
    private final Map<PsiVariable, Object> myVarToConstValueMapNonPhysical = ContainerUtil.createConcurrentWeakMap();
    private static final Object NULL = Key.create("NULL");

    public static JavaResolveCache getInstance(Project project) {
        return INSTANCE_KEY.getValue(project);
    }

    public JavaResolveCache(@Nullable(value="can be null in com.intellij.core.JavaCoreApplicationEnvironment.JavaCoreApplicationEnvironment") MessageBus messageBus) {
        if (messageBus != null) {
            messageBus.connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, new AnyPsiChangeListener.Adapter(){

                @Override
                public void beforePsiChanged(boolean isPhysical) {
                    JavaResolveCache.this.clearCaches(isPhysical);
                }
            });
        }
    }

    private void clearCaches(boolean isPhysical) {
        this.myCalculatedTypes.clear();
        if (isPhysical) {
            this.myVarToConstValueMapPhysical.clear();
        }
        this.myVarToConstValueMapNonPhysical.clear();
    }

    @Nullable
    public <T extends PsiExpression> PsiType getType(@NotNull T expr, @NotNull Function<T, PsiType> f) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/JavaResolveCache", "getType"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/JavaResolveCache", "getType"));
        }
        PsiType type2 = (PsiType)this.myCalculatedTypes.get(expr);
        if (type2 == null) {
            boolean isOverloadCheck;
            RecursionGuard.StackStamp dStackStamp = PsiDiamondType.ourDiamondGuard.markStack();
            type2 = f.fun(expr);
            if (!dStackStamp.mayCacheNow()) {
                return type2;
            }
            boolean bl = isOverloadCheck = MethodCandidateInfo.isOverloadCheck() || LambdaUtil.isLambdaParameterCheck();
            if (isOverloadCheck && PsiPolyExpressionUtil.isPolyExpression(expr)) {
                return type2;
            }
            if (type2 == null) {
                type2 = TypeConversionUtil.NULL_TYPE;
            }
            this.myCalculatedTypes.put(expr, type2);
            if (type2 instanceof PsiClassReferenceType) {
                PsiClassType.ClassResolveResult result2 = ((PsiClassReferenceType)type2).resolveGenerics();
                PsiClass psiClass = result2.getElement();
                PsiType psiType = type2 = psiClass == null ? type2 : new PsiImmediateClassType(psiClass, result2.getSubstitutor(), ((PsiClassReferenceType)type2).getLanguageLevel(), type2.getAnnotationProvider());
            }
        }
        if (!type2.isValid()) {
            if (expr.isValid()) {
                PsiJavaCodeReferenceElement refInside = type2 instanceof PsiClassReferenceType ? ((PsiClassReferenceType)type2).getReference() : null;
                String typeinfo = type2 + " (" + type2.getClass() + ")" + (refInside == null ? "" : "; ref inside: " + refInside + " (" + refInside.getClass() + ") valid:" + refInside.isValid());
                LOG.error("Type is invalid: " + typeinfo + "; expr: '" + expr + "' (" + expr.getClass() + ") is valid");
            } else {
                LOG.error("Expression: '" + expr + "' is invalid, must not be used for getType()");
            }
        }
        return type2 == TypeConversionUtil.NULL_TYPE ? null : type2;
    }

    @Nullable
    public Object computeConstantValueWithCaching(@NotNull PsiVariable variable, @NotNull ConstValueComputer computer, Set<PsiVariable> visitedVars) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/JavaResolveCache", "computeConstantValueWithCaching"));
        }
        if (computer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computer", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/JavaResolveCache", "computeConstantValueWithCaching"));
        }
        boolean physical = variable.isPhysical();
        Map<PsiVariable, Object> map2 = physical ? this.myVarToConstValueMapPhysical : this.myVarToConstValueMapNonPhysical;
        Object cached = map2.get(variable);
        if (cached == NULL) {
            return null;
        }
        if (cached != null) {
            return cached;
        }
        Object result2 = computer.execute(variable, visitedVars);
        map2.put(variable, result2 == null ? NULL : result2);
        return result2;
    }

    public static interface ConstValueComputer {
        public Object execute(@NotNull PsiVariable var1, Set<PsiVariable> var2);
    }
}

