/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.concurrency;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.Patches;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class BoundedTaskExecutor
extends AbstractExecutorService {
    private volatile boolean myShutdown;
    private final Executor myBackendExecutor;
    private final int myMaxTasks;
    private final AtomicLong myStatus;
    private final BlockingQueue<Runnable> myTaskQueue;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BoundedTaskExecutor(@NotNull Executor backendExecutor, int maxSimultaneousTasks) {
        if (backendExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backendExecutor", "org/jetbrains/kotlin/com/intellij/util/concurrency/BoundedTaskExecutor", "<init>"));
        }
        this.myStatus = new AtomicLong();
        this.myTaskQueue = new LinkedBlockingQueue<Runnable>();
        this.myBackendExecutor = backendExecutor;
        if (maxSimultaneousTasks < 1) {
            throw new IllegalArgumentException("maxSimultaneousTasks must be >=1 but got: " + maxSimultaneousTasks);
        }
        if (backendExecutor instanceof BoundedTaskExecutor) {
            throw new IllegalArgumentException("backendExecutor is already BoundedTaskExecutor: " + backendExecutor);
        }
        this.myMaxTasks = maxSimultaneousTasks;
    }

    public BoundedTaskExecutor(@NotNull Executor backendExecutor, int maxSimultaneousTasks, @NotNull Disposable parent2) {
        if (backendExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backendExecutor", "org/jetbrains/kotlin/com/intellij/util/concurrency/BoundedTaskExecutor", "<init>"));
        }
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/com/intellij/util/concurrency/BoundedTaskExecutor", "<init>"));
        }
        this(backendExecutor, maxSimultaneousTasks);
        Disposer.register(parent2, new Disposable(){

            @Override
            public void dispose() {
                BoundedTaskExecutor.this.shutdownNow();
            }
        });
    }

    static Object info(Object task) {
        if (task instanceof FutureTask) {
            task = ObjectUtils.chooseNotNull(ReflectionUtil.getField(task.getClass(), task, Callable.class, "callable"), task.getClass());
        }
        if (task instanceof Callable && task.getClass().getName().equals("java.util.concurrent.Executors$RunnableAdapter")) {
            task = ObjectUtils.chooseNotNull(ReflectionUtil.getField(task.getClass(), task, Runnable.class, "task"), task.getClass());
        }
        return task;
    }

    @Override
    public void shutdown() {
        if (this.myShutdown) {
            throw new IllegalStateException("Already shutdown");
        }
        this.myShutdown = true;
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        this.shutdown();
        List<Runnable> list2 = this.clearAndCancelAll();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/concurrency/BoundedTaskExecutor", "shutdownNow"));
        }
        return list2;
    }

    @Override
    public boolean isShutdown() {
        return this.myShutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.myShutdown;
    }

    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "org/jetbrains/kotlin/com/intellij/util/concurrency/BoundedTaskExecutor", "awaitTermination"));
        }
        if (!this.isShutdown()) {
            throw new IllegalStateException("you must call shutdown() first");
        }
        return true;
    }

    @Override
    public void execute(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/util/concurrency/BoundedTaskExecutor", "execute"));
        }
        if (this.isShutdown()) {
            throw new RejectedExecutionException("Already shutdown");
        }
        long status2 = this.incrementCounterAndTimestamp();
        if (this.tryToExecute(status2, task)) {
            return;
        }
        if (!this.myTaskQueue.offer(task)) {
            throw new RejectedExecutionException();
        }
        this.pollAndExecute(status2);
    }

    private long incrementCounterAndTimestamp() {
        long newStatus;
        long status2;
        while (!this.myStatus.compareAndSet(status2 = this.myStatus.get(), newStatus = status2 + 1L + 0x100000000L & Long.MAX_VALUE)) {
        }
        return newStatus;
    }

    private void pollAndExecute(long status2) {
        while (true) {
            Runnable next;
            int inProgress = (int)status2;
            if (!$assertionsDisabled && inProgress <= 0) {
                throw new AssertionError(inProgress);
            }
            if (inProgress <= this.myMaxTasks && (next = (Runnable)this.myTaskQueue.poll()) != null) {
                this.tryToExecute(status2, next);
                break;
            }
            if (this.myStatus.compareAndSet(status2, status2 - 1L)) break;
            status2 = this.myStatus.get();
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean tryToExecute(long status2, @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/util/concurrency/BoundedTaskExecutor", "tryToExecute"));
        }
        int inProgress = (int)status2;
        if (!$assertionsDisabled && inProgress <= 0) {
            throw new AssertionError(inProgress);
        }
        if (inProgress <= this.myMaxTasks) {
            try {
                void task;
                this.myBackendExecutor.execute(this.wrap((Runnable)task));
            }
            catch (Error e) {
                this.myStatus.decrementAndGet();
                throw e;
            }
            catch (RuntimeException e) {
                this.myStatus.decrementAndGet();
                throw e;
            }
            return true;
        }
        return false;
    }

    @NotNull
    private Runnable wrap(final @NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/util/concurrency/BoundedTaskExecutor", "wrap"));
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    task.run();
                }
                finally {
                    BoundedTaskExecutor.this.pollAndExecute(BoundedTaskExecutor.this.myStatus.get());
                }
            }

            public String toString() {
                return String.valueOf(BoundedTaskExecutor.info(task));
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/concurrency/BoundedTaskExecutor", "wrap"));
        }
        return runnable;
    }

    @NotNull
    public List<Runnable> clearAndCancelAll() {
        ArrayList<Runnable> queued = new ArrayList<Runnable>();
        this.myTaskQueue.drainTo(queued);
        for (Runnable task : queued) {
            if (!(task instanceof FutureTask)) continue;
            ((FutureTask)task).cancel(false);
        }
        ArrayList<Runnable> arrayList = queued;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/concurrency/BoundedTaskExecutor", "clearAndCancelAll"));
        }
        return arrayList;
    }

    public String toString() {
        return "BoundedExecutor(" + this.myMaxTasks + ") " + (this.isShutdown() ? "SHUTDOWN " : "") + "inProgress: " + (int)this.myStatus.get() + "; " + this.myTaskQueue.size() + " tasks in queue: [" + ContainerUtil.map(this.myTaskQueue, new Function<Runnable, Object>(){

            @Override
            public Object fun(Runnable runnable) {
                return BoundedTaskExecutor.info(runnable);
            }
        }) + "]";
    }

    static {
        boolean bl = $assertionsDisabled = !BoundedTaskExecutor.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Patches.USE_REFLECTION_TO_ACCESS_JDK8) {
            throw new AssertionError();
        }
    }
}

