/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentRefValueHashMap;

public final class ConcurrentSoftValueHashMap<K, V>
extends ConcurrentRefValueHashMap<K, V> {
    @Override
    @NotNull
    protected ConcurrentRefValueHashMap.ValueReference<K, V> createValueReference(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentSoftValueHashMap", "createValueReference"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentSoftValueHashMap", "createValueReference"));
        }
        MySoftReference mySoftReference = new MySoftReference(key, value, this.myQueue);
        if (mySoftReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentSoftValueHashMap", "createValueReference"));
        }
        return mySoftReference;
    }

    private static class MySoftReference<K, V>
    extends SoftReference<V>
    implements ConcurrentRefValueHashMap.ValueReference<K, V> {
        private final K key;

        private MySoftReference(@NotNull K key, @NotNull V referent, @NotNull ReferenceQueue<V> q) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentSoftValueHashMap$MySoftReference", "<init>"));
            }
            if (referent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referent", "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentSoftValueHashMap$MySoftReference", "<init>"));
            }
            if (q == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "q", "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentSoftValueHashMap$MySoftReference", "<init>"));
            }
            super(referent, q);
            this.key = key;
        }

        @Override
        @NotNull
        public K getKey() {
            K k = this.key;
            if (k == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentSoftValueHashMap$MySoftReference", "getKey"));
            }
            return k;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConcurrentRefValueHashMap.ValueReference that = (ConcurrentRefValueHashMap.ValueReference)o;
            Object v = this.get();
            Object thatV = that.get();
            return this.key.equals(that.getKey()) && v != null && thatV != null && v.equals(thatV);
        }
    }
}

