/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.containers.ComparatorUtil;
import org.jetbrains.kotlin.com.sampullara.cli.Argument;

public class ArgumentUtils {
    private ArgumentUtils() {
    }

    @NotNull
    public static List<String> convertArgumentsToStringList(@NotNull CommonCompilerArguments arguments) throws InstantiationException, IllegalAccessException {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/compilerRunner/ArgumentUtils", "convertArgumentsToStringList"));
        }
        ArrayList<String> result2 = new ArrayList<String>();
        ArgumentUtils.convertArgumentsToStringList(arguments, (CommonCompilerArguments)arguments.getClass().newInstance(), arguments.getClass(), result2);
        result2.addAll(arguments.freeArgs);
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/compilerRunner/ArgumentUtils", "convertArgumentsToStringList"));
        }
        return arrayList;
    }

    private static void convertArgumentsToStringList(@NotNull CommonCompilerArguments arguments, @NotNull CommonCompilerArguments defaultArguments, @NotNull Class<?> clazz, @NotNull List<String> result2) throws IllegalAccessException, InstantiationException {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/compilerRunner/ArgumentUtils", "convertArgumentsToStringList"));
        }
        if (defaultArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultArguments", "org/jetbrains/kotlin/compilerRunner/ArgumentUtils", "convertArgumentsToStringList"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/kotlin/compilerRunner/ArgumentUtils", "convertArgumentsToStringList"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/compilerRunner/ArgumentUtils", "convertArgumentsToStringList"));
        }
        for (Field field : clazz.getDeclaredFields()) {
            Class<?> fieldType;
            Object defaultValue;
            Object value;
            Argument argument = field.getAnnotation(Argument.class);
            if (argument == null) continue;
            try {
                value = field.get(arguments);
                defaultValue = field.get(defaultArguments);
            }
            catch (IllegalAccessException ignored) {
                continue;
            }
            if (ComparatorUtil.equalsNullable(value, defaultValue)) continue;
            String name = ArgumentUtils.getAlias(argument);
            if (name == null) {
                name = ArgumentUtils.getName(argument, field);
            }
            if ((fieldType = field.getType()).isArray()) {
                Object[] values = (Object[])value;
                if (values.length == 0) continue;
                value = StringUtil.join(values, Function.TO_STRING, argument.delimiter());
            }
            result2.add(argument.prefix() + name);
            if (fieldType == Boolean.TYPE || fieldType == Boolean.class) continue;
            result2.add(value.toString());
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            ArgumentUtils.convertArgumentsToStringList(arguments, defaultArguments, superClazz, result2);
        }
    }

    private static String getAlias(Argument argument) {
        String alias = argument.alias();
        return alias.isEmpty() ? null : alias;
    }

    private static String getName(Argument argument, Field field) {
        String name = argument.value();
        return name.isEmpty() ? field.getName() : name;
    }
}

