/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.collections.CharIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeatureSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.SimpleDeclarationChecker;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/UnderscoreChecker;", "Lorg/jetbrains/kotlin/resolve/SimpleDeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "checkIdentifier", "identifier", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "checkNamed", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "kotlin-compiler"})
public final class UnderscoreChecker
implements SimpleDeclarationChecker {
    public static final UnderscoreChecker INSTANCE;

    public final void checkIdentifier(@Nullable PsiElement identifier, @NotNull DiagnosticSink diagnosticHolder) {
        boolean bl;
        block5: {
            block7: {
                block6: {
                    Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
                    if (identifier == null) break block6;
                    CharSequence charSequence = identifier.getText();
                    if (!(charSequence.length() == 0)) break block7;
                }
                return;
            }
            CharSequence $receiver$iv = identifier.getText();
            CharIterator charIterator = StringsKt.iterator($receiver$iv);
            while (charIterator.hasNext()) {
                char element$iv = charIterator.nextChar();
                char it = element$iv;
                if (it == '_') continue;
                bl = false;
                break block5;
            }
            bl = true;
        }
        if (bl) {
            diagnosticHolder.report(Errors.UNDERSCORE_IS_RESERVED.on(identifier));
        }
    }

    public final void checkNamed(@NotNull KtNamedDeclaration declaration, @NotNull DiagnosticSink diagnosticHolder) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        this.checkIdentifier(declaration.getNameIdentifier(), diagnosticHolder);
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        if (declaration instanceof KtProperty && !(descriptor2 instanceof VariableDescriptor)) {
            return;
        }
        if (declaration instanceof KtCallableDeclaration) {
            for (KtParameter parameter : ((KtCallableDeclaration)declaration).getValueParameters()) {
                KtNamedDeclaration ktNamedDeclaration = parameter;
                Intrinsics.checkExpressionValueIsNotNull(ktNamedDeclaration, "parameter");
                this.checkNamed(ktNamedDeclaration, diagnosticHolder);
            }
        }
        if (declaration instanceof KtTypeParameterListOwner) {
            for (KtTypeParameter typeParameter : ((KtTypeParameterListOwner)declaration).getTypeParameters()) {
                KtNamedDeclaration ktNamedDeclaration = typeParameter;
                Intrinsics.checkExpressionValueIsNotNull(ktNamedDeclaration, "typeParameter");
                this.checkNamed(ktNamedDeclaration, diagnosticHolder);
            }
        }
        if (!(declaration instanceof KtNamedDeclaration)) {
            return;
        }
        this.checkNamed((KtNamedDeclaration)declaration, diagnosticHolder);
    }

    private UnderscoreChecker() {
        INSTANCE = this;
    }

    static {
        new UnderscoreChecker();
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext, @NotNull LanguageFeatureSettings languageFeatureSettings) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(languageFeatureSettings, "languageFeatureSettings");
        SimpleDeclarationChecker.DefaultImpls.check(this, declaration, descriptor2, diagnosticHolder, bindingContext, languageFeatureSettings);
    }
}

