/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.expressions.CaptureKind;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CapturingInClosureChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkCapturingInClosure", "variable", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "isCapturedInInline", "", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "scopeContainer", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "variableParent", "isCapturedVariable", "kotlin-compiler"})
public final class CapturingInClosureChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        VariableDescriptor variableDescriptor;
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        ResolvedCall<?> variableResolvedCall = resolvedCall2 instanceof VariableAsFunctionResolvedCall ? ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall() : resolvedCall2;
        Object obj = variableResolvedCall.getResultingDescriptor();
        if (!(obj instanceof VariableDescriptor)) {
            obj = null;
        }
        if ((variableDescriptor = (VariableDescriptor)obj) != null) {
            this.checkCapturingInClosure(variableDescriptor, context.getTrace(), context.getScope());
        }
    }

    private final void checkCapturingInClosure(VariableDescriptor variable, BindingTrace trace, LexicalScope scope) {
        DeclarationDescriptor variableParent = variable.getContainingDeclaration();
        DeclarationDescriptor scopeContainer = scope.getOwnerDescriptor();
        DeclarationDescriptor declarationDescriptor = variableParent;
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "variableParent");
        if (this.isCapturedVariable(declarationDescriptor, scopeContainer) && Intrinsics.areEqual((Object)((CaptureKind)((Object)trace.get(BindingContext.CAPTURED_IN_CLOSURE, variable))), (Object)CaptureKind.NOT_INLINE) ^ true) {
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
            DeclarationDescriptor declarationDescriptor2 = variableParent;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor2, "variableParent");
            boolean inline = this.isCapturedInInline(bindingContext, scopeContainer, declarationDescriptor2);
            trace.record(BindingContext.CAPTURED_IN_CLOSURE, variable, inline ? CaptureKind.INLINE_ONLY : CaptureKind.NOT_INLINE);
        }
    }

    private final boolean isCapturedVariable(DeclarationDescriptor variableParent, DeclarationDescriptor scopeContainer) {
        if (!(variableParent instanceof FunctionDescriptor) || Intrinsics.areEqual(scopeContainer, variableParent)) {
            return false;
        }
        if (variableParent instanceof ConstructorDescriptor) {
            ClassDescriptor classDescriptor = ((ConstructorDescriptor)variableParent).getContainingDeclaration();
            if (Intrinsics.areEqual(scopeContainer, classDescriptor)) {
                return false;
            }
            if (scopeContainer instanceof PropertyDescriptor && Intrinsics.areEqual(((PropertyDescriptor)scopeContainer).getContainingDeclaration(), classDescriptor)) {
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCapturedInInline(BindingContext context, DeclarationDescriptor scopeContainer, DeclarationDescriptor variableParent) {
        DeclarationDescriptor scopeContainerParent;
        PsiElement scopeDeclaration = DescriptorToSourceUtils.descriptorToDeclaration(scopeContainer);
        if (!InlineUtil.canBeInlineArgument(scopeDeclaration)) {
            return false;
        }
        PsiElement psiElement = scopeDeclaration;
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
        }
        if (!InlineUtil.isInlinedArgument((KtFunction)psiElement, context, false)) return false;
        DeclarationDescriptor declarationDescriptor = scopeContainer.getContainingDeclaration();
        if (declarationDescriptor == null) {
            String string = "parent is null for " + scopeContainer;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        DeclarationDescriptor declarationDescriptor2 = scopeContainerParent = declarationDescriptor;
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor2, "scopeContainerParent");
        if (!this.isCapturedVariable(variableParent, declarationDescriptor2)) return true;
        DeclarationDescriptor declarationDescriptor3 = scopeContainerParent;
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor3, "scopeContainerParent");
        if (!this.isCapturedInInline(context, declarationDescriptor3, variableParent)) return false;
        return true;
    }
}

