/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastUtilKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.synthetic.SamAdapterExtensionFunctionDescriptor;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/ProtectedSyntheticExtensionCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "kotlin-compiler"})
public final class ProtectedSyntheticExtensionCallChecker
implements CallChecker {
    public static final ProtectedSyntheticExtensionCallChecker INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        boolean bl;
        DeclarationDescriptor from;
        Object descriptor2;
        block9: {
            void $receiver$iv;
            FunctionDescriptor functionDescriptor;
            Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
            Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
            Intrinsics.checkParameterIsNotNull(context, "context");
            Object obj = descriptor2 = resolvedCall2.getResultingDescriptor();
            if (obj instanceof SyntheticJavaPropertyDescriptor) {
                functionDescriptor = ((SyntheticJavaPropertyDescriptor)descriptor2).getGetMethod();
            } else if (obj instanceof SamAdapterExtensionFunctionDescriptor) {
                functionDescriptor = ((SamAdapterExtensionFunctionDescriptor)descriptor2).getBaseDescriptorForSynthetic();
            } else {
                return;
            }
            FunctionDescriptor sourceFunction = functionDescriptor;
            from = context.getScope().getOwnerDescriptor();
            if (!Visibilities.isVisibleIgnoringReceiver((DeclarationDescriptorWithVisibility)descriptor2, from)) {
                return;
            }
            if (resolvedCall2.getDispatchReceiver() != null && !(resolvedCall2.getExtensionReceiver() instanceof ReceiverValue)) {
                return;
            }
            ReceiverValue receiverValue = resolvedCall2.getExtensionReceiver();
            if (receiverValue == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue");
            }
            ReceiverValue receiverValue2 = receiverValue;
            Collection collection = CollectionsKt.listOf(receiverValue2.getType());
            DataFlowInfo dataFlowInfo = context.getDataFlowInfo();
            BindingContext bindingContext = context.getTrace().getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "context.trace.bindingContext");
            List receiverTypes = CollectionsKt.plus(collection, (Iterable)dataFlowInfo.getStableTypes(DataFlowValueFactory.createDataFlowValue(receiverValue2, bindingContext, context.getScope().getOwnerDescriptor())));
            Iterable iterable = receiverTypes;
            for (Object element$iv : $receiver$iv) {
                KotlinType it = (KotlinType)element$iv;
                if (!Visibilities.isVisible(SmartCastUtilKt.getReceiverValueWithSmartCast(null, it), sourceFunction, from)) continue;
                bl = false;
                break block9;
            }
            bl = true;
        }
        if (bl) {
            context.getTrace().report(Errors.INVISIBLE_MEMBER.on(reportOn, (DeclarationDescriptor)descriptor2, descriptor2.getVisibility(), from));
        }
    }

    private ProtectedSyntheticExtensionCallChecker() {
        INSTANCE = this;
    }

    static {
        new ProtectedSyntheticExtensionCallChecker();
    }
}

