/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.java.DefaultJavaSourceSet;
import org.gradle.api.internal.java.DefaultJvmResourceSet;
import org.gradle.api.internal.jvm.ClassDirectoryBinarySpecInternal;
import org.gradle.api.internal.jvm.DefaultClassDirectoryBinarySpec;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.tasks.SourceSetCompileClasspath;
import org.gradle.api.internal.tasks.testing.NoMatchingTestsReporter;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestListener;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.jvm.platform.internal.DefaultJavaPlatform;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.plugins.LanguageBasePlugin;
import org.gradle.language.jvm.JvmResourceSet;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRegistrations;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.DefaultComponentSpecIdentifier;
import org.gradle.platform.base.plugins.BinaryBasePlugin;
import org.gradle.util.WrapUtil;

public class JavaBasePlugin
implements Plugin<ProjectInternal> {
    public static final String CHECK_TASK_NAME = "check";
    public static final String VERIFICATION_GROUP = "verification";
    public static final String BUILD_TASK_NAME = "build";
    public static final String BUILD_DEPENDENTS_TASK_NAME = "buildDependents";
    public static final String BUILD_NEEDED_TASK_NAME = "buildNeeded";
    public static final String DOCUMENTATION_GROUP = "documentation";
    private final Instantiator instantiator;
    private final JavaToolChain javaToolChain;
    private final ITaskFactory taskFactory;
    private final ModelRegistry modelRegistry;

    @Inject
    public JavaBasePlugin(Instantiator instantiator, JavaToolChain javaToolChain, ITaskFactory taskFactory, ModelRegistry modelRegistry) {
        this.instantiator = instantiator;
        this.javaToolChain = javaToolChain;
        this.taskFactory = taskFactory;
        this.modelRegistry = modelRegistry;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(BasePlugin.class);
        project.getPluginManager().apply(ReportingBasePlugin.class);
        project.getPluginManager().apply(LanguageBasePlugin.class);
        project.getPluginManager().apply(BinaryBasePlugin.class);
        JavaPluginConvention javaConvention = new JavaPluginConvention(project, this.instantiator);
        project.getConvention().getPlugins().put("java", javaConvention);
        this.configureCompileDefaults((Project)project, javaConvention);
        BridgedBinaries binaries = this.configureSourceSetDefaults(javaConvention);
        this.modelRegistry.register(ModelRegistrations.bridgedInstance((ModelReference)ModelReference.of((String)"bridgedBinaries", BridgedBinaries.class), (Object)binaries).descriptor("JavaBasePlugin.apply()").hidden(true).build());
        this.configureJavaDoc((Project)project, javaConvention);
        this.configureTest((Project)project, javaConvention);
        this.configureBuildNeeded((Project)project);
        this.configureBuildDependents((Project)project);
    }

    private BridgedBinaries configureSourceSetDefaults(JavaPluginConvention pluginConvention) {
        ProjectInternal project = pluginConvention.getProject();
        ArrayList binaries = Lists.newArrayList();
        pluginConvention.getSourceSets().all((Action)new Action<SourceSet>((Project)project, (List)binaries){
            final /* synthetic */ Project val$project;
            final /* synthetic */ List val$binaries;
            {
                this.val$project = project;
                this.val$binaries = list;
            }

            public void execute(SourceSet sourceSet) {
                ConventionMapping outputConventionMapping = ((IConventionAware)sourceSet.getOutput()).getConventionMapping();
                ConfigurationContainer configurations = this.val$project.getConfigurations();
                JavaBasePlugin.this.defineConfigurationsForSourceSet(sourceSet, configurations);
                JavaBasePlugin.this.definePathsForSourceSet(sourceSet, outputConventionMapping, this.val$project);
                JavaBasePlugin.this.createProcessResourcesTaskForBinary(sourceSet, sourceSet.getResources(), this.val$project);
                JavaBasePlugin.this.createCompileJavaTaskForBinary(sourceSet, sourceSet.getJava(), this.val$project);
                JavaBasePlugin.this.createBinaryLifecycleTask(sourceSet, this.val$project);
                DefaultComponentSpecIdentifier binaryId = new DefaultComponentSpecIdentifier(this.val$project.getPath(), sourceSet.getName());
                ClassDirectoryBinarySpecInternal binary = (ClassDirectoryBinarySpecInternal)JavaBasePlugin.this.instantiator.newInstance(DefaultClassDirectoryBinarySpec.class, new Object[]{binaryId, sourceSet, JavaBasePlugin.this.javaToolChain, DefaultJavaPlatform.current(), JavaBasePlugin.this.instantiator, JavaBasePlugin.this.taskFactory});
                SourceSetCompileClasspath compileClasspath = new SourceSetCompileClasspath(sourceSet);
                DefaultJavaSourceSet javaSourceSet = (DefaultJavaSourceSet)((Object)JavaBasePlugin.this.instantiator.newInstance(DefaultJavaSourceSet.class, new Object[]{binaryId.child("java"), sourceSet.getJava(), compileClasspath}));
                JvmResourceSet resourceSet = (JvmResourceSet)JavaBasePlugin.this.instantiator.newInstance(DefaultJvmResourceSet.class, new Object[]{binaryId.child("resources"), sourceSet.getResources()});
                binary.addSourceSet((LanguageSourceSet)javaSourceSet);
                binary.addSourceSet((LanguageSourceSet)resourceSet);
                JavaBasePlugin.this.attachTasksToBinary(binary, sourceSet, this.val$project);
                this.val$binaries.add(binary);
            }
        });
        return new BridgedBinaries(binaries);
    }

    private void createCompileJavaTaskForBinary(final SourceSet sourceSet, SourceDirectorySet javaSourceSet, Project target) {
        JavaCompile compileTask = (JavaCompile)target.getTasks().create(sourceSet.getCompileJavaTaskName(), JavaCompile.class);
        compileTask.setDescription("Compiles " + javaSourceSet + ".");
        compileTask.setSource((Object)javaSourceSet);
        ConventionMapping conventionMapping = compileTask.getConventionMapping();
        conventionMapping.map("classpath", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return sourceSet.getCompileClasspath();
            }
        });
        conventionMapping.map("destinationDir", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return sourceSet.getOutput().getClassesDir();
            }
        });
    }

    private void createProcessResourcesTaskForBinary(final SourceSet sourceSet, SourceDirectorySet resourceSet, Project target) {
        Copy resourcesTask = (Copy)target.getTasks().create(sourceSet.getProcessResourcesTaskName(), ProcessResources.class);
        resourcesTask.setDescription("Processes " + resourceSet + ".");
        new DslObject((Object)resourcesTask).getConventionMapping().map("destinationDir", (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return sourceSet.getOutput().getResourcesDir();
            }
        });
        resourcesTask.from(new Object[]{resourceSet});
    }

    private void createBinaryLifecycleTask(SourceSet sourceSet, Project target) {
        sourceSet.compiledBy(sourceSet.getClassesTaskName());
        Task binaryLifecycleTask = target.task(sourceSet.getClassesTaskName());
        binaryLifecycleTask.setGroup(BUILD_TASK_NAME);
        binaryLifecycleTask.setDescription("Assembles " + sourceSet.getOutput() + ".");
        binaryLifecycleTask.dependsOn(new Object[]{sourceSet.getOutput().getDirs()});
        binaryLifecycleTask.dependsOn(new Object[]{sourceSet.getCompileJavaTaskName()});
        binaryLifecycleTask.dependsOn(new Object[]{sourceSet.getProcessResourcesTaskName()});
    }

    private void attachTasksToBinary(ClassDirectoryBinarySpecInternal binary, SourceSet sourceSet, Project target) {
        Task compileTask = target.getTasks().getByPath(sourceSet.getCompileJavaTaskName());
        Task resourcesTask = target.getTasks().getByPath(sourceSet.getProcessResourcesTaskName());
        Task classesTask = target.getTasks().getByPath(sourceSet.getClassesTaskName());
        binary.getTasks().add((Object)compileTask);
        binary.getTasks().add((Object)resourcesTask);
        binary.getTasks().add((Object)classesTask);
        binary.setBuildTask(classesTask);
    }

    private void definePathsForSourceSet(final SourceSet sourceSet, ConventionMapping outputConventionMapping, final Project project) {
        outputConventionMapping.map("classesDir", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                String classesDirName = "classes/" + sourceSet.getName();
                return new File(project.getBuildDir(), classesDirName);
            }
        });
        outputConventionMapping.map("resourcesDir", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                String classesDirName = "resources/" + sourceSet.getName();
                return new File(project.getBuildDir(), classesDirName);
            }
        });
        sourceSet.getJava().srcDir((Object)("src/" + sourceSet.getName() + "/java"));
        sourceSet.getResources().srcDir((Object)("src/" + sourceSet.getName() + "/resources"));
    }

    private void defineConfigurationsForSourceSet(SourceSet sourceSet, ConfigurationContainer configurations) {
        Configuration compileConfiguration = (Configuration)configurations.maybeCreate(sourceSet.getCompileConfigurationName());
        compileConfiguration.setVisible(false);
        compileConfiguration.setDescription("Dependencies for " + sourceSet + ".");
        Configuration runtimeConfiguration = (Configuration)configurations.maybeCreate(sourceSet.getRuntimeConfigurationName());
        runtimeConfiguration.setVisible(false);
        runtimeConfiguration.extendsFrom(new Configuration[]{compileConfiguration});
        runtimeConfiguration.setDescription("Runtime dependencies for " + sourceSet + ".");
        Configuration compileOnlyConfiguration = (Configuration)configurations.maybeCreate(sourceSet.getCompileOnlyConfigurationName());
        compileOnlyConfiguration.setVisible(false);
        compileOnlyConfiguration.extendsFrom(new Configuration[]{compileConfiguration});
        compileOnlyConfiguration.setDescription("Compile dependencies for " + sourceSet + ".");
        Configuration compileClasspathConfiguration = (Configuration)configurations.maybeCreate(sourceSet.getCompileClasspathConfigurationName());
        compileClasspathConfiguration.setVisible(false);
        compileClasspathConfiguration.extendsFrom(new Configuration[]{compileOnlyConfiguration});
        compileClasspathConfiguration.setDescription("Compile classpath for " + sourceSet + ".");
        sourceSet.setCompileClasspath((FileCollection)compileClasspathConfiguration);
        sourceSet.setRuntimeClasspath(sourceSet.getOutput().plus((FileCollection)runtimeConfiguration));
    }

    public void configureForSourceSet(final SourceSet sourceSet, AbstractCompile compile) {
        compile.setDescription("Compiles the " + sourceSet.getJava() + ".");
        ConventionMapping conventionMapping = compile.getConventionMapping();
        compile.setSource((Object)sourceSet.getJava());
        conventionMapping.map("classpath", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return sourceSet.getCompileClasspath();
            }
        });
        conventionMapping.map("destinationDir", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return sourceSet.getOutput().getClassesDir();
            }
        });
    }

    private void configureCompileDefaults(Project project, final JavaPluginConvention javaConvention) {
        project.getTasks().withType(AbstractCompile.class, (Action)new Action<AbstractCompile>(){

            public void execute(AbstractCompile compile) {
                ConventionMapping conventionMapping = compile.getConventionMapping();
                conventionMapping.map("sourceCompatibility", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return javaConvention.getSourceCompatibility().toString();
                    }
                });
                conventionMapping.map("targetCompatibility", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return javaConvention.getTargetCompatibility().toString();
                    }
                });
            }
        });
        project.getTasks().withType(JavaCompile.class, (Action)new Action<JavaCompile>(){

            public void execute(JavaCompile compile) {
                ConventionMapping conventionMapping = compile.getConventionMapping();
                conventionMapping.map("dependencyCacheDir", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return javaConvention.getDependencyCacheDir();
                    }
                });
            }
        });
    }

    private void configureJavaDoc(final Project project, final JavaPluginConvention convention) {
        project.getTasks().withType(Javadoc.class, (Action)new Action<Javadoc>(){

            public void execute(Javadoc javadoc) {
                javadoc.getConventionMapping().map("destinationDir", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return new File(convention.getDocsDir(), "javadoc");
                    }
                });
                javadoc.getConventionMapping().map("title", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ((ReportingExtension)project.getExtensions().getByType(ReportingExtension.class)).getApiDocTitle();
                    }
                });
            }
        });
    }

    private void configureBuildNeeded(Project project) {
        DefaultTask buildTask = (DefaultTask)project.getTasks().create(BUILD_NEEDED_TASK_NAME, DefaultTask.class);
        buildTask.setDescription("Assembles and tests this project and all projects it depends on.");
        buildTask.setGroup(BUILD_TASK_NAME);
        buildTask.dependsOn(new Object[]{BUILD_TASK_NAME});
    }

    private void configureBuildDependents(Project project) {
        DefaultTask buildTask = (DefaultTask)project.getTasks().create(BUILD_DEPENDENTS_TASK_NAME, DefaultTask.class);
        buildTask.setDescription("Assembles and tests this project and all projects that depend on it.");
        buildTask.setGroup(BUILD_TASK_NAME);
        buildTask.dependsOn(new Object[]{BUILD_TASK_NAME});
    }

    private void configureTest(final Project project, final JavaPluginConvention convention) {
        project.getTasks().withType(Test.class, (Action)new Action<Test>(){

            public void execute(Test test) {
                JavaBasePlugin.this.configureTestDefaults(test, project, convention);
            }
        });
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                project.getTasks().withType(Test.class, (Action)new Action<Test>(){

                    public void execute(Test test) {
                        JavaBasePlugin.this.configureBasedOnSingleProperty(test);
                        JavaBasePlugin.this.overwriteDebugIfDebugPropertyIsSet(test);
                    }
                });
            }
        });
    }

    private void overwriteDebugIfDebugPropertyIsSet(Test test) {
        String debugProp = this.getTaskPrefixedProperty((Task)test, "debug");
        if (debugProp != null) {
            test.prependParallelSafeAction((Action)new Action<Task>(){

                public void execute(Task task) {
                    task.getLogger().info("Running tests for remote debugging.");
                }
            });
            test.setDebug(true);
        }
    }

    private void configureBasedOnSingleProperty(final Test test) {
        String singleTest = this.getTaskPrefixedProperty((Task)test, "single");
        if (singleTest == null) {
            test.getInputs().files(new Object[]{test.getCandidateClassFiles()}).withPropertyName("test.candidateClassFiles").skipWhenEmpty();
            return;
        }
        test.prependParallelSafeAction((Action)new Action<Task>(){

            public void execute(Task task) {
                test.getLogger().info("Running single tests with pattern: {}", (Object)test.getIncludes());
            }
        });
        test.setIncludes((Iterable)WrapUtil.toSet((Object[])new String[]{"**/" + singleTest + "*.class"}));
        test.addTestListener((TestListener)new NoMatchingTestsReporter("Could not find matching test for pattern: " + singleTest));
    }

    private String getTaskPrefixedProperty(Task task, String propertyName) {
        String suffix = '.' + propertyName;
        String value = System.getProperty(task.getPath() + suffix);
        if (value == null) {
            return System.getProperty(task.getName() + suffix);
        }
        return value;
    }

    private void configureTestDefaults(final Test test, Project project, final JavaPluginConvention convention) {
        DslObject htmlReport = new DslObject((Object)test.getReports().getHtml());
        DslObject xmlReport = new DslObject((Object)test.getReports().getJunitXml());
        xmlReport.getConventionMapping().map("destination", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return new File(convention.getTestResultsDir(), test.getName());
            }
        });
        htmlReport.getConventionMapping().map("destination", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return new File(convention.getTestReportDir(), test.getName());
            }
        });
        test.getConventionMapping().map("binResultsDir", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return new File(convention.getTestResultsDir(), test.getName() + "/binary");
            }
        });
        test.workingDir((Object)project.getProjectDir());
    }

    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Mutate
        void attachBridgedSourceSets(ProjectSourceSet projectSourceSet, BridgedBinaries bridgedBinaries) {
            for (ClassDirectoryBinarySpecInternal binary : bridgedBinaries.binaries) {
                projectSourceSet.addAll((Collection)binary.getInputs());
            }
        }

        @Mutate
        void attachBridgedBinaries(BinaryContainer binaries, BridgedBinaries bridgedBinaries) {
            for (BinarySpecInternal binarySpecInternal : bridgedBinaries.binaries) {
                binaries.put(binarySpecInternal.getProjectScopedName(), (Object)binarySpecInternal);
            }
        }
    }

    static class BridgedBinaries {
        final List<ClassDirectoryBinarySpecInternal> binaries;

        public BridgedBinaries(List<ClassDirectoryBinarySpecInternal> binaries) {
            this.binaries = binaries;
        }
    }
}

