/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.foundation.ipc.gradle;

import java.net.Socket;
import java.util.ArrayList;
import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.foundation.ProjectConverter;
import org.gradle.foundation.ProjectView;
import org.gradle.foundation.ipc.basic.ClientProcess;
import org.gradle.foundation.ipc.basic.MessageObject;
import org.gradle.foundation.ipc.basic.Server;
import org.gradle.foundation.ipc.gradle.KillGradleServerProtocol;
import org.gradle.gradleplugin.foundation.GradlePluginLord;

public class TaskListClientProtocol
implements ClientProcess.Protocol {
    private final Logger logger = Logging.getLogger(TaskListClientProtocol.class);
    private ClientProcess client;
    private boolean continueConnection = true;
    private Gradle gradle;
    private Server localServer;

    public TaskListClientProtocol(Gradle gradle) {
        this.gradle = gradle;
    }

    public void initialize(ClientProcess client) {
        this.client = client;
        this.gradle.addListener((Object)new RefreshTaskListBuildListener(client));
    }

    public boolean serverConnected(Socket clientSocket) {
        MessageObject message = this.client.readMessage();
        if (message == null) {
            return false;
        }
        if (!"connected".equalsIgnoreCase(message.getMessageType())) {
            this.logger.error("Incorrect server handshaking.");
            return false;
        }
        this.localServer = new Server(new KillGradleServerProtocol());
        this.localServer.start();
        this.client.sendMessage("connected", "client-reply", Integer.valueOf(this.localServer.getPort()));
        return true;
    }

    public boolean continueConnection() {
        return this.continueConnection;
    }

    public void shutdown() {
        this.continueConnection = false;
    }

    private class RefreshTaskListBuildListener
    extends BuildAdapter
    implements StandardOutputListener {
        private ClientProcess client;
        private StringBuffer allOutputText = new StringBuffer();

        public RefreshTaskListBuildListener(ClientProcess client) {
            this.client = client;
        }

        public synchronized void onOutput(CharSequence output) {
            this.allOutputText.append(output);
        }

        public void buildFinished(BuildResult buildResult) {
            boolean wasSuccessful = buildResult.getFailure() == null;
            String output = this.allOutputText.toString();
            if (!wasSuccessful) {
                String details = GradlePluginLord.getGradleExceptionMessage(buildResult.getFailure(), TaskListClientProtocol.this.gradle.getStartParameter().getShowStacktrace());
                output = output + details;
                this.client.sendMessage("TaskListCompletedWithErrors", output, Boolean.valueOf(wasSuccessful));
            } else {
                ProjectConverter buildExecuter = new ProjectConverter();
                ArrayList<ProjectView> projects = new ArrayList<ProjectView>();
                projects.addAll(buildExecuter.convertProjects(buildResult.getGradle().getRootProject()));
                this.client.sendMessage("TaskListCompletedSuccessfully", output, projects);
            }
            this.client.sendMessage("exiting", null, null);
            this.client.stop();
        }
    }
}

