/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.codehaus.plexus.context;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.mvn3.org.codehaus.plexus.context.Context;
import org.gradle.mvn3.org.codehaus.plexus.context.ContextException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultContext
implements Context {
    private final ConcurrentMap<Object, Object> contextData = new ConcurrentHashMap<Object, Object>();
    private final AtomicBoolean readOnly = new AtomicBoolean(false);

    public DefaultContext() {
    }

    public DefaultContext(Map<Object, Object> contextData) {
        if (contextData == null) {
            throw new NullPointerException("contextData is null");
        }
        for (Map.Entry<Object, Object> entry : contextData.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null) {
                throw new IllegalArgumentException("Key is null");
            }
            if (value == null) continue;
            this.contextData.put(key, value);
        }
    }

    @Override
    public boolean contains(Object key) {
        Object data = this.contextData.get(key);
        return data != null;
    }

    @Override
    public Object get(Object key) throws ContextException {
        Object data = this.contextData.get(key);
        if (data == null) {
            throw new ContextException("Unable to resolve context key: " + key);
        }
        return data;
    }

    @Override
    public void put(Object key, Object value) throws IllegalStateException {
        this.checkWriteable();
        if (key == null) {
            throw new IllegalArgumentException("Key is null");
        }
        if (value == null) {
            this.contextData.remove(key);
        } else {
            this.contextData.put(key, value);
        }
    }

    @Override
    public void hide(Object key) throws IllegalStateException {
        this.checkWriteable();
        this.contextData.remove(key);
    }

    public Map getContextData() {
        return Collections.unmodifiableMap(this.contextData);
    }

    @Override
    public void makeReadOnly() {
        this.readOnly.set(true);
    }

    protected void checkWriteable() throws IllegalStateException {
        if (this.readOnly.get()) {
            throw new IllegalStateException("Context is read only and can not be modified");
        }
    }

    public String toString() {
        return this.contextData.toString();
    }
}

