/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.coffeescript.compile.internal.rhino;

import org.gradle.api.Action;
import org.gradle.api.internal.file.RelativeFile;
import org.gradle.plugins.javascript.coffeescript.compile.internal.CoffeeScriptCompileDestinationCalculator;
import org.gradle.plugins.javascript.coffeescript.compile.internal.SerializableCoffeeScriptCompileSpec;
import org.gradle.plugins.javascript.rhino.worker.RhinoWorker;
import org.gradle.plugins.javascript.rhino.worker.RhinoWorkerUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoffeeScriptCompilerWorker
implements RhinoWorker<Boolean, SerializableCoffeeScriptCompileSpec> {
    @Override
    public Boolean process(SerializableCoffeeScriptCompileSpec spec) {
        Scriptable coffeeScriptScope = RhinoWorkerUtils.parse(spec.getCoffeeScriptJs(), "UTF-8", new Action<Context>(){

            public void execute(Context context) {
                context.setOptimizationLevel(-1);
            }
        });
        String encoding = spec.getOptions().getEncoding();
        CoffeeScriptCompileDestinationCalculator destinationCalculator = new CoffeeScriptCompileDestinationCalculator(spec.getDestinationDir());
        for (RelativeFile target : spec.getSource()) {
            String source = RhinoWorkerUtils.readFile(target.getFile(), encoding);
            String output = this.compile(coffeeScriptScope, source, target.getRelativePath().getPathString());
            RhinoWorkerUtils.writeFile(output, destinationCalculator.transform(target.getRelativePath()), encoding);
        }
        return Boolean.TRUE;
    }

    @Override
    public Exception convertException(RhinoException rhinoException) {
        return rhinoException;
    }

    private String compile(Scriptable rootScope, final String source, final String sourceName) {
        return RhinoWorkerUtils.childScope(rootScope, new RhinoWorkerUtils.DefaultScopeOperation<String>(){

            @Override
            public String action(Scriptable compileScope, Context context) {
                compileScope.put("coffeeScriptSource", compileScope, (Object)source);
                return (String)context.evaluateString(compileScope, "CoffeeScript.compile(coffeeScriptSource, {});", sourceName, 0, null);
            }
        });
    }
}

