/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.internal.AbstractBuildableModelElement;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetContainer;
import org.gradle.language.nativeplatform.DependentSourceSet;
import org.gradle.nativeplatform.BuildType;
import org.gradle.nativeplatform.Flavor;
import org.gradle.nativeplatform.NativeBinaryTasks;
import org.gradle.nativeplatform.NativeComponentSpec;
import org.gradle.nativeplatform.NativeDependencySet;
import org.gradle.nativeplatform.NativeLibraryBinary;
import org.gradle.nativeplatform.Tool;
import org.gradle.nativeplatform.internal.DefaultNativeBinaryTasks;
import org.gradle.nativeplatform.internal.DefaultTool;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.internal.resolve.NativeBinaryResolveResult;
import org.gradle.nativeplatform.internal.resolve.NativeDependencyResolver;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.platform.base.internal.BinaryNamingScheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNativeBinarySpec
extends AbstractBuildableModelElement
implements NativeBinarySpecInternal {
    private final NativeComponentSpec component;
    private final LanguageSourceSetContainer sourceSets = new LanguageSourceSetContainer();
    private final Set<? super Object> libs = new LinkedHashSet<Object>();
    private final DefaultTool linker = new DefaultTool();
    private final DefaultTool staticLibArchiver = new DefaultTool();
    private final NativeBinaryTasks tasks = new DefaultNativeBinaryTasks(this);
    private final PlatformToolProvider toolProvider;
    private final BinaryNamingScheme namingScheme;
    private final Flavor flavor;
    private final NativeToolChain toolChain;
    private final NativePlatform targetPlatform;
    private final BuildType buildType;
    private final NativeDependencyResolver resolver;
    private boolean buildable;

    protected AbstractNativeBinarySpec(NativeComponentSpec owner, Flavor flavor, NativeToolChain toolChain, PlatformToolProvider toolProvider, NativePlatform targetPlatform, BuildType buildType, BinaryNamingScheme namingScheme, NativeDependencyResolver resolver) {
        this.component = owner;
        this.toolProvider = toolProvider;
        this.namingScheme = namingScheme;
        this.flavor = flavor;
        this.toolChain = toolChain;
        this.targetPlatform = targetPlatform;
        this.buildType = buildType;
        this.buildable = true;
        this.resolver = resolver;
        this.component.getSource().all((Action)new Action<LanguageSourceSet>(){

            public void execute(LanguageSourceSet sourceSet) {
                AbstractNativeBinarySpec.this.sourceSets.add((Object)sourceSet);
            }
        });
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return this.namingScheme.getDescription();
    }

    public String getName() {
        return this.namingScheme.getLifecycleTaskName();
    }

    @Override
    public NativeComponentSpec getComponent() {
        return this.component;
    }

    @Override
    public Flavor getFlavor() {
        return this.flavor;
    }

    @Override
    public NativeToolChain getToolChain() {
        return this.toolChain;
    }

    @Override
    public NativePlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    @Override
    public BuildType getBuildType() {
        return this.buildType;
    }

    public DomainObjectSet<LanguageSourceSet> getSource() {
        return this.sourceSets;
    }

    public void source(Object sources) {
        this.sourceSets.source(sources);
    }

    @Override
    public Tool getLinker() {
        return this.linker;
    }

    @Override
    public Tool getStaticLibArchiver() {
        return this.staticLibArchiver;
    }

    @Override
    public NativeBinaryTasks getTasks() {
        return this.tasks;
    }

    public NativeBinaryTasks getNativeBinaryTasks() {
        return this.getTasks();
    }

    public BinaryNamingScheme getNamingScheme() {
        return this.namingScheme;
    }

    @Override
    public Collection<NativeDependencySet> getLibs() {
        return this.resolve((Collection<? extends DependentSourceSet>)this.sourceSets.withType(DependentSourceSet.class)).getAllResults();
    }

    @Override
    public Collection<NativeDependencySet> getLibs(DependentSourceSet sourceSet) {
        return this.resolve(Collections.singleton(sourceSet)).getAllResults();
    }

    @Override
    public void lib(Object notation) {
        this.libs.add(notation);
    }

    @Override
    public Collection<NativeLibraryBinary> getDependentBinaries() {
        return this.resolve((Collection<? extends DependentSourceSet>)this.sourceSets.withType(DependentSourceSet.class)).getAllLibraryBinaries();
    }

    private NativeBinaryResolveResult resolve(Collection<? extends DependentSourceSet> sourceSets) {
        LinkedHashSet<? super Object> allLibs = new LinkedHashSet<Object>(this.libs);
        for (DependentSourceSet dependentSourceSet : sourceSets) {
            allLibs.addAll(dependentSourceSet.getLibs());
        }
        NativeBinaryResolveResult resolution = new NativeBinaryResolveResult(this, allLibs);
        this.resolver.resolve(resolution);
        return resolution;
    }

    @Override
    public PlatformToolProvider getPlatformToolProvider() {
        return this.toolProvider;
    }

    public boolean isBuildable() {
        return this.buildable;
    }

    @Override
    public void setBuildable(boolean buildable) {
        this.buildable = buildable;
    }

    public boolean isLegacyBinary() {
        return false;
    }
}

