/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal;

import java.util.HashSet;
import java.util.Set;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetContainer;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeComponentSpec;
import org.gradle.nativeplatform.ObjectFile;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentSpecIdentifier;
import org.gradle.platform.base.TransformationFileType;
import org.gradle.platform.base.internal.ComponentSpecInternal;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNativeComponentSpec
implements NativeComponentSpec,
ComponentSpecInternal {
    private final FunctionalSourceSet mainSourceSet;
    private final LanguageSourceSetContainer sourceSets = new LanguageSourceSetContainer();
    private final ComponentSpecIdentifier id;
    private final DomainObjectSet<BinarySpec> binaries;
    private final DomainObjectSet<NativeBinarySpec> nativeBinaries;
    private final Set<Class<? extends TransformationFileType>> inputTypes = new HashSet<Class<? extends TransformationFileType>>();
    private String baseName;

    public AbstractNativeComponentSpec(ComponentSpecIdentifier id, FunctionalSourceSet mainSourceSet) {
        this.mainSourceSet = mainSourceSet;
        this.sourceSets.addMainSources(mainSourceSet);
        this.id = id;
        this.binaries = new DefaultDomainObjectSet(NativeBinarySpec.class);
        this.nativeBinaries = this.binaries.withType(NativeBinarySpec.class);
        this.inputTypes.add(ObjectFile.class);
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getName() {
        return this.id.getName();
    }

    public String getProjectPath() {
        return this.id.getProjectPath();
    }

    public FunctionalSourceSet getMainSource() {
        return this.mainSourceSet;
    }

    public DomainObjectSet<LanguageSourceSet> getSource() {
        return this.sourceSets;
    }

    public void source(Object sources) {
        this.sourceSets.source(sources);
    }

    public DomainObjectSet<BinarySpec> getBinaries() {
        return this.binaries;
    }

    @Override
    public DomainObjectSet<NativeBinarySpec> getNativeBinaries() {
        return this.nativeBinaries;
    }

    @Override
    public String getBaseName() {
        return (String)GUtil.elvis((Object)this.baseName, (Object)this.getName());
    }

    @Override
    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    public Set<Class<? extends TransformationFileType>> getInputTypes() {
        return this.inputTypes;
    }
}

