/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Named;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.nativeplatform.BuildType;
import org.gradle.nativeplatform.Flavor;
import org.gradle.nativeplatform.internal.AbstractNativeComponentSpec;
import org.gradle.nativeplatform.internal.TargetedNativeComponentInternal;
import org.gradle.platform.base.ComponentSpecIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTargetedNativeComponentSpec
extends AbstractNativeComponentSpec
implements TargetedNativeComponentInternal {
    private final Set<String> targetPlatforms = new LinkedHashSet<String>();
    private final Set<String> buildTypes = new HashSet<String>();
    private final Set<String> flavors = new HashSet<String>();

    public AbstractTargetedNativeComponentSpec(ComponentSpecIdentifier id, FunctionalSourceSet sourceSet) {
        super(id, sourceSet);
    }

    public List<String> getTargetPlatforms() {
        return Lists.newArrayList(this.targetPlatforms);
    }

    @Override
    public void targetPlatforms(String ... platformSelectors) {
        this.targetPlatform(platformSelectors);
    }

    public void targetPlatform(String ... platformSelectors) {
        Collections.addAll(this.targetPlatforms, platformSelectors);
    }

    @Override
    public void targetFlavors(String ... flavorSelectors) {
        Collections.addAll(this.flavors, flavorSelectors);
    }

    @Override
    public void targetBuildTypes(String ... buildTypeSelectors) {
        Collections.addAll(this.buildTypes, buildTypeSelectors);
    }

    @Override
    public Set<Flavor> chooseFlavors(Set<? extends Flavor> candidates) {
        return this.chooseElements(Flavor.class, candidates, this.flavors);
    }

    @Override
    public Set<BuildType> chooseBuildTypes(Set<? extends BuildType> candidates) {
        return this.chooseElements(BuildType.class, candidates, this.buildTypes);
    }

    protected <T extends Named> Set<T> chooseElements(Class<T> type, Set<? extends T> candidates, Set<String> names) {
        if (names.isEmpty()) {
            return new LinkedHashSet<T>(candidates);
        }
        HashSet<String> unusedNames = new HashSet<String>(names);
        LinkedHashSet<Named> chosen = new LinkedHashSet<Named>();
        for (Named candidate : candidates) {
            if (!unusedNames.remove(candidate.getName())) continue;
            chosen.add(candidate);
        }
        if (!unusedNames.isEmpty()) {
            throw new InvalidUserDataException(String.format("Invalid %s: '%s'", type.getSimpleName(), unusedNames.iterator().next()));
        }
        return chosen;
    }
}

