/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.nativeplatform.NativeResourceSet;
import org.gradle.nativeplatform.BuildType;
import org.gradle.nativeplatform.Flavor;
import org.gradle.nativeplatform.NativeLibrarySpec;
import org.gradle.nativeplatform.SharedLibraryBinary;
import org.gradle.nativeplatform.internal.AbstractNativeLibraryBinarySpec;
import org.gradle.nativeplatform.internal.SharedLibraryBinarySpecInternal;
import org.gradle.nativeplatform.internal.resolve.NativeDependencyResolver;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.platform.base.internal.BinaryNamingScheme;

public class DefaultSharedLibraryBinarySpec
extends AbstractNativeLibraryBinarySpec
implements SharedLibraryBinary,
SharedLibraryBinarySpecInternal {
    private File sharedLibraryFile;
    private File sharedLibraryLinkFile;

    public DefaultSharedLibraryBinarySpec(NativeLibrarySpec library, Flavor flavor, NativeToolChainInternal toolChain, PlatformToolProvider toolProvider, NativePlatform platform, BuildType buildType, BinaryNamingScheme namingScheme, NativeDependencyResolver resolver) {
        super(library, flavor, toolChain, toolProvider, platform, buildType, namingScheme, resolver);
    }

    public File getSharedLibraryFile() {
        return this.sharedLibraryFile;
    }

    public void setSharedLibraryFile(File sharedLibraryFile) {
        this.sharedLibraryFile = sharedLibraryFile;
    }

    public File getSharedLibraryLinkFile() {
        return this.sharedLibraryLinkFile;
    }

    public void setSharedLibraryLinkFile(File sharedLibraryLinkFile) {
        this.sharedLibraryLinkFile = sharedLibraryLinkFile;
    }

    public File getPrimaryOutput() {
        return this.getSharedLibraryFile();
    }

    public FileCollection getLinkFiles() {
        return new SharedLibraryLinkOutputs();
    }

    public FileCollection getRuntimeFiles() {
        return new SharedLibraryRuntimeOutputs();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SharedLibraryRuntimeOutputs
    extends AbstractNativeLibraryBinarySpec.LibraryOutputs {
        private SharedLibraryRuntimeOutputs() {
        }

        @Override
        protected boolean hasOutputs() {
            return DefaultSharedLibraryBinarySpec.this.hasSources();
        }

        @Override
        protected Set<File> getOutputs() {
            return Collections.singleton(DefaultSharedLibraryBinarySpec.this.getSharedLibraryFile());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SharedLibraryLinkOutputs
    extends AbstractNativeLibraryBinarySpec.LibraryOutputs {
        private SharedLibraryLinkOutputs() {
        }

        @Override
        protected boolean hasOutputs() {
            return DefaultSharedLibraryBinarySpec.this.hasSources() && !this.isResourceOnly();
        }

        @Override
        protected Set<File> getOutputs() {
            return Collections.singleton(DefaultSharedLibraryBinarySpec.this.getSharedLibraryLinkFile());
        }

        private boolean isResourceOnly() {
            return this.hasResources() && !this.hasExportedSymbols();
        }

        private boolean hasResources() {
            for (NativeResourceSet windowsResourceSet : DefaultSharedLibraryBinarySpec.this.getSource().withType(NativeResourceSet.class)) {
                if (windowsResourceSet.getSource().isEmpty()) continue;
                return true;
            }
            return false;
        }

        private boolean hasExportedSymbols() {
            for (LanguageSourceSet languageSourceSet : DefaultSharedLibraryBinarySpec.this.getSource()) {
                if (languageSourceSet instanceof NativeResourceSet || languageSourceSet.getSource().isEmpty()) continue;
                return true;
            }
            return false;
        }
    }
}

