/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.nativeplatform.BuildType;
import org.gradle.nativeplatform.Flavor;
import org.gradle.nativeplatform.NativeLibrarySpec;
import org.gradle.nativeplatform.StaticLibraryBinary;
import org.gradle.nativeplatform.internal.AbstractNativeLibraryBinarySpec;
import org.gradle.nativeplatform.internal.StaticLibraryBinarySpecInternal;
import org.gradle.nativeplatform.internal.resolve.NativeDependencyResolver;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.platform.base.internal.BinaryNamingScheme;

public class DefaultStaticLibraryBinarySpec
extends AbstractNativeLibraryBinarySpec
implements StaticLibraryBinary,
StaticLibraryBinarySpecInternal {
    private final List<FileCollection> additionalLinkFiles = new ArrayList<FileCollection>();
    private File staticLibraryFile;

    public DefaultStaticLibraryBinarySpec(NativeLibrarySpec library, Flavor flavor, NativeToolChainInternal toolChain, PlatformToolProvider toolProvider, NativePlatform platform, BuildType buildType, BinaryNamingScheme namingScheme, NativeDependencyResolver resolver) {
        super(library, flavor, toolChain, toolProvider, platform, buildType, namingScheme, resolver);
    }

    public File getStaticLibraryFile() {
        return this.staticLibraryFile;
    }

    public void setStaticLibraryFile(File staticLibraryFile) {
        this.staticLibraryFile = staticLibraryFile;
    }

    public File getPrimaryOutput() {
        return this.getStaticLibraryFile();
    }

    public void additionalLinkFiles(FileCollection files) {
        this.additionalLinkFiles.add(files);
    }

    public FileCollection getLinkFiles() {
        return new StaticLibraryLinkOutputs();
    }

    public FileCollection getRuntimeFiles() {
        return new SimpleFileCollection(new File[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StaticLibraryLinkOutputs
    extends AbstractNativeLibraryBinarySpec.LibraryOutputs {
        private StaticLibraryLinkOutputs() {
        }

        @Override
        protected boolean hasOutputs() {
            return DefaultStaticLibraryBinarySpec.this.hasSources() || !DefaultStaticLibraryBinarySpec.this.additionalLinkFiles.isEmpty();
        }

        @Override
        protected Set<File> getOutputs() {
            LinkedHashSet<File> allFiles = new LinkedHashSet<File>();
            if (DefaultStaticLibraryBinarySpec.this.hasSources()) {
                allFiles.add(DefaultStaticLibraryBinarySpec.this.getStaticLibraryFile());
            }
            for (FileCollection resourceSet : DefaultStaticLibraryBinarySpec.this.additionalLinkFiles) {
                allFiles.addAll(resourceSet.getFiles());
            }
            return allFiles;
        }
    }
}

