/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.configure;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.nativeplatform.BuildType;
import org.gradle.nativeplatform.Flavor;
import org.gradle.nativeplatform.NativeComponentSpec;
import org.gradle.nativeplatform.internal.TargetedNativeComponentInternal;
import org.gradle.nativeplatform.internal.configure.NativeBinariesFactory;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.platform.base.PlatformContainer;
import org.gradle.platform.base.internal.BinaryNamingSchemeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeComponentSpecInitializer
implements Action<NativeComponentSpec> {
    private final NativeBinariesFactory factory;
    private final NativeToolChainRegistryInternal toolChainRegistry;
    private final PlatformContainer platforms;
    private final Set<BuildType> allBuildTypes = new LinkedHashSet<BuildType>();
    private final Set<Flavor> allFlavors = new LinkedHashSet<Flavor>();
    private final BinaryNamingSchemeBuilder namingSchemeBuilder;

    public NativeComponentSpecInitializer(NativeBinariesFactory factory, BinaryNamingSchemeBuilder namingSchemeBuilder, NativeToolChainRegistryInternal toolChainRegistry, PlatformContainer platforms, Collection<? extends BuildType> allBuildTypes, Collection<? extends Flavor> allFlavors) {
        this.factory = factory;
        this.namingSchemeBuilder = namingSchemeBuilder;
        this.toolChainRegistry = toolChainRegistry;
        this.allBuildTypes.addAll(allBuildTypes);
        this.allFlavors.addAll(allFlavors);
        this.platforms = platforms;
    }

    public void execute(NativeComponentSpec projectNativeComponent) {
        TargetedNativeComponentInternal targetedComponent = (TargetedNativeComponentInternal)((Object)projectNativeComponent);
        List targetPlatforms = this.platforms.select(NativePlatform.class, targetedComponent.getTargetPlatforms());
        for (NativePlatform platform : targetPlatforms) {
            NativeToolChainInternal toolChain = (NativeToolChainInternal)this.toolChainRegistry.getForPlatform(platform);
            PlatformToolProvider toolProvider = toolChain.select((NativePlatformInternal)platform);
            BinaryNamingSchemeBuilder builder = this.namingSchemeBuilder.withComponentName(projectNativeComponent.getName());
            builder = this.maybeAddDimension(builder, platform, targetPlatforms);
            this.executeForEachBuildType(projectNativeComponent, (NativePlatformInternal)platform, builder, toolChain, toolProvider);
        }
    }

    private void executeForEachBuildType(NativeComponentSpec projectNativeComponent, NativePlatformInternal platform, BinaryNamingSchemeBuilder builder, NativeToolChainInternal toolChain, PlatformToolProvider toolProvider) {
        Set<BuildType> targetBuildTypes = ((TargetedNativeComponentInternal)((Object)projectNativeComponent)).chooseBuildTypes(this.allBuildTypes);
        for (BuildType buildType : targetBuildTypes) {
            BinaryNamingSchemeBuilder nameBuilder = this.maybeAddDimension(builder, buildType, targetBuildTypes);
            this.executeForEachFlavor(projectNativeComponent, platform, buildType, nameBuilder, toolChain, toolProvider);
        }
    }

    private void executeForEachFlavor(NativeComponentSpec projectNativeComponent, NativePlatform platform, BuildType buildType, BinaryNamingSchemeBuilder buildTypedNameBuilder, NativeToolChainInternal toolChain, PlatformToolProvider toolProvider) {
        Set<Flavor> targetFlavors = ((TargetedNativeComponentInternal)((Object)projectNativeComponent)).chooseFlavors(this.allFlavors);
        for (Flavor flavor : targetFlavors) {
            BinaryNamingSchemeBuilder flavoredNameBuilder = this.maybeAddDimension(buildTypedNameBuilder, flavor, targetFlavors);
            this.factory.createNativeBinaries(projectNativeComponent, flavoredNameBuilder, toolChain, toolProvider, platform, buildType, flavor);
        }
    }

    private <T extends Named> BinaryNamingSchemeBuilder maybeAddDimension(BinaryNamingSchemeBuilder builder, T variation, Collection<T> variations) {
        if (variations.size() > 1) {
            builder = builder.withVariantDimension(variation.getName());
        }
        return builder;
    }
}

