/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.resolve;

import java.util.ArrayList;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.nativeplatform.internal.prebuilt.PrebuiltLibraryBinaryLocator;
import org.gradle.nativeplatform.internal.resolve.ApiRequirementNativeDependencyResolver;
import org.gradle.nativeplatform.internal.resolve.ChainedLibraryBinaryLocator;
import org.gradle.nativeplatform.internal.resolve.DefaultProjectLocator;
import org.gradle.nativeplatform.internal.resolve.InputHandlingNativeDependencyResolver;
import org.gradle.nativeplatform.internal.resolve.LibraryBinaryLocator;
import org.gradle.nativeplatform.internal.resolve.LibraryNativeDependencyResolver;
import org.gradle.nativeplatform.internal.resolve.NativeDependencyResolver;
import org.gradle.nativeplatform.internal.resolve.ProjectLibraryBinaryLocator;
import org.gradle.nativeplatform.internal.resolve.ProjectLocator;
import org.gradle.nativeplatform.internal.resolve.RequirementParsingNativeDependencyResolver;
import org.gradle.nativeplatform.internal.resolve.SourceSetNativeDependencyResolver;

public class NativeDependencyResolverServices {
    public ProjectLocator createProjectLocator(ProjectFinder projectFinder, DependencyMetaDataProvider metaDataProvider) {
        String currentProjectPath = metaDataProvider.getModule().getProjectPath();
        return new DefaultProjectLocator(currentProjectPath, projectFinder);
    }

    public LibraryBinaryLocator createLibraryBinaryLocator(ProjectLocator projectLocator) {
        ArrayList<LibraryBinaryLocator> locators = new ArrayList<LibraryBinaryLocator>();
        locators.add(new ProjectLibraryBinaryLocator(projectLocator));
        locators.add(new PrebuiltLibraryBinaryLocator(projectLocator));
        return new ChainedLibraryBinaryLocator(locators);
    }

    public NativeDependencyResolver createResolver(LibraryBinaryLocator locator, Instantiator instantiator) {
        NativeDependencyResolver resolver = new LibraryNativeDependencyResolver(locator, instantiator);
        resolver = new ApiRequirementNativeDependencyResolver(resolver);
        resolver = new RequirementParsingNativeDependencyResolver(resolver);
        resolver = new SourceSetNativeDependencyResolver(resolver);
        return new InputHandlingNativeDependencyResolver(resolver);
    }
}

