/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.platform.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.nativeplatform.platform.internal.ArchitectureInternal;
import org.gradle.nativeplatform.platform.internal.DefaultArchitecture;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchitectureNotationParser {
    private static final List<String> X86_ALIASES = Arrays.asList("x86", "i386", "ia-32");
    private static final List<String> X86_64_ALIASES = Arrays.asList("x86_64", "amd64", "x64", "x86-64");
    private static final List<String> ITANIUM_ALIASES = Arrays.asList("ia-64");
    private static final List<String> PPC_32_ALIASES = Arrays.asList("ppc");
    private static final List<String> PPC_64_ALIASES = Arrays.asList("ppc64");
    private static final List<String> SPARC_32_ALIASES = Arrays.asList("sparc", "sparc32", "sparc-v7", "sparc-v8");
    private static final List<String> SPARC_64_ALIASES = Arrays.asList("sparc64", "ultrasparc", "sparc-v9");
    private static final List<String> ARM_ALIASES = Arrays.asList("arm");

    public static NotationParser<Object, ArchitectureInternal> parser() {
        return NotationParserBuilder.toType(ArchitectureInternal.class).typeDisplayName("an object of type Architecture").fromCharSequence((NotationConverter)new Parser()).toComposite();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Parser
    implements NotationConverter<String, ArchitectureInternal> {
        private Parser() {
        }

        public void convert(String notation, NotationConvertResult<? super ArchitectureInternal> result) throws TypeConversionException {
            ArchitectureInternal architecture = this.parseType(notation);
            if (architecture != null) {
                result.converted((Object)architecture);
            }
        }

        protected ArchitectureInternal parseType(String notation) {
            if (X86_ALIASES.contains(notation.toLowerCase())) {
                return new DefaultArchitecture(notation, ArchitectureInternal.InstructionSet.X86, 32);
            }
            if (X86_64_ALIASES.contains(notation.toLowerCase())) {
                return new DefaultArchitecture(notation, ArchitectureInternal.InstructionSet.X86, 64);
            }
            if (ITANIUM_ALIASES.contains(notation.toLowerCase())) {
                return new DefaultArchitecture(notation, ArchitectureInternal.InstructionSet.ITANIUM, 64);
            }
            if (PPC_32_ALIASES.contains(notation.toLowerCase())) {
                return new DefaultArchitecture(notation, ArchitectureInternal.InstructionSet.PPC, 32);
            }
            if (PPC_64_ALIASES.contains(notation.toLowerCase())) {
                return new DefaultArchitecture(notation, ArchitectureInternal.InstructionSet.PPC, 64);
            }
            if (SPARC_32_ALIASES.contains(notation.toLowerCase())) {
                return new DefaultArchitecture(notation, ArchitectureInternal.InstructionSet.SPARC, 32);
            }
            if (SPARC_64_ALIASES.contains(notation.toLowerCase())) {
                return new DefaultArchitecture(notation, ArchitectureInternal.InstructionSet.SPARC, 64);
            }
            if (ARM_ALIASES.contains(notation.toLowerCase())) {
                return new DefaultArchitecture(notation, ArchitectureInternal.InstructionSet.ARM, 32);
            }
            return null;
        }

        public void describe(Collection<String> candidateFormats) {
            List validList = CollectionUtils.flattenCollections(String.class, (Object[])new Object[]{X86_ALIASES, X86_64_ALIASES, ITANIUM_ALIASES, PPC_32_ALIASES, PPC_64_ALIASES, SPARC_32_ALIASES, SPARC_64_ALIASES, ARM_ALIASES});
            candidateFormats.add("One of the following values: " + GUtil.toString((Iterable)validList));
        }
    }
}

