/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.platform.internal;

import org.gradle.nativeplatform.platform.internal.ArchitectureInternal;

public class DefaultArchitecture
implements ArchitectureInternal {
    private final String name;
    private final ArchitectureInternal.InstructionSet instructionSet;
    private final int registerSize;

    public DefaultArchitecture(String name, ArchitectureInternal.InstructionSet instructionSet, int registerSize) {
        this.name = name;
        this.instructionSet = instructionSet;
        this.registerSize = registerSize;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return String.format("architecture '%s'", this.name);
    }

    public ArchitectureInternal.InstructionSet getInstructionSet() {
        return this.instructionSet;
    }

    public int getRegisterSize() {
        return this.registerSize;
    }

    public boolean isI386() {
        return this.instructionSet == ArchitectureInternal.InstructionSet.X86 && this.registerSize == 32;
    }

    public boolean isAmd64() {
        return this.instructionSet == ArchitectureInternal.InstructionSet.X86 && this.registerSize == 64;
    }

    public boolean isIa64() {
        return this.instructionSet == ArchitectureInternal.InstructionSet.ITANIUM && this.registerSize == 64;
    }

    public boolean isArm() {
        return this.instructionSet == ArchitectureInternal.InstructionSet.ARM && this.registerSize == 32;
    }

    public boolean isArmv8() {
        return this.instructionSet == ArchitectureInternal.InstructionSet.ARM && this.registerSize == 64;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.instructionSet == null ? 0 : this.instructionSet.hashCode());
        result = 31 * result + this.registerSize;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultArchitecture other = (DefaultArchitecture)obj;
        if (this.instructionSet != other.instructionSet) {
            return false;
        }
        return this.registerSize == other.registerSize;
    }
}

