/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.platform.internal;

import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.nativeplatform.platform.internal.ArchitectureInternal;
import org.gradle.nativeplatform.platform.internal.ArchitectureNotationParser;
import org.gradle.nativeplatform.platform.internal.DefaultOperatingSystem;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.platform.internal.OperatingSystemInternal;
import org.gradle.nativeplatform.platform.internal.OperatingSystemNotationParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNativePlatform
implements NativePlatformInternal {
    private final NotationParser<Object, ArchitectureInternal> archParser;
    private final NotationParser<Object, OperatingSystemInternal> osParser;
    private final String name;
    private ArchitectureInternal architecture;
    private OperatingSystemInternal operatingSystem;

    public DefaultNativePlatform(String name, NotationParser<Object, ArchitectureInternal> archParser, NotationParser<Object, OperatingSystemInternal> osParser) {
        this.name = name;
        this.architecture = ArchitectureInternal.TOOL_CHAIN_DEFAULT;
        this.operatingSystem = DefaultOperatingSystem.TOOL_CHAIN_DEFAULT;
        this.archParser = archParser;
        this.osParser = osParser;
    }

    public DefaultNativePlatform(String name) {
        this(name, ArchitectureNotationParser.parser(), OperatingSystemNotationParser.parser());
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return String.format("platform '%s'", this.name);
    }

    @Override
    public ArchitectureInternal getArchitecture() {
        return this.architecture;
    }

    @Override
    public void architecture(Object notation) {
        this.architecture = (ArchitectureInternal)this.archParser.parseNotation(notation);
    }

    @Override
    public OperatingSystemInternal getOperatingSystem() {
        return this.operatingSystem;
    }

    @Override
    public void operatingSystem(Object notation) {
        this.operatingSystem = (OperatingSystemInternal)this.osParser.parseNotation(notation);
    }

    @Override
    public String getCompatibilityString() {
        return String.format("%s:%s", this.architecture.getName(), this.operatingSystem.getName());
    }
}

