/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.plugins;

import java.io.File;
import java.util.Collection;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Namer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.DefaultPolymorphicDomainObjectContainer;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.internal.Actions;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.internal.LanguageRegistry;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.language.nativeplatform.HeaderExportingSourceSet;
import org.gradle.model.Finalize;
import org.gradle.model.Model;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.nativeplatform.BuildType;
import org.gradle.nativeplatform.BuildTypeContainer;
import org.gradle.nativeplatform.Flavor;
import org.gradle.nativeplatform.FlavorContainer;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeComponentSpec;
import org.gradle.nativeplatform.NativeExecutableSpec;
import org.gradle.nativeplatform.NativeLibrarySpec;
import org.gradle.nativeplatform.PrebuiltLibraries;
import org.gradle.nativeplatform.PrebuiltLibrary;
import org.gradle.nativeplatform.Repositories;
import org.gradle.nativeplatform.internal.DefaultBuildTypeContainer;
import org.gradle.nativeplatform.internal.DefaultFlavorContainer;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.internal.NativeExecutableSpecFactory;
import org.gradle.nativeplatform.internal.NativeLibrarySpecFactory;
import org.gradle.nativeplatform.internal.configure.DefaultNativeBinariesFactory;
import org.gradle.nativeplatform.internal.configure.DefaultNativeComponentExtension;
import org.gradle.nativeplatform.internal.configure.NativeBinarySpecInitializer;
import org.gradle.nativeplatform.internal.configure.NativeComponentSpecInitializer;
import org.gradle.nativeplatform.internal.configure.ToolSettingNativeBinaryInitializer;
import org.gradle.nativeplatform.internal.prebuilt.DefaultPrebuiltLibraries;
import org.gradle.nativeplatform.internal.prebuilt.PrebuiltLibraryInitializer;
import org.gradle.nativeplatform.internal.resolve.NativeDependencyResolver;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.internal.DefaultNativeToolChainRegistry;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.ComponentSpecContainer;
import org.gradle.platform.base.PlatformContainer;
import org.gradle.platform.base.internal.BinaryNamingSchemeBuilder;
import org.gradle.platform.base.internal.DefaultBinaryNamingSchemeBuilder;
import org.gradle.platform.base.internal.DefaultPlatformContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class NativeComponentModelPlugin
implements Plugin<ProjectInternal> {
    private final Instantiator instantiator;

    @Inject
    public NativeComponentModelPlugin(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    public void apply(ProjectInternal project) {
        project.getPlugins().apply(ComponentModelBasePlugin.class);
        ProjectSourceSet sources = (ProjectSourceSet)project.getExtensions().getByType(ProjectSourceSet.class);
        ComponentSpecContainer components = (ComponentSpecContainer)project.getExtensions().getByType(ComponentSpecContainer.class);
        components.registerFactory(NativeExecutableSpec.class, (NamedDomainObjectFactory)new NativeExecutableSpecFactory(this.instantiator, sources, (Project)project));
        NamedDomainObjectContainer nativeExecutables = components.containerWithType(NativeExecutableSpec.class);
        components.registerFactory(NativeLibrarySpec.class, (NamedDomainObjectFactory)new NativeLibrarySpecFactory(this.instantiator, sources, (Project)project));
        NamedDomainObjectContainer nativeLibraries = components.containerWithType(NativeLibrarySpec.class);
        project.getExtensions().create("nativeRuntime", DefaultNativeComponentExtension.class, new Object[]{nativeExecutables, nativeLibraries});
        project.getExtensions().add("nativeComponents", (Object)components.withType(NativeComponentSpec.class));
        project.getExtensions().add("executables", (Object)nativeExecutables);
        project.getExtensions().add("libraries", (Object)nativeLibraries);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArtifactRepositoryNamer
    implements Namer<ArtifactRepository> {
        private ArtifactRepositoryNamer() {
        }

        public String determineName(ArtifactRepository object) {
            return object.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultRepositories
    extends DefaultPolymorphicDomainObjectContainer<ArtifactRepository>
    implements Repositories {
        private DefaultRepositories(final Instantiator instantiator, final FileResolver fileResolver, final Action<PrebuiltLibrary> binaryFactory) {
            super(ArtifactRepository.class, instantiator, (Namer)new ArtifactRepositoryNamer());
            this.registerFactory(PrebuiltLibraries.class, (NamedDomainObjectFactory)new NamedDomainObjectFactory<PrebuiltLibraries>(){

                public PrebuiltLibraries create(String name) {
                    return (PrebuiltLibraries)instantiator.newInstance(DefaultPrebuiltLibraries.class, new Object[]{name, instantiator, fileResolver, binaryFactory});
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MarkBinariesBuildable
    implements Action<NativeBinarySpec> {
        private MarkBinariesBuildable() {
        }

        public void execute(NativeBinarySpec nativeBinarySpec) {
            NativeToolChainInternal toolChainInternal = (NativeToolChainInternal)nativeBinarySpec.getToolChain();
            boolean canBuild = toolChainInternal.select((NativePlatformInternal)nativeBinarySpec.getTargetPlatform()).isAvailable();
            ((NativeBinarySpecInternal)nativeBinarySpec).setBuildable(canBuild);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @RuleSource
    public static class Rules {
        @Model
        Repositories repositories(ServiceRegistry serviceRegistry, FlavorContainer flavors, PlatformContainer platforms, BuildTypeContainer buildTypes) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            FileResolver fileResolver = (FileResolver)serviceRegistry.get(FileResolver.class);
            PrebuiltLibraryInitializer initializer = new PrebuiltLibraryInitializer(instantiator, (Collection<? extends NativePlatform>)platforms.withType(NativePlatform.class), (Collection<? extends BuildType>)((Object)buildTypes), (Collection<? extends Flavor>)((Object)flavors));
            return new DefaultRepositories(instantiator, fileResolver, initializer);
        }

        @Model
        NativeToolChainRegistryInternal toolChains(ServiceRegistry serviceRegistry) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            return (NativeToolChainRegistryInternal)instantiator.newInstance(DefaultNativeToolChainRegistry.class, new Object[]{instantiator});
        }

        @Model
        BuildTypeContainer buildTypes(ServiceRegistry serviceRegistry) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            return (BuildTypeContainer)instantiator.newInstance(DefaultBuildTypeContainer.class, new Object[]{instantiator});
        }

        @Model
        FlavorContainer flavors(ServiceRegistry serviceRegistry) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            return (FlavorContainer)instantiator.newInstance(DefaultFlavorContainer.class, new Object[]{instantiator});
        }

        @Model
        NamedDomainObjectSet<NativeComponentSpec> nativeComponents(ComponentSpecContainer components) {
            return components.withType(NativeComponentSpec.class);
        }

        @Mutate
        public void registerExtensions(ExtensionContainer extensions, BuildTypeContainer buildTypes, FlavorContainer flavors) {
            extensions.add("buildTypes", (Object)buildTypes);
            extensions.add("flavors", (Object)flavors);
        }

        @Mutate
        public void registerNativePlatformFactory(PlatformContainer platforms, ServiceRegistry serviceRegistry) {
            final Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            NamedDomainObjectFactory<NativePlatform> nativePlatformFactory = new NamedDomainObjectFactory<NativePlatform>(){

                public NativePlatform create(String name) {
                    return (NativePlatform)instantiator.newInstance(DefaultNativePlatform.class, new Object[]{name});
                }
            };
            ((DefaultPlatformContainer)platforms).registerDefaultFactory((NamedDomainObjectFactory)nativePlatformFactory);
            platforms.registerFactory(NativePlatform.class, (NamedDomainObjectFactory)nativePlatformFactory);
        }

        @Mutate
        public void createNativeBinaries(BinaryContainer binaries, NamedDomainObjectSet<NativeComponentSpec> nativeComponents, LanguageRegistry languages, NativeToolChainRegistryInternal toolChains, PlatformContainer platforms, BuildTypeContainer buildTypes, FlavorContainer flavors, ServiceRegistry serviceRegistry, @Path(value="buildDir") File buildDir) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            NativeDependencyResolver resolver = (NativeDependencyResolver)serviceRegistry.get(NativeDependencyResolver.class);
            NativeBinarySpecInitializer configureBinaryAction = new NativeBinarySpecInitializer(buildDir);
            ToolSettingNativeBinaryInitializer setToolsAction = new ToolSettingNativeBinaryInitializer(languages);
            ToolSettingNativeBinaryInitializer setDefaultTargetsAction = new ToolSettingNativeBinaryInitializer(languages);
            Action initAction = Actions.composite((Action[])new Action[]{configureBinaryAction, setToolsAction, new MarkBinariesBuildable()});
            DefaultNativeBinariesFactory factory = new DefaultNativeBinariesFactory(instantiator, (Action<NativeBinarySpec>)initAction, resolver);
            DefaultBinaryNamingSchemeBuilder namingSchemeBuilder = new DefaultBinaryNamingSchemeBuilder();
            NativeComponentSpecInitializer createBinariesAction = new NativeComponentSpecInitializer(factory, (BinaryNamingSchemeBuilder)namingSchemeBuilder, toolChains, platforms, (Collection<? extends BuildType>)((Object)buildTypes), (Collection<? extends Flavor>)((Object)flavors));
            for (NativeComponentSpec component : nativeComponents) {
                createBinariesAction.execute(component);
                binaries.addAll((Collection)component.getBinaries());
            }
        }

        @Finalize
        public void createDefaultPlatforms(PlatformContainer platforms) {
            if (platforms.withType(NativePlatform.class).isEmpty()) {
                NativePlatform nativePlatform = (NativePlatform)platforms.create("current", NativePlatform.class);
            }
        }

        @Finalize
        public void createDefaultToolChain(NativeToolChainRegistryInternal toolChains) {
            if (toolChains.isEmpty()) {
                toolChains.addDefaultToolChains();
            }
        }

        @Finalize
        public void createDefaultBuildTypes(BuildTypeContainer buildTypes) {
            if (buildTypes.isEmpty()) {
                buildTypes.create("debug");
            }
        }

        @Finalize
        public void createDefaultFlavor(FlavorContainer flavors) {
            if (flavors.isEmpty()) {
                flavors.create("default");
            }
        }

        @Mutate
        void configureGeneratedSourceSets(ProjectSourceSet sources) {
            for (FunctionalSourceSet functionalSourceSet : sources) {
                for (LanguageSourceSetInternal languageSourceSet : functionalSourceSet.withType(LanguageSourceSetInternal.class)) {
                    Task generatorTask = languageSourceSet.getGeneratorTask();
                    if (generatorTask == null) continue;
                    languageSourceSet.builtBy(new Object[]{generatorTask});
                    this.maybeSetSourceDir(languageSourceSet.getSource(), generatorTask, "sourceDir");
                    if (!(languageSourceSet instanceof HeaderExportingSourceSet)) continue;
                    this.maybeSetSourceDir(((HeaderExportingSourceSet)languageSourceSet).getExportedHeaders(), generatorTask, "headerDir");
                }
            }
        }

        @Finalize
        public void applyHeaderSourceSetConventions(ProjectSourceSet sources) {
            for (FunctionalSourceSet functionalSourceSet : sources) {
                for (HeaderExportingSourceSet headerSourceSet : functionalSourceSet.withType(HeaderExportingSourceSet.class)) {
                    if (headerSourceSet.getExportedHeaders().getSrcDirs().isEmpty()) {
                        headerSourceSet.getExportedHeaders().srcDir((Object)String.format("src/%s/headers", functionalSourceSet.getName()));
                    }
                    headerSourceSet.getImplicitHeaders().setSrcDirs((Iterable)headerSourceSet.getSource().getSrcDirs());
                    headerSourceSet.getImplicitHeaders().include(new String[]{"**/*.h"});
                }
            }
        }

        private void maybeSetSourceDir(SourceDirectorySet sourceSet, Task task, String propertyName) {
            Object value = task.property(propertyName);
            if (value != null) {
                sourceSet.srcDir(value);
            }
        }
    }
}

