/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal;

import com.google.common.base.Joiner;
import java.io.File;
import org.gradle.api.GradleException;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocation;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.process.internal.ExecException;
import org.gradle.util.GFileUtils;

public class CommandLineTool {
    private final String action;
    private final File executable;
    private final ExecActionFactory execActionFactory;

    public CommandLineTool(String action, File executable, ExecActionFactory execActionFactory) {
        this.action = action;
        this.executable = executable;
        this.execActionFactory = execActionFactory;
    }

    public void execute(CommandLineToolInvocation invocation) {
        ExecAction compiler = this.execActionFactory.newExecAction();
        compiler.executable((Object)this.executable);
        if (invocation.getWorkDirectory() != null) {
            GFileUtils.mkdirs((File)invocation.getWorkDirectory());
            compiler.workingDir((Object)invocation.getWorkDirectory());
        }
        compiler.args(invocation.getArgs());
        if (!invocation.getPath().isEmpty()) {
            String pathVar = OperatingSystem.current().getPathVar();
            String compilerPath = Joiner.on((String)File.pathSeparator).join(invocation.getPath());
            compilerPath = compilerPath + File.pathSeparator + System.getenv(pathVar);
            compiler.environment(pathVar, (Object)compilerPath);
        }
        compiler.environment(invocation.getEnvironment());
        try {
            compiler.execute();
        }
        catch (ExecException e) {
            throw new GradleException(String.format("%s failed; see the error output for details.", this.action), (Throwable)e);
        }
    }
}

