/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.nativeplatform.toolchain.internal.MutableCommandLineToolInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCommandLineToolInvocation
implements MutableCommandLineToolInvocation {
    private final List<Action<List<String>>> postArgsActions = new ArrayList<Action<List<String>>>();
    private final Map<String, String> environment = new HashMap<String, String>();
    private final List<File> path = new ArrayList<File>();
    private List<String> args = new ArrayList<String>();
    private File workDirectory;

    @Override
    public MutableCommandLineToolInvocation copy() {
        DefaultCommandLineToolInvocation invocation = new DefaultCommandLineToolInvocation();
        for (Action<List<String>> postArgsAction : this.postArgsActions) {
            invocation.addPostArgsAction(postArgsAction);
        }
        invocation.args.addAll(this.args);
        invocation.workDirectory = this.workDirectory;
        invocation.path.addAll(this.path);
        invocation.environment.putAll(this.environment);
        return invocation;
    }

    @Override
    public void addPostArgsAction(Action<List<String>> postArgsAction) {
        this.postArgsActions.add(postArgsAction);
    }

    @Override
    public List<String> getArgs() {
        ArrayList transformedArgs = Lists.newArrayList(this.args);
        for (Action<List<String>> postArgsAction : this.postArgsActions) {
            postArgsAction.execute((Object)transformedArgs);
        }
        return transformedArgs;
    }

    @Override
    public void setArgs(List<String> args) {
        this.args = args;
    }

    @Override
    public File getWorkDirectory() {
        return this.workDirectory;
    }

    @Override
    public void setWorkDirectory(File workDirectory) {
        this.workDirectory = workDirectory;
    }

    @Override
    public void addPath(File pathEntry) {
        this.path.add(pathEntry);
    }

    @Override
    public void addPath(List<File> path) {
        this.path.addAll(path);
    }

    @Override
    public List<File> getPath() {
        return this.path;
    }

    @Override
    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    @Override
    public void addEnvironmentVar(String key, String value) {
        this.environment.put(key, value);
    }
}

