/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.internal.FileUtils;
import org.gradle.nativeplatform.internal.CompilerOutputFileNamingScheme;
import org.gradle.nativeplatform.toolchain.internal.ArgsTransformer;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleSourceCompileArgTransformer<T extends NativeCompileSpec>
implements ArgsTransformer<T> {
    private final ArgsTransformer<T> delegate;
    private final String objectFileNameSuffix;
    private final File sourceFile;
    private final Transformer<List<String>, File> outputFileArgTransformer;
    private final boolean windowsPathLengthLimitation;

    public SingleSourceCompileArgTransformer(File sourceFile, String objectFileNameSuffixExtension, ArgsTransformer<T> delegate, boolean windowsPathLengthLimitation, Transformer<List<String>, File> outputFileArgTransformer) {
        this.sourceFile = sourceFile;
        this.delegate = delegate;
        this.objectFileNameSuffix = objectFileNameSuffixExtension;
        this.outputFileArgTransformer = outputFileArgTransformer;
        this.windowsPathLengthLimitation = windowsPathLengthLimitation;
    }

    public List<String> transform(T spec) {
        ArrayList<String> args = new ArrayList<String>();
        File outputFilePath = this.getOutputFileDir(this.sourceFile, spec.getObjectFileDir());
        args.addAll((Collection)this.delegate.transform(spec));
        args.add(this.sourceFile.getAbsolutePath());
        CollectionUtils.addAll(args, (Iterable)((Iterable)this.outputFileArgTransformer.transform((Object)outputFilePath)));
        return args;
    }

    protected File getOutputFileDir(File sourceFile, File objectFileDir) {
        File outputFile = new CompilerOutputFileNamingScheme().withObjectFileNameSuffix(this.objectFileNameSuffix).withOutputBaseFolder(objectFileDir).map(sourceFile);
        File outputDirectory = outputFile.getParentFile();
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        return this.windowsPathLengthLimitation ? FileUtils.assertInWindowsPathLengthLimitation((File)outputFile) : outputFile;
    }
}

