/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal;

import org.gradle.api.GradleException;
import org.gradle.internal.text.TreeFormatter;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativeplatform.platform.internal.OperatingSystemInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.platform.base.internal.toolchain.ToolSearchResult;
import org.gradle.util.TreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnavailablePlatformToolProvider
implements PlatformToolProvider {
    private final OperatingSystemInternal operatingSystem;
    private final ToolSearchResult failure;

    public UnavailablePlatformToolProvider(OperatingSystemInternal operatingSystem, ToolSearchResult failure) {
        this.operatingSystem = operatingSystem;
        this.failure = failure;
    }

    public boolean isAvailable() {
        return false;
    }

    public void explain(TreeVisitor<? super String> visitor) {
        this.failure.explain(visitor);
    }

    private RuntimeException failure() {
        TreeFormatter formatter = new TreeFormatter();
        this.explain((TreeVisitor<? super String>)formatter);
        return new GradleException(formatter.toString());
    }

    @Override
    public String getObjectFileExtension() {
        throw this.failure();
    }

    @Override
    public String getExecutableName(String executablePath) {
        return this.operatingSystem.getInternalOs().getExecutableName(executablePath);
    }

    @Override
    public String getSharedLibraryName(String libraryPath) {
        return this.operatingSystem.getInternalOs().getSharedLibraryName(libraryPath);
    }

    @Override
    public String getSharedLibraryLinkFileName(String libraryPath) {
        return this.operatingSystem.getInternalOs().getSharedLibraryName(libraryPath);
    }

    @Override
    public String getStaticLibraryName(String libraryPath) {
        return this.operatingSystem.getInternalOs().getStaticLibraryName(libraryPath);
    }

    public <T extends CompileSpec> Compiler<T> newCompiler(T spec) {
        throw this.failure();
    }
}

