/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.gcc;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.tasks.WorkResult;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativeplatform.internal.StaticLibraryArchiverSpec;
import org.gradle.nativeplatform.toolchain.internal.ArgsTransformer;
import org.gradle.nativeplatform.toolchain.internal.CommandLineTool;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocation;
import org.gradle.nativeplatform.toolchain.internal.MutableCommandLineToolInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArStaticLibraryArchiver
implements Compiler<StaticLibraryArchiverSpec> {
    private final CommandLineTool commandLineTool;
    private final ArgsTransformer<StaticLibraryArchiverSpec> arguments = new ArchiverSpecToArguments();
    private final CommandLineToolInvocation baseInvocation;

    public ArStaticLibraryArchiver(CommandLineTool commandLineTool, CommandLineToolInvocation baseInvocation) {
        this.commandLineTool = commandLineTool;
        this.baseInvocation = baseInvocation;
    }

    public WorkResult execute(StaticLibraryArchiverSpec spec) {
        this.deletePreviousOutput(spec);
        MutableCommandLineToolInvocation invocation = this.baseInvocation.copy();
        invocation.setArgs((List)this.arguments.transform(spec));
        this.commandLineTool.execute(invocation);
        return new SimpleWorkResult(true);
    }

    private void deletePreviousOutput(StaticLibraryArchiverSpec spec) {
        if (!spec.getOutputFile().isFile()) {
            return;
        }
        if (!spec.getOutputFile().delete()) {
            throw new GradleException("Create static archive failed: could not delete previous archive");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArchiverSpecToArguments
    implements ArgsTransformer<StaticLibraryArchiverSpec> {
        private ArchiverSpecToArguments() {
        }

        public List<String> transform(StaticLibraryArchiverSpec spec) {
            ArrayList<String> args = new ArrayList<String>();
            args.add("-rcs");
            args.addAll(spec.getAllArgs());
            args.add(spec.getOutputFile().getAbsolutePath());
            for (File file : spec.getObjectFiles()) {
                args.add(file.getAbsolutePath());
            }
            return args;
        }
    }
}

