/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.gcc;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.nativeplatform.toolchain.internal.OptionsFileArgsTransformer;
import org.gradle.platform.base.internal.toolchain.ArgWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GccOptionsFileArgTransformer
extends OptionsFileArgsTransformer {
    private static final List<String> CLI_ONLY_ARGS = Arrays.asList("-m32", "-m64");

    public GccOptionsFileArgTransformer(File tempDir) {
        super((Transformer<ArgWriter, PrintWriter>)ArgWriter.unixStyleFactory(), tempDir);
    }

    @Override
    protected void transformArgs(List<String> input, List<String> output, File tempDir) {
        List<String> commandLineOnlyArgs = this.getCommandLineOnlyArgs(input);
        output.addAll(commandLineOnlyArgs);
        super.transformArgs(input, output, tempDir);
    }

    private List<String> getCommandLineOnlyArgs(List<String> allArgs) {
        ArrayList<String> commandLineOnlyArgs = new ArrayList<String>(allArgs);
        commandLineOnlyArgs.retainAll(CLI_ONLY_ARGS);
        return commandLineOnlyArgs;
    }
}

