/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.gcc;

import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativeplatform.internal.LinkerSpec;
import org.gradle.nativeplatform.internal.StaticLibraryArchiverSpec;
import org.gradle.nativeplatform.platform.internal.OperatingSystemInternal;
import org.gradle.nativeplatform.toolchain.internal.CommandLineTool;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocation;
import org.gradle.nativeplatform.toolchain.internal.DefaultCommandLineToolInvocation;
import org.gradle.nativeplatform.toolchain.internal.OutputCleaningCompiler;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.nativeplatform.toolchain.internal.compilespec.AssembleSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CppCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.ObjectiveCCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.ObjectiveCppCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.WindowsResourceCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.gcc.ArStaticLibraryArchiver;
import org.gradle.nativeplatform.toolchain.internal.gcc.Assembler;
import org.gradle.nativeplatform.toolchain.internal.gcc.CCompiler;
import org.gradle.nativeplatform.toolchain.internal.gcc.CppCompiler;
import org.gradle.nativeplatform.toolchain.internal.gcc.GccLinker;
import org.gradle.nativeplatform.toolchain.internal.gcc.ObjectiveCCompiler;
import org.gradle.nativeplatform.toolchain.internal.gcc.ObjectiveCppCompiler;
import org.gradle.nativeplatform.toolchain.internal.tools.GccCommandLineToolConfigurationInternal;
import org.gradle.nativeplatform.toolchain.internal.tools.ToolRegistry;
import org.gradle.nativeplatform.toolchain.internal.tools.ToolSearchPath;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.util.TreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GccPlatformToolProvider
implements PlatformToolProvider {
    private final ToolSearchPath toolSearchPath;
    private final OperatingSystemInternal targetOperatingSystem;
    private final ToolRegistry toolRegistry;
    private final ExecActionFactory execActionFactory;
    private final boolean useCommandFile;
    private final String outputFileSuffix;

    GccPlatformToolProvider(OperatingSystemInternal targetOperatingSystem, ToolSearchPath toolSearchPath, ToolRegistry toolRegistry, ExecActionFactory execActionFactory, boolean useCommandFile) {
        this.targetOperatingSystem = targetOperatingSystem;
        this.toolRegistry = toolRegistry;
        this.toolSearchPath = toolSearchPath;
        this.execActionFactory = execActionFactory;
        this.useCommandFile = useCommandFile;
        this.outputFileSuffix = "." + this.getObjectFileExtension();
    }

    public boolean isAvailable() {
        return true;
    }

    public void explain(TreeVisitor<? super String> visitor) {
    }

    @Override
    public String getObjectFileExtension() {
        return this.targetOperatingSystem.isWindows() ? "obj" : "o";
    }

    @Override
    public String getExecutableName(String executablePath) {
        return this.targetOperatingSystem.getInternalOs().getExecutableName(executablePath);
    }

    @Override
    public String getSharedLibraryName(String libraryPath) {
        return this.targetOperatingSystem.getInternalOs().getSharedLibraryName(libraryPath);
    }

    @Override
    public String getSharedLibraryLinkFileName(String libraryPath) {
        return this.targetOperatingSystem.getInternalOs().getSharedLibraryName(libraryPath);
    }

    @Override
    public String getStaticLibraryName(String libraryPath) {
        return this.targetOperatingSystem.getInternalOs().getStaticLibraryName(libraryPath);
    }

    public <T extends CompileSpec> Compiler<T> newCompiler(T spec) {
        if (spec instanceof CppCompileSpec) {
            return this.castCompiler(this.createCppCompiler());
        }
        if (spec instanceof CCompileSpec) {
            return this.castCompiler(this.createCCompiler());
        }
        if (spec instanceof ObjectiveCppCompileSpec) {
            return this.castCompiler(this.createObjectiveCppCompiler());
        }
        if (spec instanceof ObjectiveCCompileSpec) {
            return this.castCompiler(this.createObjectiveCCompiler());
        }
        if (spec instanceof WindowsResourceCompileSpec) {
            throw new RuntimeException("Windows resource compiler is not available");
        }
        if (spec instanceof AssembleSpec) {
            return this.castCompiler(this.createAssembler());
        }
        if (spec instanceof LinkerSpec) {
            return this.castCompiler(this.createLinker());
        }
        if (spec instanceof StaticLibraryArchiverSpec) {
            return this.castCompiler(this.createStaticLibraryArchiver());
        }
        throw new IllegalArgumentException(String.format("Don't know how to compile from a spec of type %s.", spec.getClass().getSimpleName()));
    }

    private <T extends CompileSpec> Compiler<T> castCompiler(Compiler<?> compiler) {
        return compiler;
    }

    public Compiler<CppCompileSpec> createCppCompiler() {
        GccCommandLineToolConfigurationInternal cppCompilerTool = this.toolRegistry.getTool(ToolType.CPP_COMPILER);
        CppCompiler cppCompiler = new CppCompiler(this.commandLineTool(cppCompilerTool), this.commandLineToolInvocation(cppCompilerTool), this.outputFileSuffix, this.useCommandFile);
        return new OutputCleaningCompiler<CppCompileSpec>(cppCompiler, this.outputFileSuffix);
    }

    public Compiler<CCompileSpec> createCCompiler() {
        GccCommandLineToolConfigurationInternal cCompilerTool = this.toolRegistry.getTool(ToolType.C_COMPILER);
        CCompiler cCompiler = new CCompiler(this.commandLineTool(cCompilerTool), this.commandLineToolInvocation(cCompilerTool), this.outputFileSuffix, this.useCommandFile);
        return new OutputCleaningCompiler<CCompileSpec>(cCompiler, this.outputFileSuffix);
    }

    public Compiler<ObjectiveCppCompileSpec> createObjectiveCppCompiler() {
        GccCommandLineToolConfigurationInternal objectiveCppCompilerTool = this.toolRegistry.getTool(ToolType.OBJECTIVECPP_COMPILER);
        ObjectiveCppCompiler objectiveCppCompiler = new ObjectiveCppCompiler(this.commandLineTool(objectiveCppCompilerTool), this.commandLineToolInvocation(objectiveCppCompilerTool), this.outputFileSuffix, this.useCommandFile);
        return new OutputCleaningCompiler<ObjectiveCppCompileSpec>(objectiveCppCompiler, this.outputFileSuffix);
    }

    public Compiler<ObjectiveCCompileSpec> createObjectiveCCompiler() {
        GccCommandLineToolConfigurationInternal objectiveCCompilerTool = this.toolRegistry.getTool(ToolType.OBJECTIVEC_COMPILER);
        ObjectiveCCompiler objectiveCCompiler = new ObjectiveCCompiler(this.commandLineTool(objectiveCCompilerTool), this.commandLineToolInvocation(objectiveCCompilerTool), this.outputFileSuffix, this.useCommandFile);
        return new OutputCleaningCompiler<ObjectiveCCompileSpec>(objectiveCCompiler, this.outputFileSuffix);
    }

    public Compiler<AssembleSpec> createAssembler() {
        GccCommandLineToolConfigurationInternal assemblerTool = this.toolRegistry.getTool(ToolType.ASSEMBLER);
        return new Assembler(this.commandLineTool(assemblerTool), this.commandLineToolInvocation(assemblerTool), this.outputFileSuffix);
    }

    public Compiler<LinkerSpec> createLinker() {
        GccCommandLineToolConfigurationInternal linkerTool = this.toolRegistry.getTool(ToolType.LINKER);
        return new GccLinker(this.commandLineTool(linkerTool), this.commandLineToolInvocation(linkerTool), this.useCommandFile);
    }

    public Compiler<StaticLibraryArchiverSpec> createStaticLibraryArchiver() {
        GccCommandLineToolConfigurationInternal staticLibArchiverTool = this.toolRegistry.getTool(ToolType.STATIC_LIB_ARCHIVER);
        return new ArStaticLibraryArchiver(this.commandLineTool(staticLibArchiverTool), this.commandLineToolInvocation(staticLibArchiverTool));
    }

    private CommandLineTool commandLineTool(GccCommandLineToolConfigurationInternal tool) {
        ToolType key = tool.getToolType();
        String exeName = tool.getExecutable();
        return new CommandLineTool(key.getToolName(), this.toolSearchPath.locate(key, exeName).getTool(), this.execActionFactory);
    }

    private CommandLineToolInvocation commandLineToolInvocation(GccCommandLineToolConfigurationInternal toolConfiguration) {
        DefaultCommandLineToolInvocation baseInvocation = new DefaultCommandLineToolInvocation();
        baseInvocation.addPath(this.toolSearchPath.getPath());
        baseInvocation.addEnvironmentVar("CYGWIN", "nodosfilewarning");
        baseInvocation.addPostArgsAction(toolConfiguration.getArgAction());
        return baseInvocation;
    }
}

