/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.tasks.WorkResult;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativeplatform.internal.StaticLibraryArchiverSpec;
import org.gradle.nativeplatform.toolchain.internal.ArgsTransformer;
import org.gradle.nativeplatform.toolchain.internal.CommandLineTool;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocation;
import org.gradle.nativeplatform.toolchain.internal.MutableCommandLineToolInvocation;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.EscapeUserArgs;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualCppOptionsFileArgTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LibExeStaticLibraryArchiver
implements Compiler<StaticLibraryArchiverSpec> {
    private final CommandLineTool commandLineTool;
    private final ArgsTransformer<StaticLibraryArchiverSpec> args = new LibExeSpecToArguments();
    private final CommandLineToolInvocation baseInvocation;

    public LibExeStaticLibraryArchiver(CommandLineTool commandLineTool, CommandLineToolInvocation invocation) {
        this.commandLineTool = commandLineTool;
        this.baseInvocation = invocation;
    }

    public WorkResult execute(StaticLibraryArchiverSpec spec) {
        MutableCommandLineToolInvocation invocation = this.baseInvocation.copy();
        invocation.addPostArgsAction(new VisualCppOptionsFileArgTransformer(spec.getTempDir()));
        invocation.setArgs((List)this.args.transform(spec));
        this.commandLineTool.execute(invocation);
        return new SimpleWorkResult(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LibExeSpecToArguments
    implements ArgsTransformer<StaticLibraryArchiverSpec> {
        private LibExeSpecToArguments() {
        }

        public List<String> transform(StaticLibraryArchiverSpec spec) {
            ArrayList<String> args = new ArrayList<String>();
            args.add("/OUT:" + spec.getOutputFile().getAbsolutePath());
            args.add("/NOLOGO");
            args.addAll(EscapeUserArgs.escapeUserArgs(spec.getAllArgs()));
            for (File file : spec.getObjectFiles()) {
                args.add(file.getAbsolutePath());
            }
            return args;
        }
    }
}

