/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.nativeplatform.toolchain.internal.ArgsTransformer;
import org.gradle.nativeplatform.toolchain.internal.MacroArgsConverter;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.EscapeUserArgs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class VisualCppCompilerArgsTransformer<T extends NativeCompileSpec>
implements ArgsTransformer<T> {
    VisualCppCompilerArgsTransformer() {
    }

    public List<String> transform(T spec) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getLanguageOption());
        args.add("/nologo");
        for (String macroArg : new MacroArgsConverter().transform(spec.getMacros())) {
            args.add(EscapeUserArgs.escapeUserArg("/D" + macroArg));
        }
        args.addAll(EscapeUserArgs.escapeUserArgs(spec.getAllArgs()));
        args.add("/c");
        for (File file : spec.getIncludeRoots()) {
            args.add("/I" + file.getAbsolutePath());
        }
        return args;
    }

    protected abstract String getLanguageOption();
}

