/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Transformer;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativeplatform.internal.LinkerSpec;
import org.gradle.nativeplatform.internal.StaticLibraryArchiverSpec;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.CommandLineToolConfiguration;
import org.gradle.nativeplatform.toolchain.VisualCpp;
import org.gradle.nativeplatform.toolchain.VisualCppPlatformToolChain;
import org.gradle.nativeplatform.toolchain.internal.CommandLineTool;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocation;
import org.gradle.nativeplatform.toolchain.internal.DefaultCommandLineToolInvocation;
import org.gradle.nativeplatform.toolchain.internal.ExtendableToolChain;
import org.gradle.nativeplatform.toolchain.internal.MutableCommandLineToolInvocation;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.OutputCleaningCompiler;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.nativeplatform.toolchain.internal.UnavailablePlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.compilespec.AssembleSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CppCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.ObjectiveCCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.ObjectiveCppCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.WindowsResourceCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.Assembler;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.CCompiler;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.CppCompiler;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.LibExeStaticLibraryArchiver;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.LinkExeLinker;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualCppInstall;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualStudioLocator;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsResourceCompiler;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsSdk;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsSdkLocator;
import org.gradle.nativeplatform.toolchain.internal.tools.CommandLineToolConfigurationInternal;
import org.gradle.nativeplatform.toolchain.internal.tools.DefaultCommandLineToolConfiguration;
import org.gradle.platform.base.internal.toolchain.ToolChainAvailability;
import org.gradle.platform.base.internal.toolchain.ToolSearchResult;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.util.TreeVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualCppToolChain
extends ExtendableToolChain<VisualCppPlatformToolChain>
implements VisualCpp,
NativeToolChainInternal {
    private final String name;
    protected final OperatingSystem operatingSystem;
    private final FileResolver fileResolver;
    private static final Logger LOGGER = LoggerFactory.getLogger(VisualCppToolChain.class);
    public static final String DEFAULT_NAME = "visualCpp";
    private final ExecActionFactory execActionFactory;
    private final VisualStudioLocator visualStudioLocator;
    private final WindowsSdkLocator windowsSdkLocator;
    private final Instantiator instantiator;
    private File installDir;
    private File windowsSdkDir;
    private VisualCppInstall visualCpp;
    private WindowsSdk windowsSdk;
    private ToolChainAvailability availability;

    public VisualCppToolChain(String name, OperatingSystem operatingSystem, FileResolver fileResolver, ExecActionFactory execActionFactory, VisualStudioLocator visualStudioLocator, WindowsSdkLocator windowsSdkLocator, Instantiator instantiator) {
        super(name, operatingSystem, fileResolver);
        this.name = name;
        this.operatingSystem = operatingSystem;
        this.fileResolver = fileResolver;
        this.execActionFactory = execActionFactory;
        this.visualStudioLocator = visualStudioLocator;
        this.windowsSdkLocator = windowsSdkLocator;
        this.instantiator = instantiator;
    }

    @Override
    protected String getTypeName() {
        return "Visual Studio";
    }

    @Override
    public File getInstallDir() {
        return this.installDir;
    }

    @Override
    public void setInstallDir(Object installDirPath) {
        this.installDir = this.resolve(installDirPath);
    }

    @Override
    public File getWindowsSdkDir() {
        return this.windowsSdkDir;
    }

    @Override
    public void setWindowsSdkDir(Object windowsSdkDirPath) {
        this.windowsSdkDir = this.resolve(windowsSdkDirPath);
    }

    @Override
    public PlatformToolProvider select(NativePlatformInternal targetPlatform) {
        ToolChainAvailability result = new ToolChainAvailability();
        result.mustBeAvailable((ToolSearchResult)this.getAvailability());
        if (this.visualCpp != null && !this.visualCpp.isSupportedPlatform(targetPlatform)) {
            result.unavailable(String.format("Don't know how to build for platform '%s'.", targetPlatform.getName()));
        }
        if (!result.isAvailable()) {
            return new UnavailablePlatformToolProvider(targetPlatform.getOperatingSystem(), (ToolSearchResult)result);
        }
        DefaultVisualCppPlatformToolChain configurableToolChain = (DefaultVisualCppPlatformToolChain)this.instantiator.newInstance(DefaultVisualCppPlatformToolChain.class, new Object[]{targetPlatform, this.instantiator});
        this.configureActions.execute((Object)configurableToolChain);
        return new VisualCppPlatformToolProvider(configurableToolChain.tools, this.visualCpp, this.windowsSdk, targetPlatform);
    }

    private ToolChainAvailability getAvailability() {
        if (this.availability == null) {
            this.availability = new ToolChainAvailability();
            this.checkAvailable(this.availability);
        }
        return this.availability;
    }

    private void checkAvailable(ToolChainAvailability availability) {
        if (!this.operatingSystem.isWindows()) {
            availability.unavailable("Visual Studio is not available on this operating system.");
            return;
        }
        VisualStudioLocator.SearchResult visualStudioSearchResult = this.visualStudioLocator.locateVisualStudioInstalls(this.installDir);
        availability.mustBeAvailable((ToolSearchResult)visualStudioSearchResult);
        if (visualStudioSearchResult.isAvailable()) {
            this.visualCpp = visualStudioSearchResult.getVisualStudio().getVisualCpp();
        }
        WindowsSdkLocator.SearchResult windowsSdkSearchResult = this.windowsSdkLocator.locateWindowsSdks(this.windowsSdkDir);
        availability.mustBeAvailable((ToolSearchResult)windowsSdkSearchResult);
        if (windowsSdkSearchResult.isAvailable()) {
            this.windowsSdk = windowsSdkSearchResult.getSdk();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return String.format("Tool chain '%s' (%s)", this.getName(), this.getTypeName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VisualCppPlatformToolProvider
    implements PlatformToolProvider {
        private final Map<ToolType, CommandLineToolConfigurationInternal> commandLineToolConfigurations;
        private final VisualCppInstall visualCpp;
        private final WindowsSdk sdk;
        private final NativePlatformInternal targetPlatform;

        private VisualCppPlatformToolProvider(Map<ToolType, CommandLineToolConfigurationInternal> commandLineToolConfigurations, VisualCppInstall visualCpp, WindowsSdk sdk, NativePlatformInternal targetPlatform) {
            this.commandLineToolConfigurations = commandLineToolConfigurations;
            this.visualCpp = visualCpp;
            this.sdk = sdk;
            this.targetPlatform = targetPlatform;
        }

        public boolean isAvailable() {
            return true;
        }

        public void explain(TreeVisitor<? super String> visitor) {
        }

        @Override
        public String getObjectFileExtension() {
            return "obj";
        }

        @Override
        public String getExecutableName(String executablePath) {
            return VisualCppToolChain.this.operatingSystem.getExecutableName(executablePath);
        }

        @Override
        public String getSharedLibraryName(String libraryName) {
            return VisualCppToolChain.this.operatingSystem.getSharedLibraryName(libraryName);
        }

        @Override
        public String getStaticLibraryName(String libraryName) {
            return VisualCppToolChain.this.operatingSystem.getStaticLibraryName(libraryName);
        }

        @Override
        public String getSharedLibraryLinkFileName(String libraryName) {
            return this.getSharedLibraryName(libraryName).replaceFirst("\\.dll$", ".lib");
        }

        public <T extends CompileSpec> Compiler<T> newCompiler(T spec) {
            if (spec instanceof CppCompileSpec) {
                return this.castCompiler(this.createCppCompiler());
            }
            if (spec instanceof CCompileSpec) {
                return this.castCompiler(this.createCCompiler());
            }
            if (spec instanceof ObjectiveCppCompileSpec) {
                throw new RuntimeException("Objective-C++ is not available on the Visual C++ toolchain");
            }
            if (spec instanceof ObjectiveCCompileSpec) {
                throw new RuntimeException("Objective-C is not available on the Visual C++ toolchain");
            }
            if (spec instanceof WindowsResourceCompileSpec) {
                return this.castCompiler(this.createWindowsResourceCompiler());
            }
            if (spec instanceof AssembleSpec) {
                return this.castCompiler(this.createAssembler());
            }
            if (spec instanceof LinkerSpec) {
                return this.castCompiler(this.createLinker());
            }
            if (spec instanceof StaticLibraryArchiverSpec) {
                return this.castCompiler(this.createStaticLibraryArchiver());
            }
            throw new IllegalArgumentException(String.format("Don't know how to compile from a spec of type %s.", spec.getClass().getSimpleName()));
        }

        private <T extends CompileSpec> Compiler<T> castCompiler(Compiler<?> compiler) {
            return compiler;
        }

        public Compiler<CppCompileSpec> createCppCompiler() {
            CommandLineTool commandLineTool = this.tool("C++ compiler", this.visualCpp.getCompiler(this.targetPlatform));
            CppCompiler cppCompiler = new CppCompiler(commandLineTool, this.invocation(this.commandLineToolConfigurations.get((Object)ToolType.CPP_COMPILER)), this.addIncludePathAndDefinitions(CppCompileSpec.class));
            return new OutputCleaningCompiler<CppCompileSpec>(cppCompiler, ".obj");
        }

        public Compiler<CCompileSpec> createCCompiler() {
            CommandLineTool commandLineTool = this.tool("C compiler", this.visualCpp.getCompiler(this.targetPlatform));
            CCompiler cCompiler = new CCompiler(commandLineTool, this.invocation(this.commandLineToolConfigurations.get((Object)ToolType.C_COMPILER)), this.addIncludePathAndDefinitions(CCompileSpec.class));
            return new OutputCleaningCompiler<CCompileSpec>(cCompiler, ".obj");
        }

        public Compiler<AssembleSpec> createAssembler() {
            CommandLineTool commandLineTool = this.tool("Assembler", this.visualCpp.getAssembler(this.targetPlatform));
            return new Assembler(commandLineTool, this.invocation(this.commandLineToolConfigurations.get((Object)ToolType.ASSEMBLER)));
        }

        public Compiler<WindowsResourceCompileSpec> createWindowsResourceCompiler() {
            CommandLineTool commandLineTool = this.tool("Windows resource compiler", this.sdk.getResourceCompiler(this.targetPlatform));
            WindowsResourceCompiler windowsResourceCompiler = new WindowsResourceCompiler(commandLineTool, this.invocation(this.commandLineToolConfigurations.get((Object)ToolType.WINDOW_RESOURCES_COMPILER)), this.addIncludePathAndDefinitions(WindowsResourceCompileSpec.class));
            return new OutputCleaningCompiler<WindowsResourceCompileSpec>(windowsResourceCompiler, ".res");
        }

        public Compiler<LinkerSpec> createLinker() {
            CommandLineTool commandLineTool = this.tool("Linker", this.visualCpp.getLinker(this.targetPlatform));
            return new LinkExeLinker(commandLineTool, this.invocation(this.commandLineToolConfigurations.get((Object)ToolType.LINKER)), this.addLibraryPath());
        }

        public Compiler<StaticLibraryArchiverSpec> createStaticLibraryArchiver() {
            CommandLineTool commandLineTool = this.tool("Static library archiver", this.visualCpp.getArchiver(this.targetPlatform));
            return new LibExeStaticLibraryArchiver(commandLineTool, this.invocation(this.commandLineToolConfigurations.get((Object)ToolType.STATIC_LIB_ARCHIVER)));
        }

        private CommandLineTool tool(String toolName, File exe) {
            return new CommandLineTool(toolName, exe, VisualCppToolChain.this.execActionFactory);
        }

        private CommandLineToolInvocation invocation(CommandLineToolConfigurationInternal commandLineToolConfiguration) {
            DefaultCommandLineToolInvocation invocation = new DefaultCommandLineToolInvocation();
            invocation.addPath(this.visualCpp.getPath(this.targetPlatform));
            invocation.addPath(this.sdk.getBinDir(this.targetPlatform));
            this.clearEnvironmentVars(invocation, "INCLUDE", "CL", "LIBPATH", "LINK", "LIB");
            invocation.addPostArgsAction(commandLineToolConfiguration.getArgAction());
            return invocation;
        }

        private void clearEnvironmentVars(MutableCommandLineToolInvocation invocation, String ... names) {
            Map environmentVariables = Jvm.current().getInheritableEnvironmentVariables(System.getenv());
            for (String name : names) {
                Object value = environmentVariables.get(name);
                if (value == null) continue;
                LOGGER.warn("Ignoring value '{}' set for environment variable '{}'.", value, (Object)name);
                invocation.addEnvironmentVar(name, "");
            }
        }

        public String getOutputType() {
            return String.format("%s-%s", VisualCppToolChain.this.getName(), VisualCppToolChain.this.operatingSystem.getName());
        }

        private <T extends NativeCompileSpec> Transformer<T, T> addIncludePathAndDefinitions(Class<T> type) {
            return new Transformer<T, T>(){

                public T transform(T original) {
                    original.include(VisualCppPlatformToolProvider.this.visualCpp.getIncludePath(VisualCppPlatformToolProvider.this.targetPlatform));
                    original.include(VisualCppPlatformToolProvider.this.sdk.getIncludeDirs());
                    for (Map.Entry<String, String> definition : VisualCppPlatformToolProvider.this.visualCpp.getDefinitions(VisualCppPlatformToolProvider.this.targetPlatform).entrySet()) {
                        original.define(definition.getKey(), definition.getValue());
                    }
                    return original;
                }
            };
        }

        private Transformer<LinkerSpec, LinkerSpec> addLibraryPath() {
            return new Transformer<LinkerSpec, LinkerSpec>(){

                public LinkerSpec transform(LinkerSpec original) {
                    original.libraryPath(VisualCppPlatformToolProvider.this.visualCpp.getLibraryPath(VisualCppPlatformToolProvider.this.targetPlatform), VisualCppPlatformToolProvider.this.sdk.getLibDir(VisualCppPlatformToolProvider.this.targetPlatform));
                    return original;
                }
            };
        }
    }

    public static class DefaultVisualCppPlatformToolChain
    implements VisualCppPlatformToolChain {
        private final NativePlatform platform;
        private final Map<ToolType, CommandLineToolConfigurationInternal> tools;

        public DefaultVisualCppPlatformToolChain(NativePlatform platform, Instantiator instantiator) {
            this.platform = platform;
            this.tools = new HashMap<ToolType, CommandLineToolConfigurationInternal>();
            this.tools.put(ToolType.C_COMPILER, (CommandLineToolConfigurationInternal)instantiator.newInstance(DefaultCommandLineToolConfiguration.class, new Object[]{ToolType.C_COMPILER}));
            this.tools.put(ToolType.CPP_COMPILER, (CommandLineToolConfigurationInternal)instantiator.newInstance(DefaultCommandLineToolConfiguration.class, new Object[]{ToolType.CPP_COMPILER}));
            this.tools.put(ToolType.LINKER, (CommandLineToolConfigurationInternal)instantiator.newInstance(DefaultCommandLineToolConfiguration.class, new Object[]{ToolType.LINKER}));
            this.tools.put(ToolType.STATIC_LIB_ARCHIVER, (CommandLineToolConfigurationInternal)instantiator.newInstance(DefaultCommandLineToolConfiguration.class, new Object[]{ToolType.STATIC_LIB_ARCHIVER}));
            this.tools.put(ToolType.ASSEMBLER, (CommandLineToolConfigurationInternal)instantiator.newInstance(DefaultCommandLineToolConfiguration.class, new Object[]{ToolType.ASSEMBLER}));
            this.tools.put(ToolType.WINDOW_RESOURCES_COMPILER, (CommandLineToolConfigurationInternal)instantiator.newInstance(DefaultCommandLineToolConfiguration.class, new Object[]{ToolType.WINDOW_RESOURCES_COMPILER}));
        }

        public CommandLineToolConfiguration getcCompiler() {
            return this.tools.get((Object)ToolType.C_COMPILER);
        }

        public CommandLineToolConfiguration getCppCompiler() {
            return this.tools.get((Object)ToolType.CPP_COMPILER);
        }

        public CommandLineToolConfiguration getRcCompiler() {
            return this.tools.get((Object)ToolType.WINDOW_RESOURCES_COMPILER);
        }

        public CommandLineToolConfiguration getAssembler() {
            return this.tools.get((Object)ToolType.ASSEMBLER);
        }

        public CommandLineToolConfiguration getLinker() {
            return this.tools.get((Object)ToolType.LINKER);
        }

        public CommandLineToolConfiguration getStaticLibArchiver() {
            return this.tools.get((Object)ToolType.STATIC_LIB_ARCHIVER);
        }

        public NativePlatform getPlatform() {
            return this.platform;
        }
    }
}

