/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal;

import java.io.File;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.internal.AbstractBuildableModelElement;
import org.gradle.jvm.JvmBinaryTasks;
import org.gradle.jvm.JvmLibrarySpec;
import org.gradle.jvm.internal.DefaultJvmBinaryTasks;
import org.gradle.jvm.internal.JarBinarySpecInternal;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetContainer;
import org.gradle.platform.base.internal.BinaryNamingScheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJarBinarySpec
extends AbstractBuildableModelElement
implements JarBinarySpecInternal {
    private final LanguageSourceSetContainer sourceSets = new LanguageSourceSetContainer();
    private final JvmLibrarySpec library;
    private final BinaryNamingScheme namingScheme;
    private final JavaToolChain toolChain;
    private final JavaPlatform platform;
    private final DefaultJvmBinaryTasks tasks = new DefaultJvmBinaryTasks(this);
    private File classesDir;
    private File resourcesDir;
    private File jarFile;
    private boolean buildable;

    public DefaultJarBinarySpec(JvmLibrarySpec library, BinaryNamingScheme namingScheme, JavaToolChain toolChain, JavaPlatform platform) {
        this.library = library;
        this.namingScheme = namingScheme;
        this.toolChain = toolChain;
        this.platform = platform;
    }

    public boolean isBuildable() {
        return this.buildable;
    }

    @Override
    public void setBuildable(boolean buildable) {
        this.buildable = buildable;
    }

    public boolean isLegacyBinary() {
        return false;
    }

    public String getDisplayName() {
        return this.namingScheme.getDescription();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getName() {
        return this.namingScheme.getLifecycleTaskName();
    }

    @Override
    public JvmLibrarySpec getLibrary() {
        return this.library;
    }

    @Override
    public JavaToolChain getToolChain() {
        return this.toolChain;
    }

    @Override
    public JavaPlatform getTargetPlatform() {
        return this.platform;
    }

    public BinaryNamingScheme getNamingScheme() {
        return this.namingScheme;
    }

    public DomainObjectSet<LanguageSourceSet> getSource() {
        return this.sourceSets;
    }

    public void source(Object sources) {
        this.sourceSets.source(sources);
    }

    @Override
    public JvmBinaryTasks getTasks() {
        return this.tasks;
    }

    @Override
    public File getJarFile() {
        return this.jarFile;
    }

    @Override
    public void setJarFile(File jarFile) {
        this.jarFile = jarFile;
    }

    @Override
    public File getClassesDir() {
        return this.classesDir;
    }

    @Override
    public void setClassesDir(File classesDir) {
        this.classesDir = classesDir;
    }

    @Override
    public File getResourcesDir() {
        return this.resourcesDir;
    }

    @Override
    public void setResourcesDir(File resourcesDir) {
        this.resourcesDir = resourcesDir;
    }
}

