/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.jvm.JvmBinarySpec;
import org.gradle.jvm.JvmByteCode;
import org.gradle.jvm.JvmLibrarySpec;
import org.gradle.jvm.JvmResources;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetContainer;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentSpecIdentifier;
import org.gradle.platform.base.TransformationFileType;
import org.gradle.platform.base.internal.ComponentSpecInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJvmLibrarySpec
implements JvmLibrarySpec,
ComponentSpecInternal {
    private final LanguageSourceSetContainer sourceSets = new LanguageSourceSetContainer();
    private final FunctionalSourceSet mainSourceSet;
    private final ComponentSpecIdentifier identifier;
    private final DomainObjectSet<BinarySpec> binaries;
    private final DomainObjectSet<JvmBinarySpec> jvmBinaries;
    private final Set<Class<? extends TransformationFileType>> languageOutputs = new HashSet<Class<? extends TransformationFileType>>();
    private final List<String> targets = new ArrayList<String>();

    public DefaultJvmLibrarySpec(ComponentSpecIdentifier identifier, FunctionalSourceSet mainSourceSet) {
        this.identifier = identifier;
        this.mainSourceSet = mainSourceSet;
        this.sourceSets.addMainSources(mainSourceSet);
        this.languageOutputs.add(JvmResources.class);
        this.languageOutputs.add(JvmByteCode.class);
        this.binaries = new DefaultDomainObjectSet(JvmBinarySpec.class);
        this.jvmBinaries = this.binaries.withType(JvmBinarySpec.class);
    }

    public String getName() {
        return this.identifier.getName();
    }

    public String getProjectPath() {
        return this.identifier.getProjectPath();
    }

    public String getDisplayName() {
        return String.format("JVM library '%s'", this.getName());
    }

    public String toString() {
        return this.getDisplayName();
    }

    public DomainObjectSet<LanguageSourceSet> getSource() {
        return this.sourceSets;
    }

    public void source(Object source) {
        this.sourceSets.source(source);
    }

    public DomainObjectSet<BinarySpec> getBinaries() {
        return this.binaries;
    }

    public FunctionalSourceSet getMainSource() {
        return this.mainSourceSet;
    }

    public Set<Class<? extends TransformationFileType>> getInputTypes() {
        return this.languageOutputs;
    }

    public List<String> getTargetPlatforms() {
        return Lists.newArrayList(this.targets);
    }

    public void targetPlatform(String ... targets) {
        Collections.addAll(this.targets, targets);
    }
}

