/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal.configure;

import org.gradle.api.Action;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.jvm.JarBinarySpec;
import org.gradle.jvm.JvmLibrarySpec;
import org.gradle.jvm.internal.DefaultJarBinarySpec;
import org.gradle.jvm.internal.configure.JarBinariesFactory;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.platform.base.internal.BinaryNamingScheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJarBinariesFactory
implements JarBinariesFactory {
    private final Instantiator instantiator;
    private final Action<? super JarBinarySpec> configureAction;

    public DefaultJarBinariesFactory(Instantiator instantiator, Action<? super JarBinarySpec> configureAction) {
        this.instantiator = instantiator;
        this.configureAction = configureAction;
    }

    @Override
    public void createJarBinaries(JvmLibrarySpec jvmLibrary, BinaryNamingScheme namingScheme, JavaToolChain toolChain, JavaPlatform platform) {
        DefaultJarBinarySpec jarBinary = (DefaultJarBinarySpec)this.instantiator.newInstance(DefaultJarBinarySpec.class, new Object[]{jvmLibrary, namingScheme, toolChain, platform});
        this.setupDefaults(jarBinary);
        jarBinary.source(jvmLibrary.getSource());
        jvmLibrary.getBinaries().add((Object)jarBinary);
    }

    private void setupDefaults(DefaultJarBinarySpec jarBinary) {
        this.configureAction.execute((Object)jarBinary);
    }
}

